/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.dao;

import com.xiaomi.youpin.docean.anno.Service;
import com.xiaomi.youpin.docean.plugin.dubbo.anno.Reference;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.app.api.response.AppBaseInfo;
import org.apache.ozhera.app.api.service.HeraAppService;
import org.apache.ozhera.log.api.enums.ProjectTypeEnum;
import org.apache.ozhera.log.manager.model.pojo.MilogAppTopicRelDO;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.Sqls;
import org.nutz.dao.impl.NutDao;
import org.nutz.dao.pager.Pager;
import org.nutz.dao.sql.Sql;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
public class MilogAppTopicRelDao {
    private static final Logger log = LoggerFactory.getLogger(MilogAppTopicRelDao.class);
    @Resource
    private NutDao dao;
    @Reference(interfaceClass=HeraAppService.class, group="$dubbo.env.group", check=false)
    private HeraAppService heraAppService;

    public MilogAppTopicRelDO insert(MilogAppTopicRelDO milogAppTopicRel) {
        return (MilogAppTopicRelDO)this.dao.insert((Object)milogAppTopicRel);
    }

    public List<MilogAppTopicRelDO> queryAppInfo(Long appId, String appName, Long tenantId, String source) {
        return this.queryAppInfo(appId, appName, tenantId, source, null);
    }

    public List<MilogAppTopicRelDO> queryAppInfo(Long appId, String appName, Long tenantId, String source, Integer appType) {
        Cnd cnd = Cnd.where((String)"app_id", (String)"=", (Object)appId);
        if (StringUtils.isNotEmpty((CharSequence)appName)) {
            cnd.andEX("app_name", "=", (Object)appName);
        }
        if (null != tenantId) {
            cnd.andEX("tenant_id", "=", (Object)tenantId);
        }
        if (null != appType) {
            cnd.andEX("type", "=", (Object)appType);
        }
        if (StringUtils.isNotEmpty((CharSequence)source)) {
            cnd.andEX("source", "=", (Object)source);
        }
        return this.dao.query(MilogAppTopicRelDO.class, (Condition)cnd);
    }

    public void deleteAppTopicRelDb(Long appId, String appName, Long tenantId, String source) {
        List<MilogAppTopicRelDO> milogAppTopicRels = this.queryAppInfo(appId, appName, tenantId, source);
        if (CollectionUtils.isNotEmpty(milogAppTopicRels)) {
            this.dao.delete(MilogAppTopicRelDO.class, milogAppTopicRels.get(0).getId().longValue());
        }
    }

    public MilogAppTopicRelDO queryByAppId(Long appId, String source) {
        List milogAppTopicRels;
        Cnd cnd = Cnd.where((String)"app_id", (String)"=", (Object)appId);
        if (StringUtils.isNotEmpty((CharSequence)source)) {
            cnd.andEX("source", "=", (Object)source);
        }
        if (CollectionUtils.isNotEmpty((Collection)(milogAppTopicRels = this.dao.query(MilogAppTopicRelDO.class, (Condition)cnd)))) {
            return (MilogAppTopicRelDO)milogAppTopicRels.get(milogAppTopicRels.size() - 1);
        }
        return null;
    }

    public MilogAppTopicRelDO queryByAppId(Long appId, Integer type) {
        List milogAppTopicRels;
        Cnd cnd = Cnd.where((String)"app_id", (String)"=", (Object)appId);
        if (null != type) {
            cnd.andEX("type", "=", (Object)type);
        }
        if (CollectionUtils.isNotEmpty((Collection)(milogAppTopicRels = this.dao.query(MilogAppTopicRelDO.class, (Condition)cnd)))) {
            return (MilogAppTopicRelDO)milogAppTopicRels.get(milogAppTopicRels.size() - 1);
        }
        return null;
    }

    public List<MilogAppTopicRelDO> queryByMilogAppIds(List<Long> milogAppIds) {
        Cnd cnd = Cnd.where((String)"id", (String)"IN", milogAppIds);
        return this.dao.query(MilogAppTopicRelDO.class, (Condition)cnd);
    }

    public List<MilogAppTopicRelDO> queryAppInfoByName(String appName, Integer type) {
        Cnd cnd = Cnd.where((String)"type", (String)"=", (Object)type);
        if (StringUtils.isNotEmpty((CharSequence)appName)) {
            cnd.and("app_name", "like", (Object)("%" + appName + "%"));
        }
        List ret = this.dao.query(MilogAppTopicRelDO.class, (Condition)cnd);
        return ret;
    }

    public List<MilogAppTopicRelDO> queryAppInfoByName(String appName, String source, Integer type) {
        Cnd cnd = Cnd.NEW();
        if (StringUtils.isNotEmpty((CharSequence)appName)) {
            Cnd.where((String)"app_name", (String)"like", (Object)("%" + appName + "%"));
        }
        if (null != type) {
            cnd.and("type", "=", (Object)type);
        } else {
            cnd.and("source", "=", (Object)source);
        }
        List ret = this.dao.query(MilogAppTopicRelDO.class, (Condition)cnd);
        return ret;
    }

    public List<MilogAppTopicRelDO> queryAppInfoByNameSource(String appName, String source, Integer type) {
        Cnd cnd = Cnd.NEW();
        if (StringUtils.isNotEmpty((CharSequence)appName)) {
            Cnd.where((String)"app_name", (String)"like", (Object)("%" + appName + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)source)) {
            cnd.and("source", "=", (Object)source);
        }
        if (null != type) {
            cnd.and("type", "=", (Object)type);
        }
        List ret = this.dao.query(MilogAppTopicRelDO.class, (Condition)cnd);
        return ret;
    }

    public List<MilogAppTopicRelDO> queryAppTopicList(Condition cnd, Pager pager) {
        if (null == pager) {
            return this.dao.query(MilogAppTopicRelDO.class, cnd);
        }
        return this.dao.query(MilogAppTopicRelDO.class, cnd, pager);
    }

    public void updateTopicName(Long appId, String topicNameSimple) {
    }

    public MilogAppTopicRelDO queryById(Long id) {
        AppBaseInfo appBaseInfo = this.heraAppService.queryById(id);
        MilogAppTopicRelDO milogAppTopicRelDO = new MilogAppTopicRelDO();
        milogAppTopicRelDO.setId(appBaseInfo.getId().longValue());
        milogAppTopicRelDO.setAppId(Long.valueOf(appBaseInfo.getBindId()));
        milogAppTopicRelDO.setAppName(appBaseInfo.getAppName());
        if (CollectionUtils.isNotEmpty((Collection)appBaseInfo.getTreeIds())) {
            milogAppTopicRelDO.setTreeIds(appBaseInfo.getTreeIds().stream().map(Integer::longValue).collect(Collectors.toList()));
        }
        milogAppTopicRelDO.setSource(appBaseInfo.getPlatformName());
        milogAppTopicRelDO.setType(appBaseInfo.getPlatformType());
        return milogAppTopicRelDO;
    }

    public void updateAppTopicRelMqConfigById(Long id, String existTopic) {
    }

    public Integer queryAppTopicPageCount(Condition cnd) {
        return this.dao.count(MilogAppTopicRelDO.class, cnd);
    }

    public void delTopicRecordAll() {
        this.dao.delete(MilogAppTopicRelDO.class);
    }

    public List<MilogAppTopicRelDO> queryAllMilogAppList() {
        return this.queryAppTopicList((Condition)Cnd.NEW(), null);
    }

    public List<MilogAppTopicRelDO> queryAllAccessMilogAppList() {
        Sql sql = Sqls.queryEntity((String)"SELECT\n\tmt.* \nFROM\n\tmilog_app_topic_rel mt\n\tLEFT JOIN ( SELECT DISTINCT milog_app_id FROM milog_logstail ) ml ON mt.id = ml.milog_app_id \nWHERE  ml.milog_app_id IS NOT NULL");
        sql.setEntity(this.dao.getEntity(MilogAppTopicRelDO.class));
        this.dao.execute(sql);
        return sql.getList(MilogAppTopicRelDO.class);
    }

    public List<MilogAppTopicRelDO> queryAppsExistInMachine(String ip) {
        Sql sql = Sqls.queryEntity((String)"SELECT mt.* FROM milog_app_topic_rel mt LEFT JOIN( SELECT DISTINCT ml.app_id,ms.source FROM milog_logstail ml LEFT JOIN milog_space ms ON ml.space_id = ms.id WHERE JSON_CONTAINS( ml.ips, JSON_ARRAY( @ip)) ) ma ON mt.app_id = ma.app_id and mt.source = ma.source WHERE ma.app_id IS NOT NULL");
        sql.params().set("ip", (Object)ip);
        sql.setEntity(this.dao.getEntity(MilogAppTopicRelDO.class));
        this.dao.execute(sql);
        return sql.getList(MilogAppTopicRelDO.class);
    }

    public MilogAppTopicRelDO queryByIpAndAppid(Long appId, String ip) {
        Sql sql = Sqls.queryEntity((String)"SELECT mt.* FROM milog_app_topic_rel mt LEFT JOIN( SELECT DISTINCT ml.app_id,ms.source FROM milog_logstail ml LEFT JOIN milog_space ms ON ml.space_id = ms.id WHERE JSON_CONTAINS( ml.ips, JSON_ARRAY( @ip)) ) ma ON mt.app_id = ma.app_id and mt.source = ma.source WHERE ma.app_id =@appId");
        sql.params().set("ip", (Object)ip);
        sql.params().set("appId", (Object)appId);
        sql.setEntity(this.dao.getEntity(MilogAppTopicRelDO.class));
        this.dao.execute(sql);
        return (MilogAppTopicRelDO)sql.getList(MilogAppTopicRelDO.class).get(0);
    }

    public int getAppCount() {
        return this.dao.count(MilogAppTopicRelDO.class);
    }

    public List<MilogAppTopicRelDO> getMioneAppAll(String source) {
        Cnd cnd = Cnd.where((String)"source", (String)"=", (Object)source).and("type", "=", (Object)ProjectTypeEnum.MIONE_TYPE.getCode());
        return this.dao.query(MilogAppTopicRelDO.class, (Condition)cnd);
    }

    public MilogAppTopicRelDO queryIsExists(MilogAppTopicRelDO milogAppTopicRel) {
        Cnd cnd = Cnd.where((String)"app_id", (String)"=", (Object)milogAppTopicRel.getAppId()).and("source", "=", (Object)milogAppTopicRel.getSource()).and("type", "=", (Object)milogAppTopicRel.getType());
        List appTopicRels = this.dao.query(MilogAppTopicRelDO.class, (Condition)cnd);
        if (CollectionUtils.isNotEmpty((Collection)appTopicRels)) {
            return (MilogAppTopicRelDO)appTopicRels.get(appTopicRels.size() - 1);
        }
        return null;
    }

    public void insertNoExists(MilogAppTopicRelDO milogAppTopicRel) {
        MilogAppTopicRelDO appTopicRel = this.queryIsExists(milogAppTopicRel);
        if (null == appTopicRel) {
            this.dao.insert((Object)milogAppTopicRel);
        } else if (null != milogAppTopicRel.getNodeIPs() && milogAppTopicRel.getNodeIPs().size() > 0 && (null == appTopicRel.getNodeIPs() || appTopicRel.getNodeIPs().size() == 0 || milogAppTopicRel.getNodeIPs().size() != appTopicRel.getNodeIPs().size())) {
            appTopicRel.setNodeIPs(milogAppTopicRel.getNodeIPs());
            this.dao.update((Object)appTopicRel);
        }
    }

    public void update(MilogAppTopicRelDO milogAppTopicRel) {
        this.dao.update((Object)milogAppTopicRel);
    }

    public MilogAppTopicRelDO queryByIamTreeId(Long iamTreeId) {
        Cnd cnd = Cnd.where((String)"iam_tree_id", (String)"=", (Object)iamTreeId);
        List appTopicRels = this.dao.query(MilogAppTopicRelDO.class, (Condition)cnd);
        if (CollectionUtils.isNotEmpty((Collection)appTopicRels)) {
            return (MilogAppTopicRelDO)appTopicRels.get(appTopicRels.size() - 1);
        }
        return null;
    }

    public void deleteByAppIds(Long appId, String source) {
        MilogAppTopicRelDO appTopicRel = this.queryByAppId(appId, source);
        if (null != appTopicRel) {
            this.dao.delete(MilogAppTopicRelDO.class, appTopicRel.getId().longValue());
        }
    }

    public List<MilogAppTopicRelDO> queryAppInfoByChinaCondition(Long appId, Long iamTreeId) {
        Cnd cnd = Cnd.where((String)"app_id", (String)"=", (Object)appId);
        if (null != iamTreeId) {
            cnd.andEX("iam_tree_id", "=", (Object)iamTreeId);
        }
        List appTopicRels = this.dao.query(MilogAppTopicRelDO.class, (Condition)cnd);
        return appTopicRels;
    }

    public List<MilogAppTopicRelDO> queryByIds(List<Long> ids) {
        Cnd cnd = Cnd.where((String)"id", (String)"IN", ids);
        return this.dao.query(MilogAppTopicRelDO.class, (Condition)cnd);
    }

    public List<MilogAppTopicRelDO> queryAppbyNameSource(String appName, String source) {
        Cnd cnd = Cnd.where((String)"app_name", (String)"=", (Object)appName).and("source", "=", (Object)source);
        return this.dao.query(MilogAppTopicRelDO.class, (Condition)cnd);
    }

    public List<MilogAppTopicRelDO> queryAppbyName(String appName) {
        Cnd cnd = Cnd.where((String)"app_name", (String)"=", (Object)appName);
        return this.dao.query(MilogAppTopicRelDO.class, (Condition)cnd);
    }
}

