/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.common;

import com.alibaba.nacos.api.config.ConfigFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.google.gson.Gson;
import com.xiaomi.data.push.nacos.NacosNaming;
import com.xiaomi.youpin.docean.anno.Bean;
import com.xiaomi.youpin.docean.anno.Configuration;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.OkHttpClient;
import org.apache.ozhera.log.common.Config;

@Configuration
public class MilogConfig {
    private String defaultNacosAddres = Config.ins().get("defaultNacosAddres", "");

    @Bean
    public ConfigService nacosConfigService() throws Exception {
        return ConfigFactory.createConfigService((String)this.defaultNacosAddres);
    }

    @Bean
    public NacosNaming nacosNaming() {
        return MilogConfig.buildNacosNaming(this.defaultNacosAddres);
    }

    public static NacosNaming buildNacosNaming(String nacosAddress) {
        NacosNaming nacosNaming = new NacosNaming();
        nacosNaming.setServerAddr(nacosAddress);
        nacosNaming.init();
        return nacosNaming;
    }

    @Bean
    public Gson gson() {
        return new Gson();
    }

    @Bean
    public OkHttpClient okHttpClient() {
        return new OkHttpClient().newBuilder().connectTimeout(60000L, TimeUnit.MILLISECONDS).readTimeout(300000L, TimeUnit.MILLISECONDS).writeTimeout(300000L, TimeUnit.MILLISECONDS).connectionPool(new ConnectionPool(10, 5L, TimeUnit.MINUTES)).build();
    }
}

