/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.schema;

import com.alibaba.fastjson2.schema.FormatValidator;
import java.nio.ByteBuffer;

final class IPAddressValidator
implements FormatValidator {
    static final IPAddressValidator IPV6 = new IPAddressValidator(false);
    static final IPAddressValidator IPV4 = new IPAddressValidator(true);
    final boolean v4;

    public IPAddressValidator(boolean v4) {
        this.v4 = v4;
    }

    @Override
    public boolean isValid(String address) {
        if (address == null) {
            return false;
        }
        if (!IPAddressValidator.isInetAddress(address)) {
            return false;
        }
        if (this.v4) {
            return address.indexOf(46) != -1;
        }
        return address.indexOf(58) != -1;
    }

    static boolean isInetAddress(String ip) {
        String ipString = ip;
        boolean hasColon = false;
        boolean hasDot = false;
        int percentIndex = -1;
        for (int i = 0; i < ipString.length(); ++i) {
            char c = ipString.charAt(i);
            if (c == '.') {
                hasDot = true;
                continue;
            }
            if (c == ':') {
                if (hasDot) {
                    return false;
                }
                hasColon = true;
                continue;
            }
            if (c == '%') {
                percentIndex = i;
                break;
            }
            if (Character.digit(c, 16) != -1) continue;
            return false;
        }
        if (hasColon) {
            if (hasDot && (ipString = IPAddressValidator.convertDottedQuadToHex(ipString)) == null) {
                return false;
            }
            if (percentIndex != -1) {
                ipString = ipString.substring(0, percentIndex);
            }
            return IPAddressValidator.numericFormatV6(ipString);
        }
        if (hasDot) {
            if (percentIndex != -1) {
                return false;
            }
            return IPAddressValidator.textToNumericFormatV4(ipString) != null;
        }
        return false;
    }

    static String convertDottedQuadToHex(String ipString) {
        int lastColon = ipString.lastIndexOf(58);
        String initialPart = ipString.substring(0, lastColon + 1);
        String dottedQuad = ipString.substring(lastColon + 1);
        byte[] quad = IPAddressValidator.textToNumericFormatV4(dottedQuad);
        if (quad == null) {
            return null;
        }
        String penultimate = Integer.toHexString((quad[0] & 0xFF) << 8 | quad[1] & 0xFF);
        String ultimate = Integer.toHexString((quad[2] & 0xFF) << 8 | quad[3] & 0xFF);
        return initialPart + penultimate + ":" + ultimate;
    }

    private static byte[] textToNumericFormatV4(String ipString) {
        int dotCount = 0;
        for (int i = 0; i < ipString.length(); ++i) {
            if (ipString.charAt(i) != '.') continue;
            ++dotCount;
        }
        if (dotCount + 1 != 4) {
            return null;
        }
        byte[] bytes = new byte[4];
        int start = 0;
        for (int i = 0; i < 4; ++i) {
            int end = ipString.indexOf(46, start);
            if (end == -1) {
                end = ipString.length();
            }
            try {
                bytes[i] = IPAddressValidator.parseOctet(ipString, start, end);
            }
            catch (NumberFormatException ex) {
                return null;
            }
            start = end + 1;
        }
        return bytes;
    }

    private static boolean numericFormatV6(String ipString) {
        int IPV6_PART_COUNT = 8;
        int delimiterCount = 0;
        for (int i = 0; i < ipString.length(); ++i) {
            if (ipString.charAt(i) != ':') continue;
            ++delimiterCount;
        }
        if (delimiterCount < 2 || delimiterCount > 8) {
            return false;
        }
        int partsSkipped = 8 - (delimiterCount + 1);
        boolean hasSkip = false;
        for (int i = 0; i < ipString.length() - 1; ++i) {
            if (ipString.charAt(i) != ':' || ipString.charAt(i + 1) != ':') continue;
            if (hasSkip) {
                return false;
            }
            hasSkip = true;
            ++partsSkipped;
            if (i == 0) {
                ++partsSkipped;
            }
            if (i != ipString.length() - 2) continue;
            ++partsSkipped;
        }
        if (ipString.charAt(0) == ':' && ipString.charAt(1) != ':') {
            return false;
        }
        if (ipString.charAt(ipString.length() - 1) == ':' && ipString.charAt(ipString.length() - 2) != ':') {
            return false;
        }
        if (hasSkip && partsSkipped <= 0) {
            return false;
        }
        if (!hasSkip && delimiterCount + 1 != 8) {
            return false;
        }
        ByteBuffer rawBytes = ByteBuffer.allocate(16);
        try {
            int start = 0;
            if (ipString.charAt(0) == ':') {
                start = 1;
            }
            while (start < ipString.length()) {
                int end = ipString.indexOf(58, start);
                if (end == -1) {
                    end = ipString.length();
                }
                if (ipString.charAt(start) == ':') {
                    for (int i = 0; i < partsSkipped; ++i) {
                        rawBytes.putShort((short)0);
                    }
                } else {
                    rawBytes.putShort(IPAddressValidator.parseHextet(ipString, start, end));
                }
                start = end + 1;
            }
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return true;
    }

    private static byte parseOctet(String ipString, int start, int end) {
        int length = end - start;
        if (length <= 0 || length > 3) {
            throw new NumberFormatException();
        }
        if (length > 1 && ipString.charAt(start) == '0') {
            throw new NumberFormatException();
        }
        int octet = 0;
        for (int i = start; i < end; ++i) {
            octet *= 10;
            int digit = Character.digit(ipString.charAt(i), 10);
            if (digit < 0) {
                throw new NumberFormatException();
            }
            octet += digit;
        }
        if (octet > 255) {
            throw new NumberFormatException();
        }
        return (byte)octet;
    }

    private static short parseHextet(String ipString, int start, int end) {
        int length = end - start;
        if (length <= 0 || length > 4) {
            throw new NumberFormatException();
        }
        int hextet = 0;
        for (int i = start; i < end; ++i) {
            hextet <<= 4;
            hextet |= Character.digit(ipString.charAt(i), 16);
        }
        return (short)hextet;
    }
}

