/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReaderDateTimeCodec;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderImplInstant;
import com.alibaba.fastjson2.schema.JSONSchema;
import com.alibaba.fastjson2.util.DateUtils;
import com.alibaba.fastjson2.util.UnsafeUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Locale;
import java.util.function.BiConsumer;

public class FieldReaderInstant<T>
extends FieldReaderDateTimeCodec<T> {
    final BiConsumer<T, Instant> function;

    FieldReaderInstant(String fieldName, Type fieldType, Class fieldClass, int ordinal, long features, String format, Locale locale, Object defaultValue, JSONSchema schema, Field field, Method method, BiConsumer<T, Instant> function) {
        super(fieldName, fieldType, fieldClass, ordinal, features, format, locale, defaultValue, schema, method, field);
        this.function = function;
    }

    @Override
    protected void accept(T object, LocalDateTime ldt) {
        ZoneOffset offset = DateUtils.DEFAULT_ZONE_ID.getRules().getOffset(ldt);
        Instant instant = ldt.toInstant(offset);
        this.accept(object, instant);
    }

    @Override
    protected void accept(T object, Date value) {
        this.accept(object, value.toInstant());
    }

    @Override
    protected void accept(T object, ZonedDateTime zdt) {
        this.accept(object, zdt.toInstant());
    }

    @Override
    protected Object apply(Date value) {
        return value.toInstant();
    }

    @Override
    protected Object apply(Instant value) {
        return value;
    }

    @Override
    protected Object apply(ZonedDateTime zdt) {
        return zdt.toInstant();
    }

    @Override
    protected Object apply(LocalDateTime ldt) {
        ZoneOffset offset = DateUtils.DEFAULT_ZONE_ID.getRules().getOffset(ldt);
        return ldt.toInstant(offset);
    }

    @Override
    protected Object apply(long millis) {
        return Instant.ofEpochMilli(millis);
    }

    @Override
    protected void acceptNull(T object) {
        this.accept(object, (Instant)null);
    }

    @Override
    public void accept(T object, long milli) {
        this.accept(object, Instant.ofEpochMilli(milli));
    }

    @Override
    protected void accept(T object, Instant instant) {
        if (this.schema != null) {
            this.schema.assertValidate(instant);
        }
        if (object == null) {
            throw new JSONException("set " + this.fieldName + " error, object is null");
        }
        if (instant == null && (this.features & JSONReader.Feature.IgnoreSetNullValue.mask) != 0L) {
            return;
        }
        if (this.function != null) {
            this.function.accept(object, instant);
            return;
        }
        if (this.method != null) {
            try {
                this.method.invoke(object, instant);
            }
            catch (Exception e) {
                throw new JSONException("set " + this.fieldName + " error", e);
            }
            return;
        }
        if (this.fieldOffset != -1L) {
            UnsafeUtils.putObject(object, this.fieldOffset, instant);
            return;
        }
        try {
            this.field.set(object, instant);
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
    }

    @Override
    public ObjectReader getObjectReader(JSONReader jsonReader) {
        if (this.dateReader == null) {
            this.dateReader = this.format == null ? ObjectReaderImplInstant.INSTANCE : new ObjectReaderImplInstant(this.format, this.locale);
        }
        return this.dateReader;
    }

    @Override
    public ObjectReader getObjectReader(JSONReader.Context context) {
        if (this.dateReader == null) {
            this.dateReader = this.format == null ? ObjectReaderImplInstant.INSTANCE : new ObjectReaderImplInstant(this.format, this.locale);
        }
        return this.dateReader;
    }
}

