/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.entity.schema;

import org.apache.hugegraph.exception.InternalException;
import org.apache.hugegraph.structure.constant.HugeType;

public enum SchemaType {
    PROPERTY_KEY("property key"),
    VERTEX_LABEL("vertex label"),
    EDGE_LABEL("edge label"),
    PROPERTY_INDEX("property index");

    private String name;

    private SchemaType(String name) {
        this.name = name;
    }

    public String string() {
        return this.name;
    }

    public boolean isPropertyKey() {
        return this == PROPERTY_KEY;
    }

    public boolean isVertexLabel() {
        return this == VERTEX_LABEL;
    }

    public boolean isEdgeLabel() {
        return this == EDGE_LABEL;
    }

    public boolean isPropertyIndex() {
        return this == PROPERTY_INDEX;
    }

    public static SchemaType convert(HugeType type) {
        switch (type) {
            case PROPERTY_KEY: {
                return PROPERTY_KEY;
            }
            case VERTEX_LABEL: {
                return VERTEX_LABEL;
            }
            case EDGE_LABEL: {
                return EDGE_LABEL;
            }
            case INDEX_LABEL: {
                return PROPERTY_INDEX;
            }
        }
        throw new InternalException("Can't convert HugeType '%s' to SchemaType", type);
    }
}

