/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.watch;

import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import org.apache.hugegraph.pd.KvService;
import org.apache.hugegraph.pd.common.PDException;
import org.apache.hugegraph.pd.config.PDConfig;
import org.apache.hugegraph.pd.grpc.kv.WatchEvent;
import org.apache.hugegraph.pd.grpc.kv.WatchKv;
import org.apache.hugegraph.pd.grpc.kv.WatchResponse;
import org.apache.hugegraph.pd.grpc.kv.WatchState;
import org.apache.hugegraph.pd.grpc.kv.WatchType;
import org.apache.hugegraph.pd.raft.RaftEngine;
import org.apache.hugegraph.pd.store.RaftKVStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KvWatchSubject {
    private static final Logger log = LoggerFactory.getLogger(KvWatchSubject.class);
    public static final String KEY_DELIMITER = "KW";
    public static final String PREFIX_DELIMITER = "PW";
    public static final String ALL_PREFIX = "W";
    public static final long WATCH_TTL = 1800000L;
    private static final ConcurrentMap<String, StreamObserver<WatchResponse>> clients = new ConcurrentHashMap();
    private KvService kvService;
    BiPredicate<String, String> equal = (kvKey, watchKey) -> kvKey.equals(watchKey);
    BiPredicate<String, String> startWith = (kvKey, watchKey) -> kvKey.startsWith((String)watchKey);

    public KvWatchSubject(PDConfig pdConfig) {
        this.kvService = new KvService(pdConfig);
    }

    public String getWatchKey(String key, String watchDelimiter) {
        return KvService.getKeyWithoutPrefix((Object[])new Object[]{ALL_PREFIX, watchDelimiter, key});
    }

    private void addWatchKey(String key, String delimiter, long clientId) throws PDException {
        String watchKey = KvService.getKeyWithoutPrefix((Object[])new Object[]{ALL_PREFIX, delimiter, key, clientId});
        this.kvService.put(watchKey, "", 1800000L);
        String clientFirstKey = KvService.getKeyWithoutPrefix((Object[])new Object[]{ALL_PREFIX, clientId, delimiter, key, clientId});
        this.kvService.put(clientFirstKey, "", 1800000L);
    }

    private void removeWatchKey(String key, String delimiter, long clientId) throws PDException {
        String watchKey = KvService.getKeyWithoutPrefix((Object[])new Object[]{ALL_PREFIX, delimiter, key, clientId});
        this.kvService.delete(watchKey);
        String clientFirstKey = KvService.getKeyWithoutPrefix((Object[])new Object[]{ALL_PREFIX, clientId, delimiter, key});
        this.kvService.deleteWithPrefix(clientFirstKey);
    }

    public void addObserver(String key, long clientId, StreamObserver<WatchResponse> observer, String delimiter) throws PDException {
        String keyWithoutPrefix = KvService.getKeyWithoutPrefix((Object[])new Object[]{ALL_PREFIX, delimiter, key, clientId});
        clients.putIfAbsent(keyWithoutPrefix, observer);
        this.addWatchKey(key, delimiter, clientId);
        log.info("client:{},start to watch key:{}", (Object)clientId, (Object)key);
    }

    public void removeObserver(String key, long clientId, String delimiter) throws PDException {
        this.removeWatchKey(key, delimiter, clientId);
        String keyWithoutPrefix = KvService.getKeyWithoutPrefix((Object[])new Object[]{ALL_PREFIX, delimiter, key, clientId});
        clients.remove(keyWithoutPrefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyObserver(String key, WatchType watchType, BiPredicate<String, String> predicate, WatchKv ... kvs) throws PDException {
        boolean isEqual = predicate.equals(this.equal);
        String watchDelimiter = isEqual ? KEY_DELIMITER : PREFIX_DELIMITER;
        String watchKeyPrefix = isEqual ? key : "";
        String storeKey = this.getWatchKey(watchKeyPrefix, watchDelimiter);
        Map map = this.kvService.scanWithPrefix(storeKey);
        String delimiter = String.valueOf('@');
        for (String keyAndClient : map.keySet()) {
            String[] values = keyAndClient.split(delimiter);
            assert (values.length == 4);
            String watchKey = values[2];
            String c = values[3];
            long clientId = Long.parseLong(c);
            LinkedList<WatchEvent> watchEvents = new LinkedList<WatchEvent>();
            for (WatchKv kv : kvs) {
                String kvKey = kv.getKey();
                boolean match = predicate.test(kvKey, watchKey);
                if (!match) continue;
                WatchKv watchKv = WatchKv.newBuilder().setKey(kvKey).setValue(kv.getValue()).build();
                WatchEvent event = WatchEvent.newBuilder().setCurrent(watchKv).setType(watchType).build();
                watchEvents.add(event);
            }
            StreamObserver observer = (StreamObserver)clients.get(keyAndClient);
            WatchResponse watchResponse = WatchResponse.newBuilder().setState(WatchState.Started).setClientId(clientId).addAllEvents(watchEvents).build();
            try {
                if (observer != null) {
                    StreamObserver streamObserver = observer;
                    synchronized (streamObserver) {
                        observer.onNext((Object)watchResponse);
                        continue;
                    }
                }
                log.info("cannot find StreamObserver for clientId:{}", (Object)clientId);
            }
            catch (StatusRuntimeException statusRuntimeException) {
            }
            catch (Exception e) {
                log.warn("notifyObserver with error:{}", (Object)clientId, (Object)e);
            }
        }
    }

    public void notifyAllObserver(String key, WatchType watchType, WatchKv[] kvs) throws PDException {
        this.notifyObserver(key, watchType, this.equal, kvs);
        this.notifyObserver(key, watchType, this.startWith, kvs);
    }

    public void keepClientAlive() {
        WatchResponse testAlive = WatchResponse.newBuilder().setState(WatchState.Alive).build();
        Set entries = clients.entrySet();
        Map.Entry[] array = entries.toArray(new Map.Entry[0]);
        ((Stream)Arrays.stream(array).parallel()).forEach(entry -> {
            StreamObserver value = (StreamObserver)entry.getValue();
            String key = (String)entry.getKey();
            String delimiter = KvService.getDelimiter();
            String client = key.split(delimiter)[3];
            String clientKey = KvService.getKeyWithoutPrefix((Object[])new Object[]{ALL_PREFIX, client});
            if (value == null) {
                this.removeClient(null, key, clientKey);
            }
            boolean done = false;
            String removes = client + "@";
            for (int i = 0; i < 3; ++i) {
                try {
                    StreamObserver streamObserver = value;
                    synchronized (streamObserver) {
                        value.onNext((Object)testAlive);
                    }
                    Map clientKeys = this.kvService.scanWithPrefix(clientKey);
                    Set set = clientKeys.entrySet();
                    for (Map.Entry keyEntry : set) {
                        String entryKey = (String)keyEntry.getKey();
                        String aliveKey = entryKey.replaceFirst(removes, "");
                        this.kvService.keepAlive(aliveKey);
                        this.kvService.keepAlive(entryKey);
                        done = true;
                    }
                    break;
                }
                catch (Exception e) {
                    if (e instanceof StatusRuntimeException && ((StatusRuntimeException)((Object)e)).getStatus().getCode().equals((Object)Status.Code.CANCELLED)) break;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ex) {
                        log.info("keep alive client {} with error:{}", (Object)client, (Object)e);
                    }
                    continue;
                }
            }
            if (!done) {
                log.info("remove client {} for no data", (Object)client);
                this.removeClient(value, key, clientKey);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeClient(StreamObserver<WatchResponse> value, String key, String clientKey) {
        try {
            StreamObserver<WatchResponse> store;
            log.info("remove null observer,client:", (Object)clientKey);
            if (RaftEngine.getInstance().isLeader()) {
                this.kvService.deleteWithPrefix(clientKey);
            } else {
                store = this.kvService.getMeta().getStore();
                if (store instanceof RaftKVStore) {
                    ((RaftKVStore)store).doRemoveByPrefix(this.kvService.getStoreKey(clientKey));
                }
            }
            if (value != null) {
                store = value;
                synchronized (store) {
                    try {
                        value.onCompleted();
                    }
                    catch (Exception e) {
                        log.warn("Exception occurred while completing observer for removeClient {}: {}", new Object[]{clientKey, e.toString(), e});
                    }
                }
            }
            clients.remove(key);
        }
        catch (PDException e) {
            log.error("remove client with error:", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyClientChangeLeader() {
        WatchResponse response = WatchResponse.newBuilder().setState(WatchState.Leader_Changed).build();
        block7: for (Map.Entry entry : clients.entrySet()) {
            StreamObserver value = (StreamObserver)entry.getValue();
            String key = (String)entry.getKey();
            String client = key.split(KvService.getDelimiter())[3];
            String clientKey = KvService.getKeyWithoutPrefix((Object[])new Object[]{ALL_PREFIX, client});
            if (value == null) {
                this.removeClient(null, key, clientKey);
            }
            for (int i = 0; i < 3; ++i) {
                try {
                    StreamObserver streamObserver = value;
                    synchronized (streamObserver) {
                        value.onNext((Object)response);
                    }
                    this.removeClient(value, key, clientKey);
                    continue block7;
                }
                catch (Exception e) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
            }
        }
    }
}

