/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.traversers;

import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Singleton;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import java.util.Map;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.core.GraphManager;
import org.apache.hugegraph.structure.HugeVertex;
import org.apache.hugegraph.traversal.algorithm.HugeTraverser;
import org.apache.hugegraph.traversal.algorithm.PersonalRankTraverser;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

@Path(value="graphspaces/{graphspace}/graphs/{graph}/traversers/personalrank")
@Singleton
@Tag(name="PersonalRankAPI")
public class PersonalRankAPI
extends API {
    private static final Logger LOG = Log.logger(PersonalRankAPI.class);
    private static final double DEFAULT_DIFF = 1.0E-4;
    private static final double DEFAULT_ALPHA = 0.85;
    private static final int DEFAULT_DEPTH = 5;

    @POST
    @Timed
    @Produces(value={"application/json;charset=UTF-8"})
    public String personalRank(@Context GraphManager manager, @PathParam(value="graphspace") String graphSpace, @PathParam(value="graph") String graph, RankRequest request) {
        E.checkArgumentNotNull((Object)request, (String)"The rank request body can't be null", (Object[])new Object[0]);
        E.checkArgument((request.source != null ? 1 : 0) != 0, (String)"The source vertex id of rank request can't be null", (Object[])new Object[0]);
        E.checkArgument((request.label != null ? 1 : 0) != 0, (String)"The edge label of rank request can't be null", (Object[])new Object[0]);
        E.checkArgument((request.alpha > 0.0 && request.alpha <= 1.0 ? 1 : 0) != 0, (String)"The alpha of rank request must be in range (0, 1], but got '%s'", (Object[])new Object[]{request.alpha});
        E.checkArgument((request.maxDiff > 0.0 && request.maxDiff <= 1.0 ? 1 : 0) != 0, (String)"The max diff of rank request must be in range (0, 1], but got '%s'", (Object[])new Object[]{request.maxDiff});
        E.checkArgument((request.maxDegree > 0L || request.maxDegree == -1L ? 1 : 0) != 0, (String)"The max degree of rank request must be > 0 or == -1, but got: %s", (Object[])new Object[]{request.maxDegree});
        E.checkArgument(((long)request.limit > 0L || (long)request.limit == -1L ? 1 : 0) != 0, (String)"The limit of rank request must be > 0 or == -1, but got: %s", (Object[])new Object[]{request.limit});
        E.checkArgument(((long)request.maxDepth > 1L && request.maxDepth <= 5000 ? 1 : 0) != 0, (String)"The max depth of rank request must be in range (1, %s], but got '%s'", (Object[])new Object[]{5000, request.maxDepth});
        LOG.debug("Graph [{}] get personal rank from '{}' with edge label '{}', alpha '{}', maxDegree '{}', max depth '{}' and sorted '{}'", new Object[]{graph, request.source, request.label, request.alpha, request.maxDegree, request.maxDepth, request.sorted});
        Id sourceId = HugeVertex.getIdValue((Object)request.source);
        HugeGraph g = PersonalRankAPI.graph(manager, graphSpace, graph);
        PersonalRankTraverser traverser = new PersonalRankTraverser(g, request.alpha, request.maxDegree, request.maxDepth);
        Map ranks = traverser.personalRank(sourceId, request.label, request.withLabel);
        ranks = HugeTraverser.topN((Map)ranks, (boolean)request.sorted, (long)request.limit);
        return manager.serializer().writeMap(ranks);
    }

    private static class RankRequest {
        @JsonProperty(value="source")
        private Object source;
        @JsonProperty(value="label")
        private String label;
        @JsonProperty(value="alpha")
        private double alpha = 0.85;
        @JsonProperty(value="max_diff")
        private double maxDiff = 1.0E-4;
        @JsonProperty(value="max_degree")
        private long maxDegree = Long.parseLong("10000");
        @JsonProperty(value="limit")
        private int limit = Integer.parseInt("100");
        @JsonProperty(value="max_depth")
        private int maxDepth = 5;
        @JsonProperty(value="with_label")
        private PersonalRankTraverser.WithLabel withLabel = PersonalRankTraverser.WithLabel.BOTH_LABEL;
        @JsonProperty(value="sorted")
        private boolean sorted = true;

        private RankRequest() {
        }

        public String toString() {
            return String.format("RankRequest{source=%s,label=%s,alpha=%s,maxDiff=%s,maxDegree=%s,limit=%s,maxDepth=%s,withLabel=%s,sorted=%s}", this.source, this.label, this.alpha, this.maxDiff, this.maxDegree, this.limit, this.maxDepth, this.withLabel, this.sorted);
        }
    }
}

