/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.client.interceptor;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.pd.common.Cache;
import org.apache.hugegraph.pd.common.Consts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Authentication
implements ClientInterceptor {
    private static final Logger log = LoggerFactory.getLogger(Authentication.class);
    private static Cache<String> cache = new Cache();
    private static long ttl = 3600L;
    private String authority;
    private String name;

    public Authentication(String userName, String authority) {
        assert (!StringUtils.isEmpty((CharSequence)userName));
        this.name = userName;
        this.authority = authority;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

            public void sendMessage(ReqT message) {
                super.sendMessage(message);
            }

            public void start(ClientCall.Listener<RespT> listener, Metadata headers) {
                if (StringUtils.isEmpty((CharSequence)Authentication.this.authority) || StringUtils.isEmpty((CharSequence)Authentication.this.name)) {
                    throw new RuntimeException("invalid user name or password,access denied");
                }
                headers.put(Consts.CREDENTIAL_KEY, (Object)Authentication.this.authority);
                String token = (String)cache.get(Authentication.this.name);
                if (token != null) {
                    headers.put(Consts.TOKEN_KEY, (Object)((String)cache.get(Authentication.this.name)));
                }
                ForwardingClientCallListener.SimpleForwardingClientCallListener callListener = new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(listener){

                    public void onMessage(RespT message) {
                        super.onMessage(message);
                    }

                    public void onHeaders(Metadata headers) {
                        super.onHeaders(headers);
                        String t = (String)headers.get(Consts.TOKEN_KEY);
                        cache.put(Authentication.this.name, (Object)t, ttl);
                    }

                    public void onClose(Status status, Metadata trailers) {
                        super.onClose(status, trailers);
                    }
                };
                super.start((ClientCall.Listener)callListener, headers);
            }
        };
    }
}

