/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.traversal.optimize;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.hugegraph.backend.query.Aggregate;
import org.apache.hugegraph.traversal.optimize.HugeCountStep;
import org.apache.hugegraph.traversal.optimize.HugeGraphStep;
import org.apache.hugegraph.traversal.optimize.HugeGraphStepStrategy;
import org.apache.hugegraph.traversal.optimize.HugeVertexStepStrategy;
import org.apache.hugegraph.traversal.optimize.TraversalUtil;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.CountGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.NoOpBarrierStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.AggregateGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.AggregateLocalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.IdentityStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.SideEffectStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.CollectingBarrierStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;

public final class HugeCountStepStrategy
extends AbstractTraversalStrategy<TraversalStrategy.ProviderOptimizationStrategy>
implements TraversalStrategy.ProviderOptimizationStrategy {
    private static final long serialVersionUID = -3910433925919057771L;
    private static final HugeCountStepStrategy INSTANCE = new HugeCountStepStrategy();

    private HugeCountStepStrategy() {
    }

    public void apply(Traversal.Admin<?, ?> traversal) {
        TraversalUtil.convAllHasSteps(traversal);
        List steps = TraversalHelper.getStepsOfClass(CountGlobalStep.class, traversal);
        if (steps.isEmpty()) {
            return;
        }
        CountGlobalStep originStep = (CountGlobalStep)steps.get(0);
        ArrayList<CountGlobalStep> originSteps = new ArrayList<CountGlobalStep>();
        HugeGraphStep graphStep = null;
        CountGlobalStep step = originStep;
        do {
            if (!(step instanceof CountGlobalStep) && !(step instanceof GraphStep) && !(step instanceof IdentityStep) && !(step instanceof NoOpBarrierStep) && !(step instanceof CollectingBarrierStep) || step instanceof TraversalParent && TraversalHelper.anyStepRecursively(s -> s instanceof SideEffectStep || s instanceof AggregateGlobalStep || s instanceof AggregateLocalStep, (TraversalParent)((TraversalParent)step))) {
                return;
            }
            originSteps.add(step);
            if (!(step instanceof HugeGraphStep)) continue;
            graphStep = (HugeGraphStep)step;
            break;
        } while ((step = step.getPreviousStep()) != null);
        if (graphStep == null) {
            return;
        }
        graphStep.queryInfo().aggregate(Aggregate.AggregateFunc.COUNT, null);
        HugeCountStep countStep = new HugeCountStep(traversal, graphStep);
        for (Step step2 : originSteps) {
            TraversalHelper.copyLabels((Step)step2, countStep, (boolean)false);
            traversal.removeStep(step2);
        }
        traversal.addStep(0, countStep);
    }

    public Set<Class<? extends TraversalStrategy.ProviderOptimizationStrategy>> applyPrior() {
        return Collections.singleton(HugeGraphStepStrategy.class);
    }

    public Set<Class<? extends TraversalStrategy.ProviderOptimizationStrategy>> applyPost() {
        return Collections.singleton(HugeVertexStepStrategy.class);
    }

    public static HugeCountStepStrategy instance() {
        return INSTANCE;
    }
}

