/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.task;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hugegraph.HugeException;
import org.apache.hugegraph.HugeGraphParams;
import org.apache.hugegraph.concurrent.PausableScheduledThreadPool;
import org.apache.hugegraph.task.DistributedTaskScheduler;
import org.apache.hugegraph.task.HugeTask;
import org.apache.hugegraph.task.ServerInfoManager;
import org.apache.hugegraph.task.StandardTaskScheduler;
import org.apache.hugegraph.task.TaskScheduler;
import org.apache.hugegraph.type.define.NodeRole;
import org.apache.hugegraph.util.Consumers;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.ExecutorUtil;
import org.apache.hugegraph.util.LockUtil;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public final class TaskManager {
    private static final Logger LOG = Log.logger(TaskManager.class);
    public static final String TASK_WORKER_PREFIX = "task-worker";
    public static final String TASK_WORKER = "task-worker-%d";
    public static final String TASK_DB_WORKER = "task-db-worker-%d";
    public static final String SERVER_INFO_DB_WORKER = "server-info-db-worker-%d";
    public static final String TASK_SCHEDULER = "task-scheduler-%d";
    public static final String OLAP_TASK_WORKER = "olap-task-worker-%d";
    public static final String SCHEMA_TASK_WORKER = "schema-task-worker-%d";
    public static final String EPHEMERAL_TASK_WORKER = "ephemeral-task-worker-%d";
    public static final String DISTRIBUTED_TASK_SCHEDULER = "distributed-scheduler-%d";
    static final long SCHEDULE_PERIOD = 1000L;
    private static final long TX_CLOSE_TIMEOUT = 30L;
    private static final int THREADS = 4;
    private static final TaskManager MANAGER = new TaskManager(4);
    private final Map<HugeGraphParams, TaskScheduler> schedulers = new ConcurrentHashMap<HugeGraphParams, TaskScheduler>();
    private final ExecutorService taskExecutor;
    private final ExecutorService taskDbExecutor;
    private final ExecutorService serverInfoDbExecutor;
    private final PausableScheduledThreadPool schedulerExecutor;
    private final ExecutorService schemaTaskExecutor;
    private final ExecutorService olapTaskExecutor;
    private final ExecutorService ephemeralTaskExecutor;
    private final PausableScheduledThreadPool distributedSchedulerExecutor;
    private boolean enableRoleElected = false;
    private static final ThreadLocal<String> CONTEXTS = new ThreadLocal();

    public static TaskManager instance() {
        return MANAGER;
    }

    private TaskManager(int pool) {
        this.taskExecutor = ExecutorUtil.newFixedThreadPool((int)pool, (String)TASK_WORKER);
        this.taskDbExecutor = ExecutorUtil.newFixedThreadPool((int)1, (String)TASK_DB_WORKER);
        this.serverInfoDbExecutor = ExecutorUtil.newFixedThreadPool((int)1, (String)SERVER_INFO_DB_WORKER);
        this.schemaTaskExecutor = ExecutorUtil.newFixedThreadPool((int)pool, (String)SCHEMA_TASK_WORKER);
        this.olapTaskExecutor = ExecutorUtil.newFixedThreadPool((int)pool, (String)OLAP_TASK_WORKER);
        this.ephemeralTaskExecutor = ExecutorUtil.newFixedThreadPool((int)pool, (String)EPHEMERAL_TASK_WORKER);
        this.distributedSchedulerExecutor = ExecutorUtil.newPausableScheduledThreadPool((int)1, (String)DISTRIBUTED_TASK_SCHEDULER);
        this.schedulerExecutor = ExecutorUtil.newPausableScheduledThreadPool((int)1, (String)TASK_SCHEDULER);
        this.schedulerExecutor.scheduleWithFixedDelay(this::scheduleOrExecuteJob, 10000L, 1000L, TimeUnit.MILLISECONDS);
    }

    public void addScheduler(HugeGraphParams graph) {
        E.checkArgumentNotNull((Object)graph, (String)"The graph can't be null", (Object[])new Object[0]);
        LOG.info("Use {} as the scheduler of graph ({})", (Object)graph.schedulerType(), (Object)graph.name());
        switch (graph.schedulerType()) {
            case "distributed": {
                DistributedTaskScheduler scheduler = new DistributedTaskScheduler(graph, (ScheduledThreadPoolExecutor)this.distributedSchedulerExecutor, this.taskDbExecutor, this.schemaTaskExecutor, this.olapTaskExecutor, this.taskExecutor, this.ephemeralTaskExecutor, this.serverInfoDbExecutor);
                this.schedulers.put(graph, scheduler);
                break;
            }
            default: {
                StandardTaskScheduler scheduler = new StandardTaskScheduler(graph, this.taskExecutor, this.taskDbExecutor, this.serverInfoDbExecutor);
                this.schedulers.put(graph, scheduler);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeScheduler(HugeGraphParams graph) {
        TaskScheduler scheduler = this.schedulers.get(graph);
        if (scheduler != null) {
            TaskScheduler taskScheduler = scheduler;
            synchronized (taskScheduler) {
                if (scheduler.close()) {
                    this.schedulers.remove(graph);
                }
            }
        }
        if (!this.taskExecutor.isTerminated()) {
            this.closeTaskTx(graph);
        }
        if (!this.schedulerExecutor.isTerminated()) {
            this.closeSchedulerTx(graph);
        }
        if (!this.distributedSchedulerExecutor.isTerminated()) {
            this.closeDistributedSchedulerTx(graph);
        }
    }

    public void forceRemoveScheduler(HugeGraphParams params) {
        this.schedulers.remove(params);
    }

    private void closeTaskTx(HugeGraphParams graph) {
        boolean selfIsTaskWorker = Thread.currentThread().getName().startsWith(TASK_WORKER_PREFIX);
        int totalThreads = selfIsTaskWorker ? 3 : 4;
        try {
            if (selfIsTaskWorker) {
                graph.closeTx();
            } else {
                Consumers.executeOncePerThread(this.taskExecutor, totalThreads, graph::closeTx, 30L);
            }
        }
        catch (Exception e) {
            throw new HugeException("Exception when closing task tx", e);
        }
    }

    private void closeSchedulerTx(HugeGraphParams graph) {
        Callable<Void> closeTx = () -> {
            graph.closeTx();
            Thread.yield();
            return null;
        };
        try {
            this.schedulerExecutor.submit(closeTx).get();
        }
        catch (Exception e) {
            throw new HugeException("Exception when closing scheduler tx", e);
        }
    }

    private void closeDistributedSchedulerTx(HugeGraphParams graph) {
        Callable<Void> closeTx = () -> {
            graph.closeTx();
            Thread.yield();
            return null;
        };
        try {
            this.distributedSchedulerExecutor.submit(closeTx).get();
        }
        catch (Exception e) {
            throw new HugeException("Exception when closing scheduler tx", e);
        }
    }

    public void pauseScheduledThreadPool() {
        this.schedulerExecutor.pauseSchedule();
    }

    public void resumeScheduledThreadPool() {
        this.schedulerExecutor.resumeSchedule();
    }

    public TaskScheduler getScheduler(HugeGraphParams graph) {
        return this.schedulers.get(graph);
    }

    public ServerInfoManager getServerInfoManager(HugeGraphParams graph) {
        TaskScheduler scheduler = this.getScheduler(graph);
        if (scheduler == null) {
            return null;
        }
        return scheduler.serverManager();
    }

    public void shutdown(long timeout) {
        assert (this.schedulers.isEmpty()) : this.schedulers.size();
        Throwable ex = null;
        boolean terminated = this.schedulerExecutor.isTerminated();
        TimeUnit unit = TimeUnit.SECONDS;
        if (!this.schedulerExecutor.isShutdown()) {
            this.schedulerExecutor.shutdown();
            try {
                terminated = this.schedulerExecutor.awaitTermination(timeout, unit);
            }
            catch (Throwable e) {
                ex = e;
            }
        }
        if (terminated && !this.distributedSchedulerExecutor.isShutdown()) {
            this.distributedSchedulerExecutor.shutdown();
            try {
                terminated = this.distributedSchedulerExecutor.awaitTermination(timeout, unit);
            }
            catch (Throwable e) {
                ex = e;
            }
        }
        if (terminated && !this.taskExecutor.isShutdown()) {
            this.taskExecutor.shutdown();
            try {
                terminated = this.taskExecutor.awaitTermination(timeout, unit);
            }
            catch (Throwable e) {
                ex = e;
            }
        }
        if (terminated && !this.serverInfoDbExecutor.isShutdown()) {
            this.serverInfoDbExecutor.shutdown();
            try {
                terminated = this.serverInfoDbExecutor.awaitTermination(timeout, unit);
            }
            catch (Throwable e) {
                ex = e;
            }
        }
        if (terminated && !this.taskDbExecutor.isShutdown()) {
            this.taskDbExecutor.shutdown();
            try {
                terminated = this.taskDbExecutor.awaitTermination(timeout, unit);
            }
            catch (Throwable e) {
                ex = e;
            }
        }
        if (terminated && !this.ephemeralTaskExecutor.isShutdown()) {
            this.ephemeralTaskExecutor.shutdown();
            try {
                terminated = this.ephemeralTaskExecutor.awaitTermination(timeout, unit);
            }
            catch (Throwable e) {
                ex = e;
            }
        }
        if (terminated && !this.schemaTaskExecutor.isShutdown()) {
            this.schemaTaskExecutor.shutdown();
            try {
                terminated = this.schemaTaskExecutor.awaitTermination(timeout, unit);
            }
            catch (Throwable e) {
                ex = e;
            }
        }
        if (terminated && !this.olapTaskExecutor.isShutdown()) {
            this.olapTaskExecutor.shutdown();
            try {
                terminated = this.olapTaskExecutor.awaitTermination(timeout, unit);
            }
            catch (Throwable e) {
                ex = e;
            }
        }
        if (!terminated) {
            ex = new TimeoutException(timeout + "s");
        }
        if (ex != null) {
            throw new HugeException("Failed to wait for TaskScheduler", ex);
        }
    }

    public int workerPoolSize() {
        return ((ThreadPoolExecutor)this.taskExecutor).getCorePoolSize();
    }

    public int pendingTasks() {
        int size = 0;
        for (TaskScheduler scheduler : this.schedulers.values()) {
            size += scheduler.pendingTasks();
        }
        return size;
    }

    public void enableRoleElection() {
        this.enableRoleElected = true;
    }

    public void onAsRoleMaster() {
        try {
            for (TaskScheduler entry : this.schedulers.values()) {
                ServerInfoManager serverInfoManager = entry.serverManager();
                if (serverInfoManager != null) {
                    serverInfoManager.changeServerRole(NodeRole.MASTER);
                    continue;
                }
                LOG.warn("ServerInfoManager is null for graph {}", (Object)entry.spaceGraphName());
            }
        }
        catch (Throwable e) {
            LOG.error("Exception occurred when change to master role", e);
            throw e;
        }
    }

    public void onAsRoleWorker() {
        try {
            for (TaskScheduler entry : this.schedulers.values()) {
                ServerInfoManager serverInfoManager = entry.serverManager();
                if (serverInfoManager != null) {
                    serverInfoManager.changeServerRole(NodeRole.WORKER);
                    continue;
                }
                LOG.warn("ServerInfoManager is null for graph {}", (Object)entry.spaceGraphName());
            }
        }
        catch (Throwable e) {
            LOG.error("Exception occurred when change to worker role", e);
            throw e;
        }
    }

    void notifyNewTask(HugeTask<?> task) {
        BlockingQueue queue = this.schedulerExecutor.getQueue();
        if (queue.size() <= 1) {
            this.schedulerExecutor.submit(this::scheduleOrExecuteJob);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void scheduleOrExecuteJob() {
        try {
            Iterator<TaskScheduler> iterator = this.schedulers.values().iterator();
            while (iterator.hasNext()) {
                TaskScheduler entry;
                TaskScheduler taskScheduler = entry = iterator.next();
                synchronized (taskScheduler) {
                    this.scheduleOrExecuteJobForGraph(entry);
                }
            }
            return;
        }
        catch (Throwable e) {
            LOG.error("Exception occurred when schedule job", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleOrExecuteJobForGraph(TaskScheduler scheduler) {
        E.checkNotNull((Object)scheduler, (String)"scheduler");
        if (scheduler instanceof StandardTaskScheduler) {
            StandardTaskScheduler standardTaskScheduler = (StandardTaskScheduler)scheduler;
            ServerInfoManager serverManager = scheduler.serverManager();
            String spaceGraphName = scheduler.spaceGraphName();
            LockUtil.lock(spaceGraphName, "graph_lock");
            try {
                if (!serverManager.graphIsReady()) {
                    return;
                }
                serverManager.heartbeat();
                if (serverManager.selfIsMaster()) {
                    standardTaskScheduler.scheduleTasksOnMaster();
                    if (!this.enableRoleElected && !serverManager.onlySingleNode()) {
                        return;
                    }
                }
                standardTaskScheduler.executeTasksOnWorker(serverManager.selfNodeId());
                standardTaskScheduler.cancelTasksOnWorker(serverManager.selfNodeId());
            }
            finally {
                LockUtil.unlock(spaceGraphName, "graph_lock");
            }
        }
    }

    public static void setContext(String context) {
        CONTEXTS.set(context);
    }

    public static void resetContext() {
        CONTEXTS.remove();
    }

    public static String getContext() {
        return CONTEXTS.get();
    }

    public static class ContextCallable<V>
    implements Callable<V> {
        private final Callable<V> callable;
        private final String context;

        public ContextCallable(Callable<V> callable) {
            E.checkNotNull(callable, (String)"callable");
            this.context = TaskManager.getContext();
            this.callable = callable;
        }

        @Override
        public V call() throws Exception {
            TaskManager.setContext(this.context);
            try {
                V v = this.callable.call();
                return v;
            }
            finally {
                TaskManager.resetContext();
            }
        }
    }
}

