/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.id;

import java.util.Objects;
import java.util.UUID;
import org.apache.hugegraph.backend.id.EdgeId;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.serializer.BytesBuffer;
import org.apache.hugegraph.structure.HugeVertex;
import org.apache.hugegraph.util.Bytes;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.LongEncoding;
import org.apache.hugegraph.util.NumericUtil;
import org.apache.hugegraph.util.StringEncoding;

public abstract class IdGenerator {
    public static final Id ZERO = IdGenerator.of(0L);

    public abstract Id generate(HugeVertex var1);

    public static Id of(String id) {
        return new StringId(id);
    }

    public static Id of(UUID id) {
        return new UuidId(id);
    }

    public static Id of(String id, boolean uuid) {
        return uuid ? new UuidId(id) : new StringId(id);
    }

    public static Id of(long id) {
        return new LongId(id);
    }

    public static Id of(Object id) {
        if (id instanceof Id) {
            return (Id)id;
        }
        if (id instanceof String) {
            return IdGenerator.of((String)id);
        }
        if (id instanceof Number) {
            return IdGenerator.of(((Number)id).longValue());
        }
        if (id instanceof UUID) {
            return IdGenerator.of((UUID)id);
        }
        return new ObjectId(id);
    }

    public static Id of(byte[] bytes, Id.IdType type) {
        switch (type) {
            case LONG: {
                return new LongId(bytes);
            }
            case UUID: {
                return new UuidId(bytes);
            }
            case STRING: {
                return new StringId(bytes);
            }
        }
        throw new AssertionError((Object)("Invalid id type " + String.valueOf((Object)type)));
    }

    public static Id ofStoredString(String id, Id.IdType type) {
        switch (type) {
            case LONG: {
                return IdGenerator.of(LongEncoding.decodeSignedB64((String)id));
            }
            case UUID: {
                byte[] bytes = StringEncoding.decodeBase64(id);
                return IdGenerator.of(bytes, Id.IdType.UUID);
            }
            case STRING: {
                return IdGenerator.of(id);
            }
        }
        throw new AssertionError((Object)("Invalid id type " + String.valueOf((Object)type)));
    }

    public static String asStoredString(Id id) {
        switch (id.type()) {
            case LONG: {
                return LongEncoding.encodeSignedB64((long)id.asLong());
            }
            case UUID: {
                return StringEncoding.encodeBase64(id.asBytes());
            }
            case STRING: {
                return id.asString();
            }
        }
        throw new AssertionError((Object)("Invalid id type " + String.valueOf((Object)id.type())));
    }

    public static Id.IdType idType(Id id) {
        if (id instanceof LongId) {
            return Id.IdType.LONG;
        }
        if (id instanceof UuidId) {
            return Id.IdType.UUID;
        }
        if (id instanceof StringId) {
            return Id.IdType.STRING;
        }
        if (id instanceof EdgeId) {
            return Id.IdType.EDGE;
        }
        return Id.IdType.UNKNOWN;
    }

    public static int compareType(Id id1, Id id2) {
        return IdGenerator.idType(id1).ordinal() - IdGenerator.idType(id2).ordinal();
    }

    public static class ObjectId
    implements Id {
        protected Object object;

        public ObjectId(Object object) {
            E.checkNotNull((Object)object, (String)"object");
            this.object = object;
        }

        @Override
        public Id.IdType type() {
            return Id.IdType.UNKNOWN;
        }

        @Override
        public Object asObject() {
            return this.object;
        }

        @Override
        public String asString() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long asLong() {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] asBytes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int length() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int compareTo(Id o) {
            throw new UnsupportedOperationException();
        }

        public int hashCode() {
            return this.object.hashCode();
        }

        public boolean equals(Object other) {
            if (!(other instanceof ObjectId)) {
                return false;
            }
            return Objects.equals(this.object, ((ObjectId)other).object);
        }

        public String toString() {
            return this.object.toString();
        }
    }

    public static class UuidId
    implements Id {
        protected UUID uuid;

        public UuidId(String string) {
            this(StringEncoding.uuid(string));
        }

        public UuidId(byte[] bytes) {
            this(UuidId.fromBytes(bytes));
        }

        public UuidId(UUID uuid) {
            E.checkArgument((uuid != null ? 1 : 0) != 0, (String)"The uuid can't be null", (Object[])new Object[0]);
            this.uuid = uuid;
        }

        @Override
        public Id.IdType type() {
            return Id.IdType.UUID;
        }

        @Override
        public Object asObject() {
            return this.uuid;
        }

        @Override
        public String asString() {
            return this.uuid.toString();
        }

        @Override
        public long asLong() {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] asBytes() {
            BytesBuffer buffer = BytesBuffer.allocate(16);
            buffer.writeLong(this.uuid.getMostSignificantBits());
            buffer.writeLong(this.uuid.getLeastSignificantBits());
            return buffer.bytes();
        }

        private static UUID fromBytes(byte[] bytes) {
            E.checkArgument((bytes != null ? 1 : 0) != 0, (String)"The UUID can't be null", (Object[])new Object[0]);
            BytesBuffer buffer = BytesBuffer.wrap(bytes);
            long high = buffer.readLong();
            long low = buffer.readLong();
            return new UUID(high, low);
        }

        @Override
        public int length() {
            return 16;
        }

        @Override
        public int compareTo(Id other) {
            E.checkNotNull((Object)other, (String)"compare id");
            int cmp = IdGenerator.compareType(this, other);
            if (cmp != 0) {
                return cmp;
            }
            return this.uuid.compareTo(((UuidId)other).uuid);
        }

        public int hashCode() {
            return this.uuid.hashCode();
        }

        public boolean equals(Object other) {
            if (!(other instanceof UuidId)) {
                return false;
            }
            return this.uuid.equals(((UuidId)other).uuid);
        }

        public String toString() {
            return this.uuid.toString();
        }
    }

    public static class LongId
    extends Number
    implements Id {
        private static final long serialVersionUID = -7732461469037400190L;
        protected Long id;

        public LongId(long id) {
            this.id = id;
        }

        public LongId(byte[] bytes) {
            this.id = NumericUtil.bytesToLong((byte[])bytes);
        }

        @Override
        public Id.IdType type() {
            return Id.IdType.LONG;
        }

        @Override
        public Object asObject() {
            return this.id;
        }

        @Override
        public String asString() {
            return Long.toString(this.id);
        }

        @Override
        public long asLong() {
            return this.id;
        }

        @Override
        public byte[] asBytes() {
            return NumericUtil.longToBytes((long)this.id);
        }

        @Override
        public int length() {
            return 8;
        }

        @Override
        public int compareTo(Id other) {
            int cmp = IdGenerator.compareType(this, other);
            if (cmp != 0) {
                return cmp;
            }
            return Long.compare(this.id, other.asLong());
        }

        public int hashCode() {
            return Long.hashCode(this.id);
        }

        public boolean equals(Object other) {
            if (!(other instanceof Number)) {
                return false;
            }
            return this.id.longValue() == ((Number)other).longValue();
        }

        public String toString() {
            return String.valueOf(this.id);
        }

        @Override
        public int intValue() {
            return this.id.intValue();
        }

        @Override
        public long longValue() {
            return this.id;
        }

        @Override
        public float floatValue() {
            return this.id.longValue();
        }

        @Override
        public double doubleValue() {
            return this.id.longValue();
        }
    }

    public static class StringId
    implements Id {
        protected String id;
        protected byte[] bytes;

        public StringId(String id) {
            E.checkArgument((id != null && !id.isEmpty() ? 1 : 0) != 0, (String)"The id can't be null or empty", (Object[])new Object[0]);
            this.id = id;
            this.bytes = null;
        }

        public StringId(byte[] bytes) {
            E.checkArgument((bytes != null && bytes.length > 0 ? 1 : 0) != 0, (String)"The id bytes can't be null or empty", (Object[])new Object[0]);
            this.bytes = bytes;
            this.id = null;
        }

        @Override
        public Id.IdType type() {
            return Id.IdType.STRING;
        }

        @Override
        public Object asObject() {
            return this.asString();
        }

        @Override
        public String asString() {
            if (this.id == null) {
                assert (this.bytes != null);
                this.id = StringEncoding.decode(this.bytes);
            }
            return this.id;
        }

        @Override
        public long asLong() {
            return Long.parseLong(this.asString());
        }

        @Override
        public byte[] asBytes() {
            if (this.bytes == null) {
                assert (this.id != null);
                this.bytes = StringEncoding.encode(this.id);
            }
            return this.bytes;
        }

        @Override
        public int length() {
            return this.asString().length();
        }

        @Override
        public int compareTo(Id other) {
            int cmp = IdGenerator.compareType(this, other);
            if (cmp != 0) {
                return cmp;
            }
            if (this.id != null) {
                return this.id.compareTo(other.asString());
            }
            return Bytes.compare((byte[])this.bytes, (byte[])other.asBytes());
        }

        public int hashCode() {
            return this.asString().hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof StringId)) {
                return false;
            }
            StringId other = (StringId)obj;
            if (this.id != null) {
                return this.id.equals(other.asString());
            }
            if (other.bytes == null) {
                return this.asString().equals(other.asString());
            }
            assert (this.bytes != null);
            return Bytes.equals((byte[])this.bytes, (byte[])other.asBytes());
        }

        public String toString() {
            return this.asString();
        }
    }
}

