/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.baserpc.client.loadbalancer;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.bifromq.baserpc.client.loadbalancer.IServerGroupRouter;
import org.apache.bifromq.baserpc.client.loadbalancer.ITenantRouter;
import org.apache.bifromq.baserpc.client.loadbalancer.TrieMap;
import org.apache.bifromq.baserpc.client.loadbalancer.WeightedServerGroupRouter;

class TenantRouter
implements ITenantRouter {
    private final Map<String, Boolean> allServers;
    private final TrieMap<WeightedServerGroupRouter> matcher = new TrieMap();

    TenantRouter() {
        this(Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap());
    }

    TenantRouter(Map<String, Boolean> allServers, Map<String, Map<String, Integer>> trafficDirective, Map<String, Set<String>> serverGroupTags) {
        this.allServers = allServers;
        HashSet defaultLBGroup = Sets.newHashSet();
        HashMap lbGroups = Maps.newHashMap();
        for (String serverId : serverGroupTags.keySet()) {
            Set<String> groupTags = serverGroupTags.get(serverId);
            if (groupTags.isEmpty()) {
                defaultLBGroup.add(serverId);
                continue;
            }
            groupTags.forEach(lbGroupTag -> lbGroups.computeIfAbsent(lbGroupTag, l -> Sets.newHashSet()).add(serverId));
        }
        this.prepareMatcher("", Collections.singletonMap("", 1), Collections.singletonMap("", defaultLBGroup));
        for (String tenantIdPrefix : trafficDirective.keySet()) {
            if (tenantIdPrefix.isEmpty()) continue;
            this.prepareMatcher(tenantIdPrefix, trafficDirective.get(tenantIdPrefix), lbGroups);
        }
    }

    private void prepareMatcher(String tenantIdPrefix, Map<String, Integer> serverWeights, Map<String, Set<String>> serverGroups) {
        this.matcher.put(tenantIdPrefix, new WeightedServerGroupRouter(this.allServers, serverWeights, serverGroups));
    }

    @Override
    public IServerGroupRouter get(String tenantId) {
        return this.matcher.bestMatch(tenantId);
    }
}

