/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.baserpc.client;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.Context;
import io.grpc.MethodDescriptor;
import io.grpc.stub.ClientCalls;
import io.grpc.stub.StreamObserver;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.bifromq.baserpc.BluePrint;
import org.apache.bifromq.baserpc.RPCContext;
import org.apache.bifromq.baserpc.client.IUnaryCaller;
import org.apache.bifromq.baserpc.client.exception.ExceptionUtil;
import org.apache.bifromq.baserpc.client.exception.ServerNotFoundException;
import org.apache.bifromq.baserpc.client.exception.ServiceUnavailableException;
import org.apache.bifromq.baserpc.client.loadbalancer.IServerGroupRouter;
import org.apache.bifromq.baserpc.client.loadbalancer.IServerSelector;
import org.apache.bifromq.baserpc.metrics.IRPCMeter;
import org.apache.bifromq.baserpc.metrics.RPCMetric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UnaryCaller<ReqT, RespT>
implements IUnaryCaller<ReqT, RespT> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UnaryCaller.class);
    private final Supplier<IServerSelector> serverSelectorSupplier;
    private final Channel channel;
    private final MethodDescriptor<ReqT, RespT> methodDesc;
    private final BluePrint.MethodSemantic semantic;
    private final CallOptions callOptions;
    private final IRPCMeter.IRPCMethodMeter meter;
    private final AtomicInteger counter;

    UnaryCaller(Supplier<IServerSelector> serverSelectorSupplier, Channel channel, CallOptions callOptions, MethodDescriptor<ReqT, RespT> methodDesc, BluePrint bluePrint, IRPCMeter.IRPCMethodMeter meter, AtomicInteger counter) {
        assert (methodDesc.getType() == MethodDescriptor.MethodType.UNARY);
        this.semantic = bluePrint.semantic(methodDesc.getFullMethodName());
        assert (this.semantic instanceof BluePrint.Unary);
        this.serverSelectorSupplier = serverSelectorSupplier;
        this.channel = channel;
        this.methodDesc = methodDesc;
        this.callOptions = callOptions;
        this.meter = meter;
        this.counter = counter;
    }

    @Override
    public CompletableFuture<RespT> invoke(String tenantId, String targetServerId, ReqT req, Map<String, String> metadata) {
        String finalServerId;
        IServerSelector serverSelector = this.serverSelectorSupplier.get();
        IServerGroupRouter router = serverSelector.get(tenantId);
        switch (this.semantic.mode()) {
            case DDBalanced: {
                assert (targetServerId != null);
                if (serverSelector.exists(targetServerId)) {
                    finalServerId = targetServerId;
                    break;
                }
                return CompletableFuture.failedFuture(new ServerNotFoundException("Server not found: " + targetServerId));
            }
            case WCHBalanced: {
                assert (this.semantic instanceof BluePrint.WCHBalancedReq);
                String wchKey = ((BluePrint.WCHBalancedReq)this.semantic).hashKey(req);
                assert (wchKey != null);
                Optional<String> selectedServerId = router.hashing(wchKey);
                if (selectedServerId.isPresent()) {
                    finalServerId = selectedServerId.get();
                    break;
                }
                return CompletableFuture.failedFuture(new ServiceUnavailableException("Service unavailable for " + this.methodDesc.getFullMethodName()));
            }
            case WRBalanced: {
                assert (this.semantic instanceof BluePrint.WRUnaryMethod);
                Optional<String> selectedServerId = router.random();
                if (selectedServerId.isPresent()) {
                    finalServerId = selectedServerId.get();
                    break;
                }
                return CompletableFuture.failedFuture(new ServiceUnavailableException("Service unavailable for " + this.methodDesc.getFullMethodName()));
            }
            case WRRBalanced: {
                assert (this.semantic instanceof BluePrint.WRRUnaryMethod);
                Optional<String> selectedServerId = router.roundRobin();
                if (selectedServerId.isPresent()) {
                    finalServerId = selectedServerId.get();
                    break;
                }
                return CompletableFuture.failedFuture(new ServiceUnavailableException("Service unavailable for " + this.methodDesc.getFullMethodName()));
            }
            default: {
                return CompletableFuture.failedFuture(new IllegalStateException("Unknown balance mode: " + String.valueOf(this.semantic.mode())));
            }
        }
        Context ctx = Context.ROOT.fork().withValue(RPCContext.TENANT_ID_CTX_KEY, (Object)tenantId).withValue(RPCContext.DESIRED_SERVER_ID_CTX_KEY, (Object)finalServerId);
        return (CompletableFuture)ctx.call(() -> {
            final long startNano = System.nanoTime();
            final CompletableFuture future = new CompletableFuture();
            int currentCount = this.counter.incrementAndGet();
            this.meter.recordCount(RPCMetric.UnaryReqSendCount);
            this.meter.recordSummary(RPCMetric.UnaryReqDepth, currentCount);
            ClientCalls.asyncUnaryCall((ClientCall)this.channel.newCall(this.methodDesc, this.callOptions), (Object)req, (StreamObserver)new StreamObserver<RespT>(){

                public void onNext(RespT resp) {
                    long l = System.nanoTime() - startNano;
                    UnaryCaller.this.meter.timer(RPCMetric.UnaryReqLatency).record(l, TimeUnit.NANOSECONDS);
                    future.complete(resp);
                    UnaryCaller.this.meter.recordCount(RPCMetric.UnaryReqCompleteCount);
                }

                public void onError(Throwable throwable) {
                    log.debug("Unary call of method {} error:", (Object)UnaryCaller.this.methodDesc.getFullMethodName(), (Object)throwable);
                    future.completeExceptionally(ExceptionUtil.toConcreteException(throwable));
                    UnaryCaller.this.meter.recordCount(RPCMetric.UnaryReqAbortCount);
                }

                public void onCompleted() {
                    UnaryCaller.this.counter.decrementAndGet();
                    UnaryCaller.this.meter.recordSummary(RPCMetric.UnaryReqDepth, UnaryCaller.this.counter.get());
                }
            });
            return future;
        });
    }
}

