/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.starter.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import java.io.File;
import java.io.IOException;
import org.yaml.snakeyaml.LoaderOptions;

public class ConfigFileUtil {
    public static <T> T build(File confFile, Class<T> clazz) {
        LoaderOptions loaderOptions = new LoaderOptions();
        loaderOptions.setAllowDuplicateKeys(false);
        YAMLFactory yamlFactory = YAMLFactory.builder().loaderOptions(loaderOptions).build();
        YAMLMapper mapper = new YAMLMapper(yamlFactory);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            return (T)mapper.readValue(confFile, clazz);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read config file: " + String.valueOf(confFile), e);
        }
    }

    public static String serialize(Object obj) {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory().disable(YAMLGenerator.Feature.USE_NATIVE_TYPE_ID));
        try {
            return mapper.writeValueAsString(obj);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to serialize config", e);
        }
    }
}

