/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.mqtt.utils;

import io.netty.handler.codec.mqtt.MqttConnectMessage;
import io.netty.handler.codec.mqtt.MqttConnectPayload;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.handler.codec.mqtt.MqttPublishVariableHeader;
import io.netty.handler.codec.mqtt.MqttSubAckMessage;
import io.netty.handler.codec.mqtt.MqttSubAckPayload;
import io.netty.handler.codec.mqtt.MqttSubscribeMessage;
import io.netty.handler.codec.mqtt.MqttSubscribePayload;
import io.netty.handler.codec.mqtt.MqttTopicSubscription;
import io.netty.handler.codec.mqtt.MqttUnsubscribeMessage;
import io.netty.handler.codec.mqtt.MqttUnsubscribePayload;
import lombok.Generated;
import org.apache.bifromq.mqtt.utils.IMQTTMessageSizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQTT3MessageSizer
implements IMQTTMessageSizer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MQTT3MessageSizer.class);
    public static final IMQTTMessageSizer INSTANCE = new MQTT3MessageSizer();

    @Override
    public IMQTTMessageSizer.MqttMessageSize sizeOf(MqttMessage message) {
        switch (message.fixedHeader().messageType()) {
            case CONNECT: {
                MqttConnectMessage connMsg = (MqttConnectMessage)message;
                return new MqttMessageSize(10, this.sizeConnPayload(connMsg));
            }
            case PUBLISH: {
                MqttPublishMessage pubMsg = (MqttPublishMessage)message;
                return new MqttMessageSize(this.sizePubVarHeader(pubMsg.variableHeader()), pubMsg.payload().readableBytes());
            }
            case SUBSCRIBE: {
                MqttSubscribeMessage subMsg = (MqttSubscribeMessage)message;
                return new MqttMessageSize(2, this.sizeSubPayload(subMsg.payload()));
            }
            case SUBACK: {
                MqttSubAckMessage subAckMsg = (MqttSubAckMessage)message;
                return new MqttMessageSize(2, this.sizeSubAckPayload(subAckMsg.payload()));
            }
            case UNSUBSCRIBE: {
                MqttUnsubscribeMessage unsubMsg = (MqttUnsubscribeMessage)message;
                return new MqttMessageSize(2, this.sizeUnsubPayload(unsubMsg.payload()));
            }
            case CONNACK: 
            case UNSUBACK: 
            case PUBACK: 
            case PUBREC: 
            case PUBREL: 
            case PUBCOMP: {
                return TWO_BYTES_REMAINING_LENGTH;
            }
            case DISCONNECT: 
            case PINGREQ: 
            case PINGRESP: {
                return ZERO_BYTES_REMAINING_LENGTH;
            }
        }
        log.error("Unknown message type for sizing: {}", (Object)message.fixedHeader().messageType());
        return ZERO_BYTES_REMAINING_LENGTH;
    }

    @Override
    public int lastWillSize(MqttConnectMessage message) {
        MqttConnectPayload payload = message.payload();
        int size = 0;
        if (message.variableHeader().isWillFlag()) {
            size += IMQTTMessageSizer.sizeUTF8EncodedString(payload.willTopic());
            size += IMQTTMessageSizer.sizeBinary(payload.willMessageInBytes());
        }
        return size;
    }

    private int sizeConnPayload(MqttConnectMessage message) {
        MqttConnectPayload payload = message.payload();
        int clientIdBytes = IMQTTMessageSizer.sizeUTF8EncodedString(payload.clientIdentifier());
        int usernameBytes = message.variableHeader().hasUserName() ? IMQTTMessageSizer.sizeUTF8EncodedString(payload.userName()) : 0;
        int passwordBytes = message.variableHeader().hasPassword() ? IMQTTMessageSizer.sizeBinary(payload.passwordInBytes()) : 0;
        int payloadSize = clientIdBytes + usernameBytes + passwordBytes;
        return payloadSize += this.lastWillSize(message);
    }

    private int sizePubVarHeader(MqttPublishVariableHeader header) {
        int topicNameBytes = IMQTTMessageSizer.sizeUTF8EncodedString(header.topicName());
        int packetIdBytes = header.packetId() == 0 ? 0 : 2;
        return topicNameBytes + packetIdBytes;
    }

    private int sizeSubPayload(MqttSubscribePayload payload) {
        int totalBytes = 0;
        for (MqttTopicSubscription sub : payload.topicSubscriptions()) {
            totalBytes += 1 + IMQTTMessageSizer.sizeUTF8EncodedString(sub.topicFilter());
        }
        return totalBytes;
    }

    private int sizeUnsubPayload(MqttUnsubscribePayload payload) {
        int totalBytes = 0;
        for (String topicFilter : payload.topics()) {
            totalBytes += IMQTTMessageSizer.sizeUTF8EncodedString(topicFilter);
        }
        return totalBytes;
    }

    private int sizeSubAckPayload(MqttSubAckPayload payload) {
        return payload.reasonCodes().size();
    }

    @Generated
    private MQTT3MessageSizer() {
    }

    private record MqttMessageSize(int varHeaderBytes, int payloadBytes) implements IMQTTMessageSizer.MqttMessageSize
    {
        @Override
        public int encodedBytes() {
            return this.encodedBytes(true, true);
        }

        @Override
        public int encodedBytes(boolean includeUserProps, boolean includeReasonString) {
            return 1 + IMQTTMessageSizer.varIntBytes(this.varHeaderBytes + this.payloadBytes) + this.varHeaderBytes + this.payloadBytes;
        }
    }
}

