/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.mqtt.session;

import io.netty.channel.ChannelHandlerContext;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import lombok.Generated;
import org.apache.bifromq.plugin.authprovider.IAuthProvider;
import org.apache.bifromq.plugin.authprovider.type.CheckResult;
import org.apache.bifromq.plugin.authprovider.type.MQTT3AuthData;
import org.apache.bifromq.plugin.authprovider.type.MQTT3AuthResult;
import org.apache.bifromq.plugin.authprovider.type.MQTT5AuthData;
import org.apache.bifromq.plugin.authprovider.type.MQTT5AuthResult;
import org.apache.bifromq.plugin.authprovider.type.MQTT5ExtendedAuthData;
import org.apache.bifromq.plugin.authprovider.type.MQTT5ExtendedAuthResult;
import org.apache.bifromq.plugin.authprovider.type.MQTTAction;
import org.apache.bifromq.type.ClientInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQTTSessionAuthProvider
implements IAuthProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MQTTSessionAuthProvider.class);
    private final IAuthProvider delegate;
    private final ChannelHandlerContext ctx;
    private final LinkedHashMap<CompletableFuture<CheckResult>, CompletableFuture<CheckResult>> checkPermissionTaskQueue = new LinkedHashMap();

    public MQTTSessionAuthProvider(IAuthProvider delegate, ChannelHandlerContext ctx) {
        this.delegate = delegate;
        this.ctx = ctx;
    }

    public CompletableFuture<MQTT3AuthResult> auth(MQTT3AuthData authData) {
        return this.delegate.auth(authData);
    }

    public CompletableFuture<MQTT5AuthResult> auth(MQTT5AuthData authData) {
        return this.delegate.auth(authData);
    }

    public CompletableFuture<MQTT5ExtendedAuthResult> extendedAuth(MQTT5ExtendedAuthData authData) {
        return this.delegate.extendedAuth(authData);
    }

    public CompletableFuture<Boolean> check(ClientInfo client, MQTTAction action) {
        return this.delegate.check(client, action);
    }

    public CompletableFuture<CheckResult> checkPermission(ClientInfo client, MQTTAction action) {
        assert (this.ctx.executor().inEventLoop());
        this.drainInOrder();
        CompletionStage task = this.delegate.checkPermission(client, action);
        if (((CompletableFuture)task).isDone() && this.checkPermissionTaskQueue.isEmpty()) {
            return task;
        }
        CompletableFuture<CheckResult> onDone = new CompletableFuture<CheckResult>();
        task = ((CompletableFuture)task).thenApply(v -> v);
        this.checkPermissionTaskQueue.put((CompletableFuture<CheckResult>)task, onDone);
        ((CompletableFuture)task).whenComplete((_v, _e) -> {
            if (this.ctx.executor().inEventLoop()) {
                this.drainInOrder();
            } else {
                this.ctx.executor().execute(this::drainInOrder);
            }
        });
        return onDone;
    }

    private void drainInOrder() {
        CompletableFuture<CheckResult> k;
        Iterator<CompletableFuture<CheckResult>> itr = this.checkPermissionTaskQueue.keySet().iterator();
        while (itr.hasNext() && (k = itr.next()).isDone()) {
            CompletableFuture<CheckResult> r = this.checkPermissionTaskQueue.get(k);
            try {
                r.complete(k.join());
            }
            catch (Throwable e) {
                r.completeExceptionally(e);
            }
            itr.remove();
        }
    }
}

