/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basecrdt.core.internal;

import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.bifromq.basecrdt.core.api.CausalCRDTType;
import org.apache.bifromq.basecrdt.core.api.IORMap;
import org.apache.bifromq.basecrdt.core.api.IORMapInflater;
import org.apache.bifromq.basecrdt.core.api.ORMapOperation;
import org.apache.bifromq.basecrdt.core.internal.CausalCRDT;
import org.apache.bifromq.basecrdt.core.internal.CausalCRDTInflater;
import org.apache.bifromq.basecrdt.core.internal.DotMap;
import org.apache.bifromq.basecrdt.core.internal.ICoalesceOperation;
import org.apache.bifromq.basecrdt.core.internal.IDotMap;
import org.apache.bifromq.basecrdt.core.internal.IReplicaStateLattice;
import org.apache.bifromq.basecrdt.core.internal.ORMap;
import org.apache.bifromq.basecrdt.core.internal.ORMapCoalesceOperation;
import org.apache.bifromq.basecrdt.proto.Replica;

class ORMapInflater
extends CausalCRDTInflater<IDotMap, ORMapOperation, IORMap>
implements IORMapInflater {
    ORMapInflater(String storeId, Replica replica, IReplicaStateLattice stateLattice, ScheduledExecutorService executor, Duration inflationInterval, String ... tags) {
        super(storeId, replica, stateLattice, executor, inflationInterval, tags);
    }

    @Override
    protected IORMap newCRDT(Replica replica, IDotMap dotStore, CausalCRDT.CRDTOperationExecutor<ORMapOperation> executor) {
        return new ORMap(replica, () -> dotStore, executor);
    }

    @Override
    public CausalCRDTType type() {
        return CausalCRDTType.ormap;
    }

    @Override
    protected ICoalesceOperation<IDotMap, ORMapOperation> startCoalescing(ORMapOperation op) {
        return new ORMapCoalesceOperation(this.id().getId(), op);
    }

    @Override
    protected Class<? extends IDotMap> dotStoreType() {
        return DotMap.class;
    }
}

