/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.util;

import com.google.common.base.Ticker;
import io.grpc.Internal;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.JsonUtil;
import io.grpc.util.GracefulSwitchLoadBalancer;
import io.grpc.util.OutlierDetectionLoadBalancer;
import java.util.Map;

@Internal
public final class OutlierDetectionLoadBalancerProvider
extends LoadBalancerProvider {
    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new OutlierDetectionLoadBalancer(helper, Ticker.systemTicker());
    }

    public boolean isAvailable() {
        return true;
    }

    public int getPriority() {
        return 5;
    }

    public String getPolicyName() {
        return "outlier_detection_experimental";
    }

    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawConfig) {
        try {
            return this.parseLoadBalancingPolicyConfigInternal(rawConfig);
        }
        catch (RuntimeException e) {
            return NameResolver.ConfigOrError.fromError((Status)Status.UNAVAILABLE.withCause((Throwable)e).withDescription("Failed parsing configuration for " + this.getPolicyName()));
        }
    }

    private NameResolver.ConfigOrError parseLoadBalancingPolicyConfigInternal(Map<String, ?> rawConfig) {
        NameResolver.ConfigOrError childConfig;
        Map rawFailurePercentageEjection;
        Map rawSuccessRateEjection;
        Long intervalNanos = JsonUtil.getStringAsDuration(rawConfig, (String)"interval");
        Long baseEjectionTimeNanos = JsonUtil.getStringAsDuration(rawConfig, (String)"baseEjectionTime");
        Long maxEjectionTimeNanos = JsonUtil.getStringAsDuration(rawConfig, (String)"maxEjectionTime");
        Integer maxEjectionPercentage = JsonUtil.getNumberAsInteger(rawConfig, (String)"maxEjectionPercentage");
        OutlierDetectionLoadBalancer.OutlierDetectionLoadBalancerConfig.Builder configBuilder = new OutlierDetectionLoadBalancer.OutlierDetectionLoadBalancerConfig.Builder();
        if (intervalNanos != null) {
            configBuilder.setIntervalNanos(intervalNanos);
        }
        if (baseEjectionTimeNanos != null) {
            configBuilder.setBaseEjectionTimeNanos(baseEjectionTimeNanos);
        }
        if (maxEjectionTimeNanos != null) {
            configBuilder.setMaxEjectionTimeNanos(maxEjectionTimeNanos);
        }
        if (maxEjectionPercentage != null) {
            configBuilder.setMaxEjectionPercent(maxEjectionPercentage);
        }
        if ((rawSuccessRateEjection = JsonUtil.getObject(rawConfig, (String)"successRateEjection")) != null) {
            OutlierDetectionLoadBalancer.OutlierDetectionLoadBalancerConfig.SuccessRateEjection.Builder successRateEjectionBuilder = new OutlierDetectionLoadBalancer.OutlierDetectionLoadBalancerConfig.SuccessRateEjection.Builder();
            Integer stdevFactor = JsonUtil.getNumberAsInteger((Map)rawSuccessRateEjection, (String)"stdevFactor");
            Integer enforcementPercentage = JsonUtil.getNumberAsInteger((Map)rawSuccessRateEjection, (String)"enforcementPercentage");
            Integer minimumHosts = JsonUtil.getNumberAsInteger((Map)rawSuccessRateEjection, (String)"minimumHosts");
            Integer requestVolume = JsonUtil.getNumberAsInteger((Map)rawSuccessRateEjection, (String)"requestVolume");
            if (stdevFactor != null) {
                successRateEjectionBuilder.setStdevFactor(stdevFactor);
            }
            if (enforcementPercentage != null) {
                successRateEjectionBuilder.setEnforcementPercentage(enforcementPercentage);
            }
            if (minimumHosts != null) {
                successRateEjectionBuilder.setMinimumHosts(minimumHosts);
            }
            if (requestVolume != null) {
                successRateEjectionBuilder.setRequestVolume(requestVolume);
            }
            configBuilder.setSuccessRateEjection(successRateEjectionBuilder.build());
        }
        if ((rawFailurePercentageEjection = JsonUtil.getObject(rawConfig, (String)"failurePercentageEjection")) != null) {
            OutlierDetectionLoadBalancer.OutlierDetectionLoadBalancerConfig.FailurePercentageEjection.Builder failurePercentageEjectionBuilder = new OutlierDetectionLoadBalancer.OutlierDetectionLoadBalancerConfig.FailurePercentageEjection.Builder();
            Integer threshold = JsonUtil.getNumberAsInteger((Map)rawFailurePercentageEjection, (String)"threshold");
            Integer enforcementPercentage = JsonUtil.getNumberAsInteger((Map)rawFailurePercentageEjection, (String)"enforcementPercentage");
            Integer minimumHosts = JsonUtil.getNumberAsInteger((Map)rawFailurePercentageEjection, (String)"minimumHosts");
            Integer requestVolume = JsonUtil.getNumberAsInteger((Map)rawFailurePercentageEjection, (String)"requestVolume");
            if (threshold != null) {
                failurePercentageEjectionBuilder.setThreshold(threshold);
            }
            if (enforcementPercentage != null) {
                failurePercentageEjectionBuilder.setEnforcementPercentage(enforcementPercentage);
            }
            if (minimumHosts != null) {
                failurePercentageEjectionBuilder.setMinimumHosts(minimumHosts);
            }
            if (requestVolume != null) {
                failurePercentageEjectionBuilder.setRequestVolume(requestVolume);
            }
            configBuilder.setFailurePercentageEjection(failurePercentageEjectionBuilder.build());
        }
        if ((childConfig = GracefulSwitchLoadBalancer.parseLoadBalancingPolicyConfig(JsonUtil.getListOfObjects(rawConfig, (String)"childPolicy"))).getError() != null) {
            return NameResolver.ConfigOrError.fromError((Status)GrpcUtil.statusWithDetails((Status.Code)Status.Code.UNAVAILABLE, (String)"Failed to parse child in outlier_detection_experimental", (Status)childConfig.getError()));
        }
        configBuilder.setChildConfig(childConfig.getConfig());
        return NameResolver.ConfigOrError.fromConfig((Object)configBuilder.build());
    }
}

