/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.dist.worker;

import java.util.concurrent.atomic.LongAdder;
import java.util.function.Supplier;
import org.apache.bifromq.metrics.ITenantMeter;
import org.apache.bifromq.metrics.TenantMetric;

class TenantStats {
    private final LongAdder normalRoutes = new LongAdder();
    private final LongAdder sharedRoutes = new LongAdder();
    private final String tenantId;
    private final String[] tags;
    private boolean isLeader;

    TenantStats(String tenantId, Supplier<Number> spaceUsageProvider, String ... tags) {
        this.tenantId = tenantId;
        this.tags = tags;
        ITenantMeter.gauging((String)tenantId, (TenantMetric)TenantMetric.MqttRouteSpaceGauge, spaceUsageProvider, (String[])tags);
    }

    void addNormalRoutes(int delta) {
        this.normalRoutes.add(delta);
        this.toggleMetering(this.isLeader);
    }

    void addSharedRoutes(int delta) {
        this.sharedRoutes.add(delta);
        this.toggleMetering(this.isLeader);
    }

    boolean isNoRoutes() {
        return this.normalRoutes.sum() == 0L && this.sharedRoutes.sum() == 0L;
    }

    void toggleMetering(boolean isLeader) {
        if (!this.isLeader && isLeader) {
            ITenantMeter.gauging((String)this.tenantId, (TenantMetric)TenantMetric.MqttRouteNumGauge, this.normalRoutes::sum, (String[])this.tags);
            ITenantMeter.gauging((String)this.tenantId, (TenantMetric)TenantMetric.MqttSharedSubNumGauge, this.sharedRoutes::sum, (String[])this.tags);
            this.isLeader = true;
        } else if (this.isLeader && !isLeader) {
            ITenantMeter.stopGauging((String)this.tenantId, (TenantMetric)TenantMetric.MqttRouteNumGauge, (String[])this.tags);
            ITenantMeter.stopGauging((String)this.tenantId, (TenantMetric)TenantMetric.MqttSharedSubNumGauge, (String[])this.tags);
            this.isLeader = false;
        }
    }

    void destroy() {
        ITenantMeter.stopGauging((String)this.tenantId, (TenantMetric)TenantMetric.MqttRouteSpaceGauge, (String[])this.tags);
        ITenantMeter.stopGauging((String)this.tenantId, (TenantMetric)TenantMetric.MqttRouteNumGauge, (String[])this.tags);
        ITenantMeter.stopGauging((String)this.tenantId, (TenantMetric)TenantMetric.MqttSharedSubNumGauge, (String[])this.tags);
    }
}

