/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.concurrent;

import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.Executor;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.cassandra.utils.concurrent.AbstractFuture;
import org.apache.cassandra.utils.concurrent.Awaitable;
import org.apache.cassandra.utils.concurrent.Future;
import org.apache.cassandra.utils.concurrent.ListenerList;

public class SyncFuture<V>
extends AbstractFuture<V> {
    protected SyncFuture() {
    }

    protected SyncFuture(V immediateSuccess) {
        super(immediateSuccess);
    }

    protected SyncFuture(Throwable immediateFailure) {
        super(immediateFailure);
    }

    protected SyncFuture(AbstractFuture.FailureHolder initialState) {
        super(initialState);
    }

    protected SyncFuture(GenericFutureListener<? extends io.netty.util.concurrent.Future<? super V>> listener) {
        super(listener);
    }

    protected SyncFuture(AbstractFuture.FailureHolder initialState, GenericFutureListener<? extends io.netty.util.concurrent.Future<? super V>> listener) {
        super(initialState, listener);
    }

    @Override
    public <T> Future<T> map(Function<? super V, ? extends T> mapper, Executor executor) {
        return this.map(new SyncFuture<V>(), mapper, executor);
    }

    @Override
    public <T> Future<T> flatMap(Function<? super V, ? extends Future<T>> flatMapper, @Nullable Executor executor) {
        return this.flatMap(new SyncFuture<V>(), flatMapper, executor);
    }

    @Override
    synchronized boolean trySet(Object v) {
        Object current = this.result;
        if (SyncFuture.isDone(current) || current == UNCANCELLABLE && (v == CANCELLED || v == UNCANCELLABLE)) {
            return false;
        }
        resultUpdater.lazySet(this, v);
        if (v != UNCANCELLABLE) {
            this.notifyListeners();
            this.notifyAll();
        }
        return true;
    }

    @Override
    public synchronized boolean awaitUntil(long deadline) throws InterruptedException {
        if (this.isDone()) {
            return true;
        }
        Awaitable.SyncAwaitable.waitUntil(this, deadline);
        return this.isDone();
    }

    @Override
    public synchronized Future<V> await() throws InterruptedException {
        while (!this.isDone()) {
            this.wait();
        }
        return this;
    }

    @Override
    synchronized void appendListener(ListenerList<V> newListener) {
        ListenerList.pushExclusive(listenersUpdater, this, newListener);
        if (this.isDone()) {
            this.notifyListeners();
        }
    }

    private void notifyListeners() {
        ListenerList.notifyExclusive(this.listeners, this);
        listenersUpdater.lazySet(this, null);
    }
}

