/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.lang.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

enum FaasEnvironment {
    AWS_LAMBDA("aws.lambda"),
    AZURE_FUNC("azure.func"),
    GCP_FUNC("gcp.func"),
    VERCEL("vercel"),
    UNKNOWN(null);

    static final Map<String, String> ENV_OVERRIDES_FOR_TESTING;
    @Nullable
    private final String name;

    static FaasEnvironment getFaasEnvironment() {
        ArrayList<FaasEnvironment> result = new ArrayList<FaasEnvironment>();
        String awsExecutionEnv = FaasEnvironment.getEnv("AWS_EXECUTION_ENV");
        if (FaasEnvironment.getEnv("VERCEL") != null) {
            result.add(VERCEL);
        }
        if (awsExecutionEnv != null && awsExecutionEnv.startsWith("AWS_Lambda_") || FaasEnvironment.getEnv("AWS_LAMBDA_RUNTIME_API") != null) {
            result.add(AWS_LAMBDA);
        }
        if (FaasEnvironment.getEnv("FUNCTIONS_WORKER_RUNTIME") != null) {
            result.add(AZURE_FUNC);
        }
        if (FaasEnvironment.getEnv("K_SERVICE") != null || FaasEnvironment.getEnv("FUNCTION_NAME") != null) {
            result.add(GCP_FUNC);
        }
        if (result.equals(Arrays.asList(VERCEL, AWS_LAMBDA))) {
            return VERCEL;
        }
        if (result.size() != 1) {
            return UNKNOWN;
        }
        return (FaasEnvironment)((Object)result.get(0));
    }

    @Nullable
    public static String getEnv(String key) {
        if (ENV_OVERRIDES_FOR_TESTING.containsKey(key)) {
            return ENV_OVERRIDES_FOR_TESTING.get(key);
        }
        return System.getenv(key);
    }

    private FaasEnvironment(String name) {
        this.name = name;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public Integer getTimeoutSec() {
        switch (this) {
            case GCP_FUNC: {
                return FaasEnvironment.getEnvInteger("FUNCTION_TIMEOUT_SEC");
            }
        }
        return null;
    }

    @Nullable
    public Integer getMemoryMb() {
        switch (this) {
            case AWS_LAMBDA: {
                return FaasEnvironment.getEnvInteger("AWS_LAMBDA_FUNCTION_MEMORY_SIZE");
            }
            case GCP_FUNC: {
                return FaasEnvironment.getEnvInteger("FUNCTION_MEMORY_MB");
            }
        }
        return null;
    }

    @Nullable
    public String getRegion() {
        switch (this) {
            case AWS_LAMBDA: {
                return FaasEnvironment.getEnv("AWS_REGION");
            }
            case GCP_FUNC: {
                return FaasEnvironment.getEnv("FUNCTION_REGION");
            }
            case VERCEL: {
                return FaasEnvironment.getEnv("VERCEL_REGION");
            }
        }
        return null;
    }

    @Nullable
    private static Integer getEnvInteger(String name) {
        try {
            String value = FaasEnvironment.getEnv(name);
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    static {
        ENV_OVERRIDES_FOR_TESTING = new HashMap<String, String>();
    }
}

