/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.execution.profiling;

import java.util.ArrayList;
import java.util.Map;
import org.apache.hop.core.Const;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.execution.profiling.ExecutionDataProfile;
import org.apache.hop.execution.sampler.ExecutionDataSamplerPluginType;
import org.apache.hop.execution.sampler.IExecutionDataSampler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.gui.GuiCompositeWidgets;
import org.apache.hop.ui.core.gui.GuiCompositeWidgetsAdapter;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.metadata.MetadataEditor;
import org.apache.hop.ui.core.metadata.MetadataManager;
import org.apache.hop.ui.hopgui.HopGui;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

@GuiPlugin(description="Editor for execution data profile metadata")
public class ExecutionDataProfileEditor
extends MetadataEditor<ExecutionDataProfile> {
    private static final Class<?> PKG = ExecutionDataProfileEditor.class;
    private ExecutionDataProfile executionDataProfile;
    private ExecutionDataProfile workingProfile;
    private Text wName;
    private Text wDescription;
    private List wSamplers;
    private Composite wPluginSpecificComp;
    private GuiCompositeWidgets guiCompositeWidgets;
    private Map<String, IExecutionDataSampler> metaMap;
    private IExecutionDataSampler previousSampler;

    public ExecutionDataProfileEditor(HopGui hopGui, MetadataManager<ExecutionDataProfile> manager, ExecutionDataProfile profile) {
        super(hopGui, manager, profile);
        this.executionDataProfile = profile;
        this.workingProfile = new ExecutionDataProfile(profile);
    }

    @Override
    public void createControl(Composite parent) {
        PropsUi props = PropsUi.getInstance();
        int middle = props.getMiddlePct();
        int margin = PropsUi.getMargin();
        Label wlName = new Label(parent, 131072);
        PropsUi.setLook((Widget)wlName);
        wlName.setText(BaseMessages.getString(PKG, (String)"ExecutionDataProfileEditor.label.name", (String[])new String[0]));
        FormData fdlName = new FormData();
        fdlName.top = new FormAttachment(0, margin * 2);
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, 0);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text(parent, 18436);
        PropsUi.setLook((Widget)this.wName);
        FormData fdName = new FormData();
        fdName.top = new FormAttachment((Control)wlName, 0, 0x1000000);
        fdName.left = new FormAttachment(middle, margin);
        fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)fdName);
        Text lastControl = this.wName;
        Label wlDescription = new Label(parent, 131072);
        PropsUi.setLook((Widget)wlDescription);
        wlDescription.setText(BaseMessages.getString(PKG, (String)"ExecutionDataProfileEditor.label.description", (String[])new String[0]));
        FormData fdlDescription = new FormData();
        fdlDescription.top = new FormAttachment((Control)lastControl, margin * 2);
        fdlDescription.left = new FormAttachment(0, 0);
        fdlDescription.right = new FormAttachment(middle, 0);
        wlDescription.setLayoutData((Object)fdlDescription);
        this.wDescription = new Text(parent, 18436);
        PropsUi.setLook((Widget)this.wDescription);
        FormData fdDescription = new FormData();
        fdDescription.top = new FormAttachment((Control)wlDescription, 0, 0x1000000);
        fdDescription.left = new FormAttachment(middle, margin);
        fdDescription.right = new FormAttachment(100, 0);
        this.wDescription.setLayoutData((Object)fdDescription);
        lastControl = this.wDescription;
        Label wlSamplers = new Label(parent, 16384);
        PropsUi.setLook((Widget)wlSamplers);
        wlSamplers.setText(BaseMessages.getString(PKG, (String)"ExecutionDataProfileEditor.label.Samplers", (String[])new String[0]));
        FormData fdlSamplers = new FormData();
        fdlSamplers.top = new FormAttachment((Control)lastControl, margin * 2);
        fdlSamplers.left = new FormAttachment(0, 0);
        fdlSamplers.right = new FormAttachment(middle, 0);
        wlSamplers.setLayoutData((Object)fdlSamplers);
        lastControl = wlSamplers;
        ToolBar wSamplersToolBar = new ToolBar(parent, 0);
        ToolItem addSamplersItem = new ToolItem(wSamplersToolBar, 8);
        addSamplersItem.setImage(GuiResource.getInstance().getImageAdd());
        addSamplersItem.setToolTipText(BaseMessages.getString(PKG, (String)"ExecutionDataProfileEditor.Button.AddSamplers", (String[])new String[0]));
        addSamplersItem.addListener(13, e -> this.addSamplers());
        addSamplersItem.addListener(13, e -> this.setChanged());
        ToolItem deleteSamplerItem = new ToolItem(wSamplersToolBar, 8);
        deleteSamplerItem.setImage(GuiResource.getInstance().getImageDelete());
        deleteSamplerItem.setToolTipText(BaseMessages.getString(PKG, (String)"ExecutionDataProfileEditor.Button.DeleteSampler", (String[])new String[0]));
        deleteSamplerItem.addListener(13, e -> this.deleteSampler());
        deleteSamplerItem.addListener(13, e -> this.setChanged());
        FormData fdSamplersToolBar = new FormData();
        fdSamplersToolBar.left = new FormAttachment(0, 0);
        fdSamplersToolBar.right = new FormAttachment(middle, 0);
        fdSamplersToolBar.top = new FormAttachment((Control)lastControl, margin);
        wSamplersToolBar.setLayoutData((Object)fdSamplersToolBar);
        lastControl = wSamplersToolBar;
        this.wSamplers = new List(parent, 18436);
        PropsUi.setLook((Widget)this.wSamplers);
        FormData fdSamplers = new FormData();
        fdSamplers.top = new FormAttachment((Control)lastControl, margin);
        fdSamplers.left = new FormAttachment(0, 0);
        fdSamplers.right = new FormAttachment(middle, 0);
        fdSamplers.bottom = new FormAttachment((Control)lastControl, (int)(150.0 * props.getZoomFactor()));
        this.wSamplers.setLayoutData((Object)fdSamplers);
        lastControl = this.wSamplers;
        this.wPluginSpecificComp = new Composite(parent, 8);
        PropsUi.setLook((Widget)this.wPluginSpecificComp);
        this.wPluginSpecificComp.setLayout((Layout)new FormLayout());
        FormData fdPluginSpecificComp = new FormData();
        fdPluginSpecificComp.left = new FormAttachment((Control)lastControl, margin);
        fdPluginSpecificComp.right = new FormAttachment(100, 0);
        fdPluginSpecificComp.top = new FormAttachment((Control)wlSamplers, margin);
        fdPluginSpecificComp.bottom = new FormAttachment(100, 0);
        this.wPluginSpecificComp.setLayoutData((Object)fdPluginSpecificComp);
        this.addSamplerPluginWidgets();
        this.setWidgetsContent();
        this.resetChanged();
        Listener modifyListener = e -> this.setChanged();
        this.wName.addListener(24, modifyListener);
        this.wDescription.addListener(24, modifyListener);
        this.wSamplers.addListener(13, e -> this.addSamplerPluginWidgets());
    }

    private void addSamplerPluginWidgets() {
        this.savePreviousSampler();
        this.removeSamplerWidgets();
        int selectionIndex = this.wSamplers.getSelectionIndex();
        if (selectionIndex < 0) {
            return;
        }
        IExecutionDataSampler sampler = (IExecutionDataSampler)this.workingProfile.getSamplers().get(selectionIndex);
        this.guiCompositeWidgets = new GuiCompositeWidgets(this.manager.getVariables());
        this.guiCompositeWidgets.createCompositeWidgets(sampler, null, this.wPluginSpecificComp, "ExecutionDataSamplerParent", (Control)this.wDescription);
        this.guiCompositeWidgets.setWidgetsContents(sampler, this.wPluginSpecificComp, "ExecutionDataSamplerParent");
        this.guiCompositeWidgets.setWidgetsListener(new GuiCompositeWidgetsAdapter(){

            @Override
            public void widgetModified(GuiCompositeWidgets compositeWidgets, Control changedWidget, String widgetId) {
                ExecutionDataProfileEditor.this.setChanged();
            }
        });
        this.previousSampler = sampler;
    }

    private void removeSamplerWidgets() {
        for (Control child : this.wPluginSpecificComp.getChildren()) {
            child.dispose();
        }
    }

    private void savePreviousSampler() {
        if (this.previousSampler != null) {
            this.guiCompositeWidgets.getWidgetsContents(this.previousSampler, "ExecutionDataSamplerParent");
        }
    }

    @Override
    public void setWidgetsContent() {
        this.wName.setText(Const.NVL((String)this.workingProfile.getName(), (String)""));
        this.wDescription.setText(Const.NVL((String)this.workingProfile.getDescription(), (String)""));
        for (IExecutionDataSampler sampler : this.workingProfile.getSamplers()) {
            this.wSamplers.add(sampler.getPluginName());
        }
        if (this.wSamplers.getItemCount() > 0) {
            this.wSamplers.setSelection(0);
        }
        this.addSamplerPluginWidgets();
    }

    @Override
    public void getWidgetsContent(ExecutionDataProfile profile) {
        profile.setName(this.wName.getText());
        profile.setDescription(this.wDescription.getText());
        this.savePreviousSampler();
        profile.getSamplers().clear();
        profile.getSamplers().addAll(this.workingProfile.getSamplers());
    }

    private void addSamplers() {
        try {
            ArrayList<IExecutionDataSampler> samplers = new ArrayList<IExecutionDataSampler>();
            for (IPlugin plugin : PluginRegistry.getInstance().getPlugins(ExecutionDataSamplerPluginType.class)) {
                IExecutionDataSampler sampler = (IExecutionDataSampler)PluginRegistry.getInstance().loadClass(plugin, IExecutionDataSampler.class);
                sampler.setPluginId(plugin.getIds()[0]);
                sampler.setPluginName(plugin.getName());
                samplers.add(sampler);
            }
            samplers.removeAll(this.workingProfile.getSamplers());
            if (samplers.isEmpty()) {
                return;
            }
            String[] samplerNames = new String[samplers.size()];
            for (int i = 0; i < samplerNames.length; ++i) {
                samplerNames[i] = ((IExecutionDataSampler)samplers.get(i)).getPluginName();
            }
            EnterSelectionDialog dialog = new EnterSelectionDialog(this.getShell(), samplerNames, BaseMessages.getString(PKG, (String)"ExecutionDataProfileEditor.AddSamplers.ShellText", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExecutionDataProfileEditor.AddSamplers.Message", (String[])new String[0]));
            dialog.setMulti(true);
            String selection = dialog.open();
            if (selection != null) {
                for (int index : dialog.getSelectionIndeces()) {
                    IExecutionDataSampler sampler = (IExecutionDataSampler)samplers.get(index);
                    this.workingProfile.getSamplers().add(sampler);
                    this.wSamplers.add(sampler.getPluginName());
                }
                this.wSamplers.setSelection(this.wSamplers.getItemCount() - 1);
                this.savePreviousSampler();
                this.addSamplerPluginWidgets();
            }
        }
        catch (Exception e) {
            new ErrorDialog(this.getShell(), "Error", "Error adding samplers", e);
        }
    }

    private void deleteSampler() {
        try {
            int index = this.wSamplers.getSelectionIndex();
            if (index < 0) {
                return;
            }
            IExecutionDataSampler sampler = (IExecutionDataSampler)this.workingProfile.getSamplers().get(index);
            this.workingProfile.getSamplers().remove(sampler);
            this.wSamplers.remove(sampler.getPluginName());
            this.previousSampler = null;
            this.removeSamplerWidgets();
        }
        catch (Exception e) {
            new ErrorDialog(this.getShell(), "Error", "Error deleting samplers", e);
        }
    }
}

