/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.hdfs;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.auto.service.AutoService;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoService(value={Module.class})
public class HadoopFileSystemModule
extends SimpleModule {
    public HadoopFileSystemModule() {
        super("HadoopFileSystemModule");
        this.setMixInAnnotation(Configuration.class, ConfigurationMixin.class);
    }

    private static class ConfigurationSerializer
    extends JsonSerializer<Configuration> {
        private ConfigurationSerializer() {
        }

        public void serialize(@UnknownKeyFor @NonNull @Initialized Configuration configuration, @UnknownKeyFor @NonNull @Initialized JsonGenerator jsonGenerator, @UnknownKeyFor @NonNull @Initialized SerializerProvider serializerProvider) throws @UnknownKeyFor @NonNull @Initialized IOException {
            TreeMap<String, String> map = new TreeMap<String, String>();
            for (Map.Entry entry : configuration) {
                map.put((String)entry.getKey(), (String)entry.getValue());
            }
            jsonGenerator.writeObject(map);
        }
    }

    private static class ConfigurationDeserializer
    extends JsonDeserializer<Configuration> {
        private ConfigurationDeserializer() {
        }

        public @UnknownKeyFor @NonNull @Initialized Configuration deserialize(@UnknownKeyFor @NonNull @Initialized JsonParser jsonParser, @UnknownKeyFor @NonNull @Initialized DeserializationContext deserializationContext) throws @UnknownKeyFor @NonNull @Initialized IOException {
            Map rawConfiguration = (Map)jsonParser.readValueAs((TypeReference)new TypeReference<Map<String, String>>(){});
            Configuration configuration = new Configuration(false);
            for (Map.Entry entry : rawConfiguration.entrySet()) {
                configuration.set((String)entry.getKey(), (String)entry.getValue());
            }
            return configuration;
        }
    }

    @JsonDeserialize(using=ConfigurationDeserializer.class)
    @JsonSerialize(using=ConfigurationSerializer.class)
    private static class ConfigurationMixin {
        private ConfigurationMixin() {
        }
    }
}

