/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.debug.transform;

import java.awt.image.BufferedImage;
import java.util.Map;
import org.apache.hop.core.extension.ExtensionPoint;
import org.apache.hop.core.extension.IExtensionPoint;
import org.apache.hop.core.gui.AreaOwner;
import org.apache.hop.core.gui.Rectangle;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.debug.transform.TransformDebugLevel;
import org.apache.hop.debug.util.BeePainter;
import org.apache.hop.debug.util.DebugLevelUtil;
import org.apache.hop.pipeline.PipelinePainterExtension;

@ExtensionPoint(id="DrawTransformDebugLevelBeeExtensionPoint", description="Draw a bee over a transform which has debug level information stored", extensionPointId="PipelinePainterTransform")
public class DrawTransformDebugLevelBeeExtensionPoint
extends BeePainter
implements IExtensionPoint<PipelinePainterExtension> {
    private static BufferedImage beeImage;

    public void callExtensionPoint(ILogChannel logChannelInterface, IVariables variables, PipelinePainterExtension ext) {
        try {
            String transformName;
            TransformDebugLevel debugLevel;
            Map transformLevelMap = (Map)ext.pipelineMeta.getAttributesMap().get("debug_plugin");
            if (transformLevelMap != null && (debugLevel = DebugLevelUtil.getTransformDebugLevel(transformLevelMap, transformName = ext.transformMeta.getName())) != null) {
                Rectangle r = this.drawBee(ext.gc, ext.x1, ext.y1, ext.iconSize, this.getClass().getClassLoader());
                ext.areaOwners.add(new AreaOwner(AreaOwner.AreaType.CUSTOM, r.x, r.y, r.width, r.height, ext.offset, (Object)ext.transformMeta, (Object)debugLevel));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

