/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.beam.runners.core.metrics.MetricsPusher;
import org.apache.beam.runners.flink.FlinkBatchPipelineTranslator;
import org.apache.beam.runners.flink.FlinkDetachedRunnerResult;
import org.apache.beam.runners.flink.FlinkExecutionEnvironments;
import org.apache.beam.runners.flink.FlinkPipelineOptions;
import org.apache.beam.runners.flink.FlinkPipelineTranslator;
import org.apache.beam.runners.flink.FlinkRunnerResult;
import org.apache.beam.runners.flink.FlinkStreamingPipelineTranslator;
import org.apache.beam.runners.flink.FlinkTransformOverrides;
import org.apache.beam.runners.flink.PipelineTranslationModeOptimizer;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.metrics.MetricsOptions;
import org.apache.beam.sdk.options.FileStagingOptions;
import org.apache.beam.sdk.util.construction.resources.PipelineResources;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.LocalEnvironment;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.streaming.api.environment.LocalStreamEnvironment;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FlinkPipelineExecutionEnvironment {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(FlinkPipelineExecutionEnvironment.class);
    private static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized ThreadGroup> protectedThreadGroups = ConcurrentHashMap.newKeySet();
    private final @UnknownKeyFor @NonNull @Initialized FlinkPipelineOptions options;
    private @UnknownKeyFor @NonNull @Initialized ExecutionEnvironment flinkBatchEnv;
    private @UnknownKeyFor @NonNull @Initialized StreamExecutionEnvironment flinkStreamEnv;

    FlinkPipelineExecutionEnvironment(@UnknownKeyFor @NonNull @Initialized FlinkPipelineOptions options) {
        this.options = (FlinkPipelineOptions)Preconditions.checkNotNull((Object)options);
    }

    public void translate(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
        FlinkPipelineTranslator translator;
        this.flinkBatchEnv = null;
        this.flinkStreamEnv = null;
        boolean hasUnboundedOutput = PipelineTranslationModeOptimizer.hasUnboundedOutput(pipeline);
        if (hasUnboundedOutput) {
            LOG.info("Found unbounded PCollection. Switching to streaming execution.");
            this.options.setStreaming(true);
        }
        FlinkPipelineExecutionEnvironment.prepareFilesToStageForRemoteClusterExecution(this.options);
        if (this.options.isStreaming() || this.options.getUseDataStreamForBatch().booleanValue()) {
            this.flinkStreamEnv = FlinkExecutionEnvironments.createStreamExecutionEnvironment(this.options);
            if (hasUnboundedOutput && !this.flinkStreamEnv.getCheckpointConfig().isCheckpointingEnabled()) {
                LOG.warn("UnboundedSources present which rely on checkpointing, but checkpointing is disabled.");
            }
            translator = new FlinkStreamingPipelineTranslator(this.flinkStreamEnv, this.options, this.options.isStreaming());
            if (!this.options.isStreaming()) {
                this.flinkStreamEnv.setRuntimeMode(RuntimeExecutionMode.BATCH);
            }
        } else {
            this.flinkBatchEnv = FlinkExecutionEnvironments.createBatchExecutionEnvironment(this.options);
            translator = new FlinkBatchPipelineTranslator(this.flinkBatchEnv, this.options);
        }
        pipeline.replaceAll(FlinkTransformOverrides.getDefaultOverrides(this.options));
        translator.translate(pipeline);
    }

    private static void prepareFilesToStageForRemoteClusterExecution(@UnknownKeyFor @NonNull @Initialized FlinkPipelineOptions options) {
        if (!options.getFlinkMaster().matches("\\[auto\\]|\\[collection\\]|\\[local\\]")) {
            PipelineResources.prepareFilesForStaging((FileStagingOptions)options);
        }
    }

    public @UnknownKeyFor @NonNull @Initialized PipelineResult executePipeline() throws @UnknownKeyFor @NonNull @Initialized Exception {
        String jobName = this.options.getJobName();
        if (this.flinkBatchEnv != null) {
            if (this.options.getAttachedMode()) {
                JobExecutionResult jobExecutionResult = this.flinkBatchEnv.execute(jobName);
                this.ensureFlinkCleanupComplete(this.flinkBatchEnv);
                return this.createAttachedPipelineResult(jobExecutionResult);
            }
            JobClient jobClient = this.flinkBatchEnv.executeAsync(jobName);
            return this.createDetachedPipelineResult(jobClient, this.options);
        }
        if (this.flinkStreamEnv != null) {
            if (this.options.getAttachedMode()) {
                JobExecutionResult jobExecutionResult = this.flinkStreamEnv.execute(jobName);
                this.ensureFlinkCleanupComplete(this.flinkStreamEnv);
                return this.createAttachedPipelineResult(jobExecutionResult);
            }
            JobClient jobClient = this.flinkStreamEnv.executeAsync(jobName);
            return this.createDetachedPipelineResult(jobClient, this.options);
        }
        throw new IllegalStateException("The Pipeline has not yet been translated.");
    }

    private void ensureFlinkCleanupComplete(@UnknownKeyFor @NonNull @Initialized Object executionEnv) {
        String javaVersion = System.getProperty("java.version");
        if (javaVersion == null || !javaVersion.startsWith("1.8")) {
            return;
        }
        if (!(executionEnv instanceof LocalStreamEnvironment) && !(executionEnv instanceof LocalEnvironment)) {
            return;
        }
        ThreadGroup currentThreadGroup = Thread.currentThread().getThreadGroup();
        if (currentThreadGroup == null) {
            return;
        }
        protectedThreadGroups.add(currentThreadGroup);
        Thread cleanupReleaser = new Thread(() -> {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                protectedThreadGroups.remove(currentThreadGroup);
            }
        }, "FlinkCleanupReleaser");
        cleanupReleaser.setDaemon(true);
        cleanupReleaser.start();
    }

    private @UnknownKeyFor @NonNull @Initialized FlinkDetachedRunnerResult createDetachedPipelineResult(@UnknownKeyFor @NonNull @Initialized JobClient jobClient, @UnknownKeyFor @NonNull @Initialized FlinkPipelineOptions options) {
        LOG.info("Pipeline submitted in detached mode");
        return new FlinkDetachedRunnerResult(jobClient, options.getJobCheckIntervalInSecs());
    }

    private @UnknownKeyFor @NonNull @Initialized FlinkRunnerResult createAttachedPipelineResult(@UnknownKeyFor @NonNull @Initialized JobExecutionResult result) {
        LOG.info("Execution finished in {} msecs", (Object)result.getNetRuntime());
        Map accumulators = result.getAllAccumulatorResults();
        if (accumulators != null && !accumulators.isEmpty()) {
            LOG.info("Final accumulator values:");
            for (Map.Entry entry : result.getAllAccumulatorResults().entrySet()) {
                LOG.info("{} : {}", entry.getKey(), entry.getValue());
            }
        }
        FlinkRunnerResult flinkRunnerResult = new FlinkRunnerResult(accumulators, result.getNetRuntime());
        MetricsPusher metricsPusher = new MetricsPusher(flinkRunnerResult.getMetricsContainerStepMap(), (MetricsOptions)this.options.as(MetricsOptions.class), (PipelineResult)flinkRunnerResult);
        metricsPusher.start();
        return flinkRunnerResult;
    }

    @VisibleForTesting
    @UnknownKeyFor @NonNull @Initialized JobGraph getJobGraph(@UnknownKeyFor @NonNull @Initialized Pipeline p) {
        this.translate(p);
        StreamGraph streamGraph = this.flinkStreamEnv.getStreamGraph();
        streamGraph.setJobName(p.getOptions().getJobName());
        return streamGraph.getJobGraph();
    }

    @VisibleForTesting
    @UnknownKeyFor @NonNull @Initialized ExecutionEnvironment getBatchExecutionEnvironment() {
        return this.flinkBatchEnv;
    }

    @VisibleForTesting
    @UnknownKeyFor @NonNull @Initialized StreamExecutionEnvironment getStreamExecutionEnvironment() {
        return this.flinkStreamEnv;
    }
}

