/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.ObjectDescription;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.Serializable;

public class JobQueue
implements Serializable {
    static final long serialVersionUID = 4L;
    private AS400 system_;
    private String name_;
    private String library_;
    private transient boolean loaded_;
    private static final ProgramParameter errorCode_ = new ProgramParameter(new byte[4]);
    private String jobQueueName_;
    private String jobQueueLibrary_;
    private int numberOfJobs_;
    private String jobQueueStatus_;
    private String subsystemName_;
    private String subsystemLibrary_;
    private String textDescription_;
    private int sequenceNumber_;
    private int maxActive_;
    private int currentActive_;
    private String authorityCheck_;
    private String operatorControlled_;
    private String format_ = "JOBQ0100";
    private transient ObjectDescription objectDescription_;

    public JobQueue(AS400 system, String library, String name) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (library == null) {
            throw new NullPointerException("library");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.system_ = system;
        this.name_ = name;
        this.library_ = library;
    }

    public JobQueue(AS400 system, QSYSObjectPathName path) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (path == null) {
            throw new NullPointerException("path");
        }
        this.system_ = system;
        this.name_ = path.getObjectName();
        this.library_ = path.getLibraryName();
    }

    public void refresh() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, ObjectDoesNotExistException, IOException {
        int bytesAvailable;
        if (this.system_ == null) {
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (this.name_ == null) {
            throw new ExtendedIllegalStateException("name", 4);
        }
        if (this.library_ == null) {
            throw new ExtendedIllegalStateException("library", 4);
        }
        int ccsid = this.system_.getCcsid();
        ConvTable conv = ConvTable.getTable(ccsid, null);
        AS400Text text20 = new AS400Text(20, ccsid);
        StringBuilder qualifiedJobQName = new StringBuilder(20);
        qualifiedJobQName.append(this.name_);
        for (int i = 0; i < 10 - this.name_.length(); ++i) {
            qualifiedJobQName.append(" ");
        }
        qualifiedJobQName.append(this.library_);
        ProgramParameter[] parms = new ProgramParameter[5];
        int len = 2048;
        parms[0] = new ProgramParameter(len);
        parms[1] = new ProgramParameter(BinaryConverter.intToByteArray(len));
        parms[2] = new ProgramParameter(conv.stringToByteArray(this.format_));
        parms[3] = new ProgramParameter(text20.toBytes(qualifiedJobQName.toString().trim().toUpperCase()));
        parms[4] = errorCode_;
        ProgramCall pc = new ProgramCall(this.system_, "/QSYS.LIB/QSPRJOBQ.PGM", parms);
        if (!pc.run()) {
            throw new AS400Exception(pc.getMessageList());
        }
        byte[] data = parms[0].getOutputData();
        int bytesReturned = BinaryConverter.byteArrayToInt(data, 0);
        if (bytesReturned < (bytesAvailable = BinaryConverter.byteArrayToInt(data, 4))) {
            if (Trace.traceOn_) {
                Trace.log(1, "JobQueue: Not enough bytes, trying again. Bytes returned = " + bytesReturned + "; bytes available = " + bytesAvailable);
            }
            len = bytesAvailable;
            try {
                parms[0].setOutputDataLength(len);
                parms[1].setInputData(BinaryConverter.intToByteArray(len));
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            if (!pc.run()) {
                throw new AS400Exception(pc.getMessageList());
            }
            data = parms[0].getOutputData();
        }
        this.jobQueueName_ = conv.byteArrayToString(data, 8, 10).trim();
        this.jobQueueLibrary_ = conv.byteArrayToString(data, 18, 10).trim();
        this.operatorControlled_ = conv.byteArrayToString(data, 28, 10).trim();
        this.authorityCheck_ = conv.byteArrayToString(data, 38, 10).trim();
        this.numberOfJobs_ = BinaryConverter.byteArrayToInt(data, 48);
        this.jobQueueStatus_ = conv.byteArrayToString(data, 52, 10).trim();
        this.subsystemName_ = conv.byteArrayToString(data, 62, 10).trim();
        this.textDescription_ = conv.byteArrayToString(data, 72, 50).trim();
        this.subsystemLibrary_ = conv.byteArrayToString(data, 122, 10).trim();
        this.sequenceNumber_ = BinaryConverter.byteArrayToInt(data, 132);
        this.maxActive_ = BinaryConverter.byteArrayToInt(data, 136);
        this.currentActive_ = BinaryConverter.byteArrayToInt(data, 140);
        this.loaded_ = true;
    }

    private void loadInformation() throws RuntimeException {
        try {
            this.refresh();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            Trace.log(2, "Exception rethrown by loadInformation():", (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    public String getJobQName() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.jobQueueName_;
    }

    public String getJobQLibrary() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.jobQueueLibrary_;
    }

    public String getSubsystemName() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.subsystemName_;
    }

    public String getSubsystemLibrary() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.subsystemLibrary_;
    }

    public String getOperatorControlled() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.operatorControlled_;
    }

    public String getAuthorityCheck() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.authorityCheck_;
    }

    public int getNumberOfJobs() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.numberOfJobs_;
    }

    public String getJobQueueStatus() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.jobQueueStatus_;
    }

    public String getTextDescription() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.textDescription_;
    }

    public int getSequenceNumber() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.sequenceNumber_;
    }

    public int getMaxActive() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.maxActive_;
    }

    public int getCurrentActive() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.currentActive_;
    }

    public void setSystem(AS400 system) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (this.loaded_) {
            throw new ExtendedIllegalStateException("system", 5);
        }
        this.system_ = system;
    }

    public void setName(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (this.loaded_) {
            throw new ExtendedIllegalStateException("name", 5);
        }
        this.name_ = name;
    }

    public void setLibraryName(String library) {
        if (library == null) {
            throw new NullPointerException("library");
        }
        if (this.loaded_) {
            throw new ExtendedIllegalStateException("library", 5);
        }
        this.library_ = library;
    }

    public void setFormat(String format) {
        if (format == null) {
            throw new NullPointerException("format");
        }
        if (this.loaded_) {
            throw new ExtendedIllegalStateException("library", 5);
        }
        if (format.equalsIgnoreCase("JOBQ0100") || format.equalsIgnoreCase("JOBQ0200")) {
            this.format_ = format;
        }
    }

    public boolean exists() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.objectDescription_ == null) {
            this.objectDescription_ = this.getObjDesc();
        }
        return this.objectDescription_.exists();
    }

    public ObjectDescription getObjectDescription() {
        if (this.objectDescription_ == null) {
            this.objectDescription_ = this.getObjDesc();
        }
        return this.objectDescription_;
    }

    private ObjectDescription getObjDesc() {
        return new ObjectDescription(this.system_, this.library_, this.name_, "JOBQ");
    }
}

