/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www.jaxrs;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.UUID;
import org.apache.hop.core.logging.HopLogStore;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.LoggingObjectType;
import org.apache.hop.core.logging.SimpleLoggingObject;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.serializer.multi.MultiMetadataProvider;
import org.apache.hop.workflow.WorkflowConfiguration;
import org.apache.hop.workflow.WorkflowExecutionConfiguration;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.engine.IWorkflowEngine;
import org.apache.hop.workflow.engine.WorkflowEngineFactory;
import org.apache.hop.www.HopServerObjectEntry;
import org.apache.hop.www.HopServerSingleton;
import org.apache.hop.www.jaxrs.HopServerResource;
import org.apache.hop.www.jaxrs.WorkflowStatus;

@Path(value="/carte/workflow")
public class WorkflowResource {
    @GET
    @Path(value="/log/{id : .+}")
    @Produces(value={"text/plain"})
    public String getWorkflowLog(@PathParam(value="id") String id) {
        return this.getWorkflowLog(id, 0);
    }

    @GET
    @Path(value="/log/{id : .+}/{logStart : .+}")
    @Produces(value={"text/plain"})
    public String getWorkflowLog(@PathParam(value="id") String id, @PathParam(value="logStart") int startLineNr) {
        int lastLineNr = HopLogStore.getLastBufferLineNr();
        IWorkflowEngine<WorkflowMeta> workflow = HopServerResource.getWorkflow(id);
        return HopLogStore.getAppender().getBuffer(workflow.getLogChannel().getLogChannelId(), false, startLineNr, lastLineNr).toString();
    }

    @GET
    @Path(value="/status/{id : .+}")
    @Produces(value={"application/json"})
    public WorkflowStatus getWorkflowStatus(@PathParam(value="id") String id) {
        WorkflowStatus status = new WorkflowStatus();
        IWorkflowEngine<WorkflowMeta> workflow = HopServerResource.getWorkflow(id);
        HopServerObjectEntry entry = HopServerResource.getHopServerObjectEntry(id);
        status.setId(entry.getId());
        status.setName(entry.getName());
        status.setStatus(workflow.getStatusDescription());
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/start/{id : .+}")
    @Produces(value={"application/json"})
    public WorkflowStatus startJob(@PathParam(value="id") String id) {
        IWorkflowEngine<WorkflowMeta> workflow = HopServerResource.getWorkflow(id);
        HopServerObjectEntry entry = HopServerResource.getHopServerObjectEntry(id);
        if (workflow.isInitialized() && !workflow.isActive()) {
            WorkflowResource workflowResource = this;
            synchronized (workflowResource) {
                WorkflowConfiguration workflowConfiguration = HopServerSingleton.getInstance().getWorkflowMap().getConfiguration(entry);
                MultiMetadataProvider metadataProvider = new MultiMetadataProvider(HopServerSingleton.getHopServerConfig().getVariables(), new IHopMetadataProvider[]{HopServerSingleton.getHopServer().getMetadataProvider(), workflowConfiguration.getMetadataProvider()});
                String serverObjectId = UUID.randomUUID().toString();
                SimpleLoggingObject servletLoggingObject = new SimpleLoggingObject(this.getClass().getName(), LoggingObjectType.HOP_SERVER, null);
                servletLoggingObject.setContainerObjectId(serverObjectId);
                String runConfigurationName = workflowConfiguration.getWorkflowExecutionConfiguration().getRunConfiguration();
                try {
                    IVariables variables = Variables.getADefaultVariableSpace();
                    IWorkflowEngine<WorkflowMeta> newWorkflow = WorkflowEngineFactory.createWorkflowEngine(variables, variables.resolve(runConfigurationName), (IHopMetadataProvider)metadataProvider, workflow.getWorkflowMeta(), (ILoggingObject)servletLoggingObject);
                    newWorkflow.setLogLevel(workflow.getLogLevel());
                    HopLogStore.discardLines((String)workflow.getLogChannelId(), (boolean)true);
                    HopServerSingleton.getInstance().getWorkflowMap().replaceWorkflow(workflow, newWorkflow, workflowConfiguration);
                    workflow = newWorkflow;
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to instantiate new workflow", e);
                }
            }
        }
        IWorkflowEngine<WorkflowMeta> finalWorkflow = workflow;
        new Thread(finalWorkflow::startExecution).start();
        return this.getWorkflowStatus(id);
    }

    @GET
    @Path(value="/stop/{id : .+}")
    @Produces(value={"application/json"})
    public WorkflowStatus stopJob(@PathParam(value="id") String id) {
        IWorkflowEngine<WorkflowMeta> workflow = HopServerResource.getWorkflow(id);
        workflow.stopExecution();
        return this.getWorkflowStatus(id);
    }

    @GET
    @Path(value="/remove/{id : .+}")
    public Response removeJob(@PathParam(value="id") String id) {
        IWorkflowEngine<WorkflowMeta> workflow = HopServerResource.getWorkflow(id);
        HopServerObjectEntry entry = HopServerResource.getHopServerObjectEntry(id);
        HopLogStore.discardLines((String)workflow.getLogChannelId(), (boolean)true);
        HopServerSingleton.getInstance().getWorkflowMap().removeWorkflow(entry);
        return Response.ok().build();
    }

    @PUT
    @Path(value="/add")
    @Produces(value={"application/json"})
    public WorkflowStatus addJob(String xml) {
        try {
            String[] parameterNames;
            IVariables variables = Variables.getADefaultVariableSpace();
            WorkflowConfiguration workflowConfiguration = WorkflowConfiguration.fromXml(xml, variables);
            MultiMetadataProvider metadataProvider = new MultiMetadataProvider(variables, new IHopMetadataProvider[]{HopServerSingleton.getHopServer().getMetadataProvider(), workflowConfiguration.getMetadataProvider()});
            WorkflowMeta workflowMeta = workflowConfiguration.getWorkflowMeta();
            WorkflowExecutionConfiguration workflowExecutionConfiguration = workflowConfiguration.getWorkflowExecutionConfiguration();
            String serverObjectId = UUID.randomUUID().toString();
            SimpleLoggingObject servletLoggingObject = new SimpleLoggingObject(this.getClass().getName(), LoggingObjectType.HOP_SERVER, null);
            servletLoggingObject.setContainerObjectId(serverObjectId);
            servletLoggingObject.setLogLevel(workflowExecutionConfiguration.getLogLevel());
            String runConfigurationName = workflowConfiguration.getWorkflowExecutionConfiguration().getRunConfiguration();
            IWorkflowEngine<WorkflowMeta> workflow = WorkflowEngineFactory.createWorkflowEngine(variables, variables.resolve(runConfigurationName), (IHopMetadataProvider)metadataProvider, workflowMeta, (ILoggingObject)servletLoggingObject);
            workflow.initializeFrom(null);
            workflow.getWorkflowMeta().setInternalHopVariables(workflow);
            workflow.setVariables(workflowConfiguration.getWorkflowExecutionConfiguration().getVariablesMap());
            workflow.copyParametersFromDefinitions(workflowMeta);
            workflow.clearParameterValues();
            for (String parameterName : parameterNames = workflow.listParameters()) {
                String thisValue = workflowExecutionConfiguration.getParametersMap().get(parameterName);
                if (Utils.isEmpty((CharSequence)thisValue)) continue;
                workflow.setParameterValue(parameterName, thisValue);
            }
            workflow.activateParameters(workflow);
            HopServerSingleton.getInstance().getWorkflowMap().addWorkflow(workflow.getWorkflowName(), serverObjectId, workflow, workflowConfiguration);
            return this.getWorkflowStatus(serverObjectId);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

