/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.DefaultVTIModDeferPolicy;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.FromVTI;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.vti.DeferModification;

class VTIDeferModPolicy
implements Visitor {
    private boolean deferred = false;
    private DeferModification deferralControl;
    private int statementType;
    private int tableNumber;
    private final HashSet<String> columns = new HashSet();

    public static boolean deferIt(int n, FromVTI fromVTI, String[] stringArray, QueryTreeNode queryTreeNode) throws StandardException {
        try {
            Object object;
            int n2 = fromVTI.getResultSetType();
            if ((n == 2 || n == 3) && n2 == 1003) {
                return false;
            }
            DeferModification deferModification = fromVTI.getDeferralControl();
            if (deferModification == null) {
                object = fromVTI.getMethodCall().getJavaClassName();
                deferModification = new DefaultVTIModDeferPolicy((String)object, 1005 == n2);
            }
            if (deferModification.alwaysDefer(n)) {
                return true;
            }
            if (queryTreeNode == null && n != 2) {
                return false;
            }
            object = new VTIDeferModPolicy(fromVTI, stringArray, deferModification, n);
            if (queryTreeNode != null) {
                queryTreeNode.accept((Visitor)object);
            }
            if (n == 2) {
                for (String string : ((VTIDeferModPolicy)object).columns) {
                    if (!deferModification.columnRequiresDefer(n, string, false)) continue;
                    return true;
                }
            }
            return ((VTIDeferModPolicy)object).deferred;
        }
        catch (SQLException sQLException) {
            throw StandardException.unexpectedUserException((Throwable)sQLException);
        }
    }

    private VTIDeferModPolicy(FromVTI fromVTI, String[] stringArray, DeferModification deferModification, int n) {
        this.deferralControl = deferModification;
        this.statementType = n;
        this.tableNumber = fromVTI.getTableNumber();
        if (n == 2 && stringArray != null) {
            this.columns.addAll(Arrays.asList(stringArray));
        }
    }

    @Override
    public Visitable visit(Visitable visitable) throws StandardException {
        try {
            if (visitable instanceof ColumnReference && this.statementType != 1) {
                ColumnReference columnReference = (ColumnReference)visitable;
                if (columnReference.getTableNumber() == this.tableNumber) {
                    String string = columnReference.getColumnName();
                    if (this.statementType == 3) {
                        if (this.columns.add(string) && this.deferralControl.columnRequiresDefer(this.statementType, string, true)) {
                            this.deferred = true;
                        }
                    } else if (this.statementType == 2 && this.columns.remove(string) && this.deferralControl.columnRequiresDefer(this.statementType, string, true)) {
                        this.deferred = true;
                    }
                }
            } else if (visitable instanceof SelectNode) {
                SelectNode selectNode = (SelectNode)visitable;
                FromList fromList = selectNode.getFromList();
                for (int i = 0; i < fromList.size(); ++i) {
                    Object object;
                    FromTable fromTable = (FromTable)fromList.elementAt(i);
                    if (fromTable instanceof FromBaseTable) {
                        object = fromTable.getTableDescriptor();
                        if (!this.deferralControl.subselectRequiresDefer(this.statementType, ((TableDescriptor)object).getSchemaName(), ((TableDescriptor)object).getName())) continue;
                        this.deferred = true;
                        continue;
                    }
                    if (!(fromTable instanceof FromVTI) || !this.deferralControl.subselectRequiresDefer(this.statementType, ((FromVTI)(object = (FromVTI)fromTable)).getMethodCall().getJavaClassName())) continue;
                    this.deferred = true;
                }
            }
        }
        catch (SQLException sQLException) {
            throw StandardException.unexpectedUserException((Throwable)sQLException);
        }
        return visitable;
    }

    @Override
    public boolean stopTraversal() {
        return this.deferred;
    }

    @Override
    public boolean skipChildren(Visitable visitable) {
        return false;
    }

    @Override
    public boolean visitChildrenFirst(Visitable visitable) {
        return false;
    }
}

