/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.MemoryInfo;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.OperatorUtils;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.lib.SemanticNodeProcessor;
import org.apache.hadoop.hive.ql.lib.SemanticRule;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.type.ExprNodeTypeCheck;
import org.apache.hadoop.hive.ql.plan.ColStatistics;
import org.apache.hadoop.hive.ql.plan.DynamicPartitionCtx;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.ListBucketingCtx;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.Statistics;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.util.NullOrdering;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.orc.OrcConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SortedDynPartitionOptimizer
extends Transform {
    private static final Function<List<ExprNodeDesc>, ExprNodeDesc> BUCKET_SORT_EXPRESSION = cols -> {
        try {
            return ExprNodeGenericFuncDesc.newInstance(FunctionRegistry.getFunctionInfo("bucket_number").getGenericUDF(), new ArrayList<ExprNodeDesc>());
        }
        catch (SemanticException e) {
            throw new RuntimeException(e);
        }
    };

    @Override
    public ParseContext transform(ParseContext pCtx) throws SemanticException {
        LinkedHashMap<SemanticRule, SemanticNodeProcessor> opRules = new LinkedHashMap<SemanticRule, SemanticNodeProcessor>();
        String FS = FileSinkOperator.getOperatorName() + "%";
        opRules.put(new RuleRegExp("Sorted Dynamic Partition", FS), this.getSortDynPartProc(pCtx));
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(null, opRules, null);
        DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(pCtx.getTopOps().values());
        ogw.startWalking(topNodes, null);
        return pCtx;
    }

    private SemanticNodeProcessor getSortDynPartProc(ParseContext pCtx) {
        return new SortedDynamicPartitionProc(this, pCtx);
    }

    class SortedDynamicPartitionProc
    implements SemanticNodeProcessor {
        private final Logger LOG = LoggerFactory.getLogger(SortedDynPartitionOptimizer.class);
        protected ParseContext parseCtx;

        public SortedDynamicPartitionProc(SortedDynPartitionOptimizer this$0, ParseContext pCtx) {
            this.parseCtx = pCtx;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            int i;
            FileSinkOperator fsOp = (FileSinkOperator)nd;
            this.LOG.info("Sorted dynamic partitioning optimization kicked in..");
            if (((FileSinkDesc)fsOp.getConf()).getDynPartCtx() == null) {
                this.LOG.debug("Bailing out of sort dynamic partition optimization as dynamic partitioning context is null");
                return null;
            }
            ListBucketingCtx lbCtx = ((FileSinkDesc)fsOp.getConf()).getLbCtx();
            if (lbCtx != null && !lbCtx.getSkewedColNames().isEmpty() && !lbCtx.getSkewedColValues().isEmpty()) {
                this.LOG.debug("Bailing out of sort dynamic partition optimization as list bucketing is enabled");
                return null;
            }
            Table destTable = ((FileSinkDesc)fsOp.getConf()).getTable();
            if (destTable == null) {
                this.LOG.debug("Bailing out of sort dynamic partition optimization as destination table is null");
                return null;
            }
            if (destTable.isMaterializedView() && (destTable.getProperty("materializedview.sort.columns") != null || destTable.getProperty("materializedview.distribute.columns") != null)) {
                this.LOG.debug("Bailing out of sort dynamic partition optimization as destination is a materialized viewwith CLUSTER/SORT/DISTRIBUTE spec");
                return null;
            }
            Operator<OperatorDesc> fsParent = fsOp.getParentOperators().get(0);
            DynamicPartitionCtx dpCtx = ((FileSinkDesc)fsOp.getConf()).getDynPartCtx();
            ArrayList parentCols = Lists.newArrayList(fsParent.getSchema().getSignature());
            ArrayList allRSCols = Lists.newArrayList();
            for (ColumnInfo ci : parentCols) {
                allRSCols.add(new ExprNodeColumnDesc(ci));
            }
            if (this.allStaticPartitions(fsParent, allRSCols, dpCtx)) {
                this.LOG.debug("Bailing out of sorted dynamic partition optimizer as all dynamic partition columns got constant folded (static partitioning)");
                return null;
            }
            List<Integer> partitionPositions = this.getPartitionPositions(dpCtx, fsParent.getSchema());
            LinkedList<Function<List<ExprNodeDesc>, ExprNodeDesc>> customSortExprs = new LinkedList<Function<List<ExprNodeDesc>, ExprNodeDesc>>(dpCtx.getCustomSortExpressions());
            LinkedList<Integer> customSortOrder = new LinkedList<Integer>(dpCtx.getCustomSortOrder());
            LinkedList<Integer> customNullOrder = new LinkedList<Integer>(dpCtx.getCustomSortNullOrder());
            if (customSortExprs.isEmpty() && !this.shouldDo(partitionPositions, fsParent)) {
                return null;
            }
            if (!this.removeRSInsertedByEnforceBucketing(fsOp)) {
                this.LOG.debug("Bailing out of sort dynamic partition optimization as some partition columns got constant folded.");
                return null;
            }
            fsParent = fsOp.getParentOperators().get(0);
            int fsOpIndex = fsParent.getChildOperators().indexOf(fsOp);
            fsParent.getChildOperators().remove(fsOp);
            int numBuckets = destTable.getNumBuckets();
            dpCtx.setNumBuckets(numBuckets);
            List<Integer> bucketPositions = this.getBucketPositions(destTable.getBucketCols(), destTable.getCols());
            ArrayList<Integer> sortPositions = null;
            List<Object> sortOrder = null;
            ArrayList<ExprNodeDesc> bucketColumns = null;
            if (((FileSinkDesc)fsOp.getConf()).getWriteType() == AcidUtils.Operation.UPDATE || ((FileSinkDesc)fsOp.getConf()).getWriteType() == AcidUtils.Operation.DELETE) {
                sortPositions = Collections.singletonList(0);
                sortOrder = Collections.singletonList(1);
                ColumnInfo ci = fsParent.getSchema().getSignature().get(0);
                if (!VirtualColumn.ROWID.getTypeInfo().equals((Object)ci.getType())) {
                    throw new IllegalStateException("expected 1st column to be ROW__ID but got wrong type: " + ci.toString());
                }
                if (numBuckets > 0) {
                    bucketColumns = new ArrayList<ExprNodeDesc>();
                    bucketColumns.add((ExprNodeDesc)ExprNodeTypeCheck.getExprNodeDefaultExprProcessor().createConversionCast(new ExprNodeColumnDesc(ci), TypeInfoFactory.intTypeInfo));
                }
            } else {
                if (!destTable.getSortCols().isEmpty()) {
                    sortPositions = this.getSortPositions(destTable.getSortCols(), destTable.getCols());
                    sortOrder = this.getSortOrders(destTable.getSortCols(), destTable.getCols());
                } else if (HiveConf.getBoolVar((Configuration)this.parseCtx.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SORT_WHEN_BUCKETING) && !bucketPositions.isEmpty()) {
                    sortPositions = new ArrayList<Integer>(bucketPositions);
                    sortOrder = sortPositions.stream().map(e -> 1).collect(Collectors.toList());
                } else {
                    sortPositions = Lists.newArrayList();
                    sortOrder = Lists.newArrayList();
                    this.inferSortPositions(fsParent, sortPositions, (List<Integer>)sortOrder);
                }
                List<ColumnInfo> colInfos = fsParent.getSchema().getSignature();
                bucketColumns = this.getPositionsToExprNodes(bucketPositions, colInfos);
            }
            ArrayList<Integer> sortNullOrder = new ArrayList<Integer>();
            Iterator<Object> iterator = sortOrder.iterator();
            while (iterator.hasNext()) {
                int order = (Integer)iterator.next();
                sortNullOrder.add(NullOrdering.defaultNullOrder(order, (Configuration)this.parseCtx.getConf()).getCode());
            }
            this.LOG.debug("Got sort order");
            iterator = sortPositions.iterator();
            while (iterator.hasNext()) {
                i = (Integer)iterator.next();
                this.LOG.debug("sort position " + i);
            }
            iterator = sortOrder.iterator();
            while (iterator.hasNext()) {
                i = (Integer)iterator.next();
                this.LOG.debug("sort order " + i);
            }
            iterator = sortNullOrder.iterator();
            while (iterator.hasNext()) {
                i = (Integer)iterator.next();
                this.LOG.debug("sort null order " + i);
            }
            ((FileSinkDesc)fsOp.getConf()).setMultiFileSpray(false);
            ((FileSinkDesc)fsOp.getConf()).setNumFiles(1);
            ((FileSinkDesc)fsOp.getConf()).setTotalFiles(1);
            ReduceSinkOperator rsOp = this.getReduceSinkOp(partitionPositions, sortPositions, sortOrder, sortNullOrder, customSortExprs, customSortOrder, customNullOrder, allRSCols, bucketColumns, numBuckets, fsParent, ((FileSinkDesc)fsOp.getConf()).getWriteType());
            fsParent.getChildOperators().remove(rsOp);
            fsParent.getChildOperators().add(fsOpIndex, rsOp);
            ((ReduceSinkDesc)rsOp.getConf()).setBucketingVersion(((FileSinkDesc)fsOp.getConf()).getBucketingVersion());
            ArrayList<ExprNodeDesc> descs = new ArrayList<ExprNodeDesc>(allRSCols.size());
            ArrayList<String> colNames = new ArrayList<String>();
            List<ColumnInfo> fileSinkSchema = fsOp.getSchema().getSignature();
            for (int i2 = 0; i2 < allRSCols.size(); ++i2) {
                void var30_32;
                ExprNodeDesc col = (ExprNodeDesc)allRSCols.get(i2);
                Object var30_33 = null;
                String colName = col.getExprString();
                colNames.add(colName);
                if (partitionPositions.contains(i2) || sortPositions.contains(i2)) {
                    ExprNodeColumnDesc exprNodeColumnDesc = new ExprNodeColumnDesc(col.getTypeInfo(), Utilities.ReduceField.KEY.toString() + "." + colName, null, false);
                } else {
                    ExprNodeColumnDesc exprNodeColumnDesc = new ExprNodeColumnDesc(col.getTypeInfo(), Utilities.ReduceField.VALUE.toString() + "." + colName, null, false);
                }
                if (i2 < fileSinkSchema.size()) {
                    void var30_36;
                    ColumnInfo fsColInfo = fileSinkSchema.get(i2);
                    if (!var30_36.getTypeInfo().equals((Object)fsColInfo.getType())) {
                        ExprNodeDesc exprNodeDesc = (ExprNodeDesc)ExprNodeTypeCheck.getExprNodeDefaultExprProcessor().createConversionCast(var30_36, (PrimitiveTypeInfo)fsColInfo.getType());
                    }
                }
                descs.add((ExprNodeDesc)var30_32);
            }
            RowSchema selRS = new RowSchema(fsParent.getSchema());
            if (bucketColumns != null && !bucketColumns.isEmpty()) {
                customSortExprs.add(BUCKET_SORT_EXPRESSION);
            }
            for (Function function : customSortExprs) {
                ExprNodeDesc colExpr = (ExprNodeDesc)function.apply(allRSCols);
                String customSortColName = colExpr.getExprString();
                TypeInfo customSortColTypeInfo = colExpr.getTypeInfo();
                descs.add(new ExprNodeColumnDesc(customSortColTypeInfo, String.valueOf((Object)Utilities.ReduceField.KEY) + "." + customSortColName, null, false));
                colNames.add(customSortColName);
                ColumnInfo ci = new ColumnInfo(customSortColName, customSortColTypeInfo, selRS.getSignature().get(0).getTabAlias(), true, true);
                selRS.getSignature().add(ci);
                rsOp.getSchema().getSignature().add(ci);
            }
            SelectDesc selConf = new SelectDesc(descs, colNames);
            SelectOperator selectOperator = (SelectOperator)OperatorFactory.getAndMakeChild(selConf, selRS, (Operator)rsOp, new Operator[0]);
            fsOp.getParentOperators().clear();
            fsOp.getParentOperators().add(selectOperator);
            selectOperator.getChildOperators().add(fsOp);
            ((FileSinkDesc)fsOp.getConf()).setDpSortState(FileSinkDesc.DPSortState.PARTITION_SORTED);
            if (bucketColumns != null && !bucketColumns.isEmpty()) {
                ((FileSinkDesc)fsOp.getConf()).setDpSortState(FileSinkDesc.DPSortState.PARTITION_BUCKET_SORTED);
            }
            ((FileSinkDesc)fsOp.getConf()).setPartitionCols(((ReduceSinkDesc)rsOp.getConf()).getPartitionCols());
            rsOp.setStatistics(rsOp.getParentOperators().get(0).getStatistics());
            this.LOG.info("Inserted " + rsOp.getOperatorId() + " and " + selectOperator.getOperatorId() + " as parent of " + fsOp.getOperatorId() + " and child of " + fsParent.getOperatorId());
            this.parseCtx.setReduceSinkAddedBySortedDynPartition(true);
            return null;
        }

        private boolean allStaticPartitions(Operator<? extends OperatorDesc> op, List<ExprNodeDesc> allRSCols, DynamicPartitionCtx dynPartCtx) {
            if (op.getColumnExprMap() == null) {
                for (Operator<OperatorDesc> parent : op.getParentOperators()) {
                    if (parent.getColumnExprMap() == null) continue;
                    op = parent;
                    break;
                }
            }
            if (op.getColumnExprMap() == null) {
                return false;
            }
            LinkedList<String> referencedSortColumnNames = new LinkedList<String>();
            List<Function<List<ExprNodeDesc>, ExprNodeDesc>> customSortExprs = dynPartCtx.getCustomSortExpressions();
            if (customSortExprs != null && !customSortExprs.isEmpty()) {
                HashSet<ExprNodeColumnDesc> columnDescs = new HashSet<ExprNodeColumnDesc>();
                for (Function<List<ExprNodeDesc>, ExprNodeDesc> customSortExpr : customSortExprs) {
                    ExprNodeDesc sortExpressionForRSSchema = customSortExpr.apply(allRSCols);
                    columnDescs.addAll(ExprNodeDescUtils.findAllColumnDescs(sortExpressionForRSSchema));
                }
                for (ExprNodeColumnDesc columnDesc : columnDescs) {
                    referencedSortColumnNames.add(columnDesc.getColumn());
                }
            } else {
                int numDpCols = dynPartCtx.getNumDPCols();
                int numCols = op.getSchema().getColumnNames().size();
                referencedSortColumnNames.addAll(op.getSchema().getColumnNames().subList(numCols - numDpCols, numCols));
            }
            for (String dpCol : referencedSortColumnNames) {
                ExprNodeDesc end = ExprNodeDescUtils.findConstantExprOrigin(dpCol, op);
                if (end instanceof ExprNodeConstantDesc) continue;
                return false;
            }
            return true;
        }

        private boolean removeRSInsertedByEnforceBucketing(FileSinkOperator fsOp) {
            Set<ReduceSinkOperator> reduceSinks = OperatorUtils.findOperatorsUpstream(fsOp, ReduceSinkOperator.class);
            Operator rsToRemove = null;
            List<ReduceSinkOperator> rsOps = this.parseCtx.getReduceSinkOperatorsAddedByEnforceBucketingSorting();
            boolean found = false;
            for (ReduceSinkOperator reduceSink : reduceSinks) {
                for (ReduceSinkOperator rsOp : rsOps) {
                    if (!reduceSink.equals(rsOp)) continue;
                    rsToRemove = reduceSink;
                    found = true;
                    break;
                }
                if (!found) continue;
                break;
            }
            if (found) {
                Operator<OperatorDesc> rsParent = rsToRemove.getParentOperators().get(0);
                assert (rsToRemove.getChildOperators().size() == 1);
                Operator<OperatorDesc> rsChildToRemove = rsToRemove.getChildOperators().get(0);
                if (!(rsChildToRemove instanceof SelectOperator) || rsParent.getSchema().getSignature().size() != rsChildToRemove.getSchema().getSignature().size()) {
                    return false;
                }
                for (ExprNodeDesc expr : rsChildToRemove.getColumnExprMap().values()) {
                    if (expr instanceof ExprNodeColumnDesc) continue;
                    return false;
                }
                List<Operator<OperatorDesc>> rsGrandChildren = rsChildToRemove.getChildOperators();
                rsParent.getChildOperators().remove(rsToRemove);
                rsParent.getChildOperators().addAll(rsGrandChildren);
                for (Operator<OperatorDesc> rsGrandChild : rsGrandChildren) {
                    rsGrandChild.getParentOperators().clear();
                    rsGrandChild.getParentOperators().add(rsParent);
                }
                this.LOG.info("Removed " + rsToRemove.getOperatorId() + " and " + rsChildToRemove.getOperatorId() + " as it was introduced by enforce bucketing/sorting.");
            }
            return true;
        }

        private List<Integer> getPartitionPositions(DynamicPartitionCtx dpCtx, RowSchema schema) {
            int numPartCols = dpCtx.getNumDPCols();
            int numCols = schema.getSignature().size();
            ArrayList partPos = Lists.newArrayList();
            for (int i = numCols - numPartCols; i < numCols; ++i) {
                partPos.add(i);
            }
            return partPos;
        }

        private List<Integer> getBucketPositions(List<String> tabBucketCols, List<FieldSchema> tabCols) {
            ArrayList<Integer> posns = new ArrayList<Integer>();
            block0: for (String bucketCol : tabBucketCols) {
                int pos = 0;
                for (FieldSchema tabCol : tabCols) {
                    if (bucketCol.equals(tabCol.getName())) {
                        posns.add(pos);
                        continue block0;
                    }
                    ++pos;
                }
            }
            return posns;
        }

        private void inferSortPositions(Operator<? extends OperatorDesc> fsParent, List<Integer> sortPositions, List<Integer> sortOrder) throws SemanticException {
            SelectOperator pSel;
            if (!(fsParent instanceof SelectOperator)) {
                return;
            }
            Operator parent = pSel = (SelectOperator)fsParent;
            while (!(parent instanceof ReduceSinkOperator)) {
                if (parent.getNumParent() != 1 || !(parent instanceof SelectOperator)) {
                    return;
                }
                parent = parent.getParentOperators().get(0);
            }
            ArrayList<ExprNodeDesc> selColsInPRS = ExprNodeDescUtils.backtrack(((SelectDesc)pSel.getConf()).getColList(), pSel, parent);
            ReduceSinkOperator pRS = (ReduceSinkOperator)parent;
            for (int i = 0; i < ((ReduceSinkDesc)pRS.getConf()).getKeyCols().size(); ++i) {
                ExprNodeDesc col = ((ReduceSinkDesc)pRS.getConf()).getKeyCols().get(i);
                int pos = selColsInPRS.indexOf(col);
                if (pos == -1) {
                    sortPositions.clear();
                    sortOrder.clear();
                    return;
                }
                sortPositions.add(pos);
                sortOrder.add(((ReduceSinkDesc)pRS.getConf()).getOrder().charAt(i) == '+' ? 1 : 0);
            }
        }

        public ReduceSinkOperator getReduceSinkOp(List<Integer> partitionPositions, List<Integer> sortPositions, List<Integer> sortOrder, List<Integer> sortNullOrder, List<Function<List<ExprNodeDesc>, ExprNodeDesc>> customSortExprs, List<Integer> customSortOrder, List<Integer> customSortNullOrder, ArrayList<ExprNodeDesc> allCols, ArrayList<ExprNodeDesc> bucketColumns, int numBuckets, Operator<? extends OperatorDesc> parent, AcidUtils.Operation writeType) {
            boolean customSortExprPresent = customSortExprs != null && !customSortExprs.isEmpty();
            LinkedHashSet keyColsPosInVal = Sets.newLinkedHashSet();
            ArrayList keyCols = Lists.newArrayList();
            ArrayList newSortOrder = Lists.newArrayList();
            ArrayList newSortNullOrder = Lists.newArrayList();
            if (customSortExprPresent) {
                partitionPositions = new ArrayList<Integer>();
                bucketColumns = new ArrayList();
                numBuckets = -1;
            }
            keyColsPosInVal.addAll(partitionPositions);
            if (bucketColumns != null && !bucketColumns.isEmpty()) {
                keyColsPosInVal.add(-1);
            }
            keyColsPosInVal.addAll(sortPositions);
            Integer order = 1;
            if (sortOrder != null && !sortOrder.isEmpty() && sortOrder.get(0) == 0) {
                order = 0;
            }
            for (Object ignored : keyColsPosInVal) {
                newSortOrder.add(order);
            }
            if (customSortExprPresent) {
                for (int i = 0; i < customSortExprs.size() - customSortOrder.size(); ++i) {
                    newSortOrder.add(order);
                }
                newSortOrder.addAll(customSortOrder);
            }
            Object orderStr = "";
            for (Integer i : newSortOrder) {
                if (i == 1) {
                    orderStr = (String)orderStr + "+";
                    continue;
                }
                orderStr = (String)orderStr + "-";
            }
            char nullOrder = NullOrdering.defaultNullOrder(order, (Configuration)this.parseCtx.getConf()).getSign();
            if (sortNullOrder != null && !sortNullOrder.isEmpty()) {
                nullOrder = NullOrdering.fromCode(sortNullOrder.get(0)).getSign();
            }
            StringBuilder nullOrderStr = new StringBuilder(StringUtils.repeat((char)nullOrder, (int)keyColsPosInVal.size()));
            if (customSortExprPresent) {
                int i;
                for (i = 0; i < customSortExprs.size() - customSortNullOrder.size(); ++i) {
                    nullOrderStr.append(nullOrder);
                }
                for (i = 0; i < customSortNullOrder.size(); ++i) {
                    nullOrderStr.append(NullOrdering.fromCode(customSortNullOrder.get(i)).getSign());
                }
            }
            HashMap colExprMap = Maps.newHashMap();
            ArrayList partCols = Lists.newArrayList();
            for (Function<List<ExprNodeDesc>, ExprNodeDesc> customSortExpr : customSortExprs) {
                ExprNodeDesc colExpr = customSortExpr.apply(allCols);
                keyCols.add(colExpr);
                partCols.add(colExpr);
            }
            for (Integer idx : keyColsPosInVal) {
                if (idx == -1) {
                    keyCols.add(BUCKET_SORT_EXPRESSION.apply(allCols));
                    continue;
                }
                keyCols.add(allCols.get(idx).clone());
            }
            ArrayList valCols = Lists.newArrayList();
            for (int i = 0; i < allCols.size(); ++i) {
                if (keyColsPosInVal.contains(i)) continue;
                valCols.add(allCols.get(i).clone());
            }
            for (Integer idx : partitionPositions) {
                partCols.add(allCols.get(idx).clone());
            }
            ReduceSinkOperator parentRSOp = OperatorUtils.findSingleOperatorUpstream(parent, ReduceSinkOperator.class);
            if (parentRSOp != null && this.parseCtx.getQueryProperties().hasOuterOrderBy()) {
                String parentRSOpOrder = ((ReduceSinkDesc)parentRSOp.getConf()).getOrder();
                String parentRSOpNullOrder = ((ReduceSinkDesc)parentRSOp.getConf()).getNullOrder();
                if (parentRSOpOrder != null && !parentRSOpOrder.isEmpty() && sortPositions.isEmpty()) {
                    keyCols.addAll(((ReduceSinkDesc)parentRSOp.getConf()).getKeyCols());
                    orderStr = (String)orderStr + parentRSOpOrder;
                    nullOrderStr.append(parentRSOpNullOrder);
                }
            }
            HashMap<String, CallSite> nameMapping = new HashMap<String, CallSite>();
            ArrayList keyColNames = Lists.newArrayList();
            HashSet<String> computedFields = new HashSet<String>();
            for (Object keyCol : keyCols) {
                String keyColName = ((ExprNodeDesc)keyCol).getExprString();
                keyColNames.add(keyColName);
                colExprMap.put(String.valueOf((Object)Utilities.ReduceField.KEY) + "." + keyColName, keyCol);
                nameMapping.put(keyColName, (CallSite)((Object)(String.valueOf((Object)Utilities.ReduceField.KEY) + "." + keyColName)));
            }
            ArrayList valColNames = Lists.newArrayList();
            for (ExprNodeDesc valCol : valCols) {
                String colName = valCol.getExprString();
                valColNames.add(colName);
                colExprMap.put(String.valueOf((Object)Utilities.ReduceField.VALUE) + "." + colName, valCol);
                if (nameMapping.containsKey(colName)) {
                    computedFields.add((String)nameMapping.get(colName));
                }
                nameMapping.put(colName, (CallSite)((Object)(String.valueOf((Object)Utilities.ReduceField.VALUE) + "." + colName)));
            }
            List<FieldSchema> fields = PlanUtils.getFieldSchemasFromColumnList(keyCols, keyColNames, 0, "");
            TableDesc keyTable = PlanUtils.getReduceKeyTableDesc(fields, (String)orderStr, nullOrderStr.toString());
            List<FieldSchema> valFields = PlanUtils.getFieldSchemasFromColumnList(valCols, valColNames, 0, "");
            TableDesc valueTable = PlanUtils.getReduceValueTableDesc(valFields);
            ArrayList distinctColumnIndices = Lists.newArrayList();
            ReduceSinkDesc rsConf = new ReduceSinkDesc(keyCols, keyCols.size(), valCols, keyColNames, distinctColumnIndices, valColNames, -1, partCols, -1, keyTable, valueTable, writeType);
            rsConf.setBucketCols(bucketColumns);
            rsConf.setNumBuckets(numBuckets);
            rsConf.getComputedFields().addAll(computedFields);
            ArrayList<ColumnInfo> signature = new ArrayList<ColumnInfo>();
            for (int index = 0; index < parent.getSchema().getSignature().size(); ++index) {
                ColumnInfo colInfo = new ColumnInfo(parent.getSchema().getSignature().get(index));
                colInfo.setInternalName((String)nameMapping.get(colInfo.getInternalName()));
                signature.add(colInfo);
            }
            ReduceSinkOperator op = (ReduceSinkOperator)OperatorFactory.getAndMakeChild(rsConf, new RowSchema(signature), parent, new Operator[0]);
            rsConf.addComputedField(String.valueOf((Object)Utilities.ReduceField.KEY) + "." + BUCKET_SORT_EXPRESSION.apply(allCols).getExprString());
            for (Function<List<ExprNodeDesc>, ExprNodeDesc> customSortExpr : customSortExprs) {
                rsConf.addComputedField(String.valueOf((Object)Utilities.ReduceField.KEY) + "." + customSortExpr.apply(allCols).getExprString());
            }
            op.setColumnExprMap(colExprMap);
            return op;
        }

        private List<Integer> getSortPositions(List<Order> tabSortCols, List<FieldSchema> tabCols) {
            ArrayList sortPositions = Lists.newArrayList();
            block0: for (Order sortCol : tabSortCols) {
                int pos = 0;
                for (FieldSchema tabCol : tabCols) {
                    if (sortCol.getCol().equals(tabCol.getName())) {
                        sortPositions.add(pos);
                        continue block0;
                    }
                    ++pos;
                }
            }
            return sortPositions;
        }

        private List<Integer> getSortOrders(List<Order> tabSortCols, List<FieldSchema> tabCols) {
            ArrayList sortOrders = Lists.newArrayList();
            block0: for (Order sortCol : tabSortCols) {
                for (FieldSchema tabCol : tabCols) {
                    if (!sortCol.getCol().equals(tabCol.getName())) continue;
                    sortOrders.add(sortCol.getOrder());
                    continue block0;
                }
            }
            return sortOrders;
        }

        private ArrayList<ExprNodeDesc> getPositionsToExprNodes(List<Integer> pos, List<ColumnInfo> colInfos) {
            ArrayList cols = Lists.newArrayList();
            for (Integer idx : pos) {
                ColumnInfo ci = colInfos.get(idx);
                ExprNodeColumnDesc encd = new ExprNodeColumnDesc(ci);
                cols.add(encd);
            }
            return cols;
        }

        private boolean shouldDo(List<Integer> partitionPos, Operator<? extends OperatorDesc> fsParent) {
            int threshold = HiveConf.getIntVar((Configuration)this.parseCtx.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_OPT_SORT_DYNAMIC_PARTITION_THRESHOLD);
            long MAX_WRITERS = -1L;
            switch (threshold) {
                case -1: {
                    return false;
                }
                case 0: {
                    break;
                }
                case 1: {
                    return true;
                }
                default: {
                    MAX_WRITERS = threshold;
                }
            }
            Statistics tStats = fsParent.getStatistics();
            if (tStats == null) {
                return true;
            }
            List<ColStatistics> colStats = tStats.getColumnStats();
            if (colStats == null || colStats.isEmpty()) {
                return true;
            }
            long partCardinality = 1L;
            for (Integer idx : partitionPos) {
                ColumnInfo ci = fsParent.getSchema().getSignature().get(idx);
                ColStatistics partStats = fsParent.getStatistics().getColumnStatisticsFromColName(ci.getInternalName());
                if (partStats == null) {
                    return true;
                }
                partCardinality *= partStats.getCountDistint();
            }
            if (MAX_WRITERS < 0L) {
                double orcMemPool = this.parseCtx.getConf().getDouble(OrcConf.MEMORY_POOL.getHiveConfName(), ((Double)OrcConf.MEMORY_POOL.getDefaultValue()).doubleValue());
                long orcStripSize = this.parseCtx.getConf().getLong(OrcConf.STRIPE_SIZE.getHiveConfName(), ((Long)OrcConf.STRIPE_SIZE.getDefaultValue()).longValue());
                MemoryInfo memoryInfo = new MemoryInfo((Configuration)this.parseCtx.getConf());
                this.LOG.debug("Memory info during SDPO opt: {}", (Object)memoryInfo);
                long executorMem = memoryInfo.getMaxExecutorMemory();
                MAX_WRITERS = (long)((double)executorMem * orcMemPool) / orcStripSize;
            }
            return partCardinality > MAX_WRITERS;
        }
    }
}

