/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.UnionDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

public class UnionOperator
extends Operator<UnionDesc>
implements Serializable {
    private static final long serialVersionUID = 1L;
    StructObjectInspector[] parentObjInspectors;
    List<? extends StructField>[] parentFields;
    GenericUDFUtils.ReturnObjectInspectorResolver[] columnTypeResolvers;
    boolean[] needsTransform;
    ArrayList<Object> outputRow;

    protected UnionOperator() {
    }

    public UnionOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        int c;
        int c2;
        super.initializeOp(hconf);
        int parents = this.parentOperators.size();
        this.parentObjInspectors = new StructObjectInspector[parents];
        this.parentFields = new List[parents];
        int columns = 0;
        for (int p = 0; p < parents; ++p) {
            this.parentObjInspectors[p] = (StructObjectInspector)this.inputObjInspectors[p];
            this.parentFields[p] = this.parentObjInspectors[p].getAllStructFieldRefs();
            if (p != 0 && this.parentFields[p].size() >= columns) continue;
            columns = this.parentFields[p].size();
        }
        ArrayList<String> columnNames = new ArrayList<String>(columns);
        for (c2 = 0; c2 < columns; ++c2) {
            columnNames.add(this.parentFields[0].get(c2).getFieldName());
        }
        this.columnTypeResolvers = new GenericUDFUtils.ReturnObjectInspectorResolver[columns];
        for (c2 = 0; c2 < columns; ++c2) {
            this.columnTypeResolvers[c2] = new GenericUDFUtils.ReturnObjectInspectorResolver(true);
        }
        for (int p = 0; p < parents; ++p) {
            assert (columns == 0 || this.parentFields[p].size() == columns);
            for (c = 0; c < columns; ++c) {
                if (this.columnTypeResolvers[c].updateForUnionAll(this.parentFields[p].get(c).getFieldObjectInspector())) continue;
                throw new HiveException("Incompatible types for union operator");
            }
        }
        ArrayList<ObjectInspector> outputFieldOIs = new ArrayList<ObjectInspector>(columns);
        for (c = 0; c < columns; ++c) {
            ObjectInspector fieldOI = this.parentFields[0].get(c).getFieldObjectInspector();
            outputFieldOIs.add(this.columnTypeResolvers[c].get(fieldOI));
        }
        this.outputObjInspector = ObjectInspectorFactory.getStandardStructObjectInspector(columnNames, outputFieldOIs);
        this.outputRow = new ArrayList(columns);
        for (c = 0; c < columns; ++c) {
            this.outputRow.add(null);
        }
        this.needsTransform = new boolean[parents];
        for (int p = 0; p < parents; ++p) {
            boolean bl = this.needsTransform[p] = this.inputObjInspectors[p] != this.outputObjInspector;
            if (!this.needsTransform[p]) continue;
            this.LOG.info("Union Operator needs to transform row from parent[" + p + "] from " + String.valueOf(this.inputObjInspectors[p]) + " to " + String.valueOf(this.outputObjInspector));
        }
    }

    @Override
    public synchronized void process(Object row, int tag) throws HiveException {
        StructObjectInspector soi = this.parentObjInspectors[tag];
        List<? extends StructField> fields = this.parentFields[tag];
        if (this.needsTransform[tag] && this.outputRow.size() > 0) {
            for (int c = 0; c < fields.size(); ++c) {
                this.outputRow.set(c, this.columnTypeResolvers[c].convertIfNecessary(soi.getStructFieldData(row, fields.get(c)), fields.get(c).getFieldObjectInspector()));
            }
            this.forward(this.outputRow, this.outputObjInspector);
        } else {
            this.forward(row, this.inputObjInspectors[tag]);
        }
    }

    @Override
    public String getName() {
        return UnionOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "UNION";
    }

    @Override
    public OperatorType getType() {
        return OperatorType.UNION;
    }

    @Override
    public boolean opAllowedBeforeMapJoin() {
        return false;
    }

    @Override
    public boolean opAllowedAfterMapJoin() {
        return false;
    }

    @Override
    public boolean opAllowedBeforeSortMergeJoin() {
        return false;
    }

    @Override
    public boolean logicalEquals(Operator other) {
        return this.getClass().getName().equals(other.getClass().getName());
    }
}

