/*
 * Decompiled with CFR 0.152.
 */
package com.xugu.cloudjdbc;

import com.xugu.cloudjdbc.Array;
import com.xugu.cloudjdbc.Blob;
import com.xugu.cloudjdbc.Clob;
import com.xugu.cloudjdbc.Connection;
import com.xugu.cloudjdbc.Error;
import com.xugu.cloudjdbc.NClob;
import com.xugu.cloudjdbc.Parameter;
import com.xugu.cloudjdbc.PreparedStatement;
import com.xugu.cloudjdbc.ResultSet;
import com.xugu.cloudjdbc.RowId;
import com.xugu.cloudjdbc.SQLXml;
import com.xugu.cloudjdbc.TypesUtil;
import com.xugu.common.ReplaceEnum;
import com.xugu.common.SQLCommon;
import com.xugu.util.DBobject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public class CallableStatement
extends PreparedStatement
implements java.sql.CallableStatement {
    private boolean lastWasNull = false;
    private Map columnNameToIndex = null;
    private boolean isCalendar = false;

    public CallableStatement(Connection connection, String database, String originalSql) throws SQLException {
        super(connection, database, originalSql, true);
        this.paramAllStrs = new StringBuffer();
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        if (parameterIndex < 1 || parameterIndex > this.paramCount) {
            throw Error.createSQLException("[E50007]CallableStatement:Parameter index out of range.", ReplaceEnum.excStr.getReplaceStr() + 50007, 50007);
        }
        Parameter[] pl = this.paramList.getParameters();
        pl[parameterIndex - 1].isRegist = true;
        int rh_type = TypesUtil.toRedhorseType(sqlType);
        if (rh_type == 7) {
            rh_type = 30;
        }
        if (this.isFunction && parameterIndex == 1) {
            this.paramList.setParamInfo(parameterIndex - 1, 0, rh_type, 2);
        } else {
            this.paramList.setParamInfo(parameterIndex - 1, 2, rh_type, 2);
        }
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        if (parameterIndex < 1 || parameterIndex > this.paramCount) {
            throw Error.createSQLException("[E50007]CallableStatement:Parameter index out of range.", ReplaceEnum.excStr.getReplaceStr() + 50007, 50007);
        }
        Parameter[] pl = this.paramList.getParameters();
        pl[parameterIndex - 1].isRegist = true;
        int rh_type = TypesUtil.toRedhorseType(sqlType);
        if (rh_type == 7) {
            rh_type = 30;
        }
        this.paramTypes = this.getParamType(this.paramList, parameterIndex - 1, 2);
        if (this.isFunction && parameterIndex == 1) {
            this.paramList.setParamInfo(parameterIndex - 1, null, 0, rh_type, 0, scale, 2);
        } else {
            this.paramList.setParamInfo(parameterIndex - 1, null, this.paramTypes, rh_type, 0, scale, 2);
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.lastWasNull;
    }

    @Override
    public String getString(int parameterIndex) throws SQLException {
        this.checkClosed();
        int num = 0;
        if (parameterIndex < 1 || parameterIndex > this.paramCount) {
            throw Error.createSQLException("[E50007]CallableStatement:Parameter index out of range.", ReplaceEnum.excStr.getReplaceStr() + 50007, 50007);
        }
        Parameter[] pl = this.paramList.getParameters();
        if (!pl[num + parameterIndex - 1].isRegist) {
            throw Error.createSQLException("[E50008]\u8fd4\u56de\u578b\u53c2\u6570[" + num + parameterIndex + "]\u5c1a\u672a\u6ce8\u518c", ReplaceEnum.excStr.getReplaceStr() + 50008, 50008);
        }
        byte[] bytes = (byte[])this.paramList.getParamData(num + parameterIndex - 1);
        if (bytes == null) {
            this.lastWasNull = true;
            return null;
        }
        int rh_type = this.paramList.getParamNativeType(num + parameterIndex - 1);
        switch (rh_type) {
            case 62: 
            case 63: {
                return ResultSet.bitToString(bytes, -1);
            }
            case 3: {
                byte bt = bytes[0];
                return String.valueOf(bt);
            }
            case 4: {
                ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
                short i2 = byteBuffer.getShort();
                return String.valueOf(i2);
            }
            case 5: {
                ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
                int i4 = byteBuffer.getInt();
                return String.valueOf(i4);
            }
            case 6: {
                ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
                long i8 = byteBuffer.getLong();
                return String.valueOf(i8);
            }
            case 8: {
                ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
                float r4 = byteBuffer.getFloat();
                return String.valueOf(r4);
            }
            case 9: {
                ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
                double r8 = byteBuffer.getDouble();
                return String.valueOf(r8);
            }
            case 7: {
                return new String(bytes);
            }
            case 2: {
                return new String(bytes);
            }
            case 30: 
            case 45: {
                if (bytes.length == 1 && bytes[0] == 0) {
                    return null;
                }
                return this.connection.io.getStringWithCharactor(bytes);
            }
            case 10: {
                Date d = this.getDate(parameterIndex);
                return d.toString();
            }
            case 11: 
            case 12: {
                return new String(bytes);
            }
            case 13: 
            case 14: {
                Timestamp ts = this.getTimestamp(parameterIndex);
                return ts.toString();
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return new String(bytes);
            }
            case 33: {
                return "binary";
            }
            case 34: {
                return "blob";
            }
            case 32: 
            case 47: 
            case 64: {
                if (bytes.length == 1 && bytes[0] == 0) {
                    return null;
                }
                java.sql.Clob sClob = this.getClob(parameterIndex);
                return sClob.getSubString(1L, (int)sClob.length());
            }
        }
        return null;
    }

    @Override
    public boolean getBoolean(int parameterIndex) throws SQLException {
        this.checkClosed();
        if (parameterIndex < 1 || parameterIndex > this.paramCount) {
            throw Error.createSQLException("[E50007]Parameter index out of range.", ReplaceEnum.excStr.getReplaceStr() + 50007, 50007);
        }
        Parameter[] pl = this.paramList.getParameters();
        int num = 0;
        if (!pl[num + parameterIndex - 1].isRegist) {
            throw Error.createSQLException("[E50008]\u8fd4\u56de\u578b\u53c2\u6570[" + num + parameterIndex + "]\u5c1a\u672a\u6ce8\u518c", ReplaceEnum.excStr.getReplaceStr() + 50008, 50008);
        }
        byte[] boolAsBytes = (byte[])pl[num + parameterIndex - 1].dat;
        if (boolAsBytes == null) {
            this.lastWasNull = true;
            return false;
        }
        switch (pl[num + parameterIndex - 1].rh_typeid) {
            case 62: 
            case 63: {
                long bitSize = 0L;
                for (int i = 0; i < 4; ++i) {
                    bitSize = bitSize << 8 | (long)(boolAsBytes[i] & 0xFF);
                }
                if (bitSize == 1L) {
                    return boolAsBytes[4] == 1;
                }
                throw Error.createSQLException("[E50009]CallableStatement:The data can't be swicthed to boolean type", ReplaceEnum.excStr.getReplaceStr() + 50009, 50009);
            }
            case 2: {
                if (boolAsBytes.length == 1 && boolAsBytes[0] == 84) {
                    return true;
                }
                if (boolAsBytes.length == 1 && boolAsBytes[0] == 70) {
                    return false;
                }
                throw Error.createSQLException("[E50009]CallableStatement:The data can't be swicthed to boolean type", ReplaceEnum.excStr.getReplaceStr() + 50009, 50009);
            }
            case 3: {
                return boolAsBytes[0] == -1 || boolAsBytes[0] > 0;
            }
            case 4: {
                return this.getShort(parameterIndex) == -1 || this.getShort(parameterIndex) > 0;
            }
            case 5: {
                return this.getInt(parameterIndex) == -1 || this.getInt(parameterIndex) > 0;
            }
            case 6: {
                return this.getInt(parameterIndex) == -1 || this.getInt(parameterIndex) > 0;
            }
            case 8: {
                return this.getFloat(parameterIndex) == -1.0f || this.getFloat(parameterIndex) > 0.0f;
            }
            case 9: {
                return this.getDouble(parameterIndex) == -1.0 || this.getDouble(parameterIndex) > 0.0;
            }
            case 7: {
                return this.getBigDecimal(parameterIndex).doubleValue() == -1.0 || this.getBigDecimal(parameterIndex).doubleValue() > 0.0;
            }
            case 30: {
                String stringVal = new String(boolAsBytes);
                if (stringVal != null && stringVal.length() > 0) {
                    char c = Character.toLowerCase(stringVal.charAt(0));
                    return c == 't' || c == 'f' || c == '1' || "-1".equals(stringVal);
                }
                return new Boolean("");
            }
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 32: 
            case 33: 
            case 34: {
                throw Error.createSQLException("[E50044]CallableStatement: Required types conversion are not allowed", ReplaceEnum.excStr.getReplaceStr() + 50044, 50044);
            }
        }
        return false;
    }

    @Override
    public byte getByte(int parameterIndex) throws SQLException {
        this.checkClosed();
        if (parameterIndex < 1 || parameterIndex > this.paramCount) {
            throw Error.createSQLException("[E50007]Parameter index out of range.", ReplaceEnum.excStr.getReplaceStr() + 50007, 50007);
        }
        Parameter[] pl = this.paramList.getParameters();
        if (!pl[parameterIndex - 1].isRegist) {
            throw Error.createSQLException("[E50008]\u8fd4\u56de\u578b\u53c2\u6570[" + parameterIndex + "]\u5c1a\u672a\u6ce8\u518c", ReplaceEnum.excStr.getReplaceStr() + 50008, 50008);
        }
        byte[] bytes = (byte[])this.paramList.getParamData(parameterIndex - 1);
        if (bytes == null) {
            this.lastWasNull = true;
            return 0;
        }
        return bytes[0];
    }

    @Override
    public short getShort(int parameterIndex) throws SQLException {
        this.checkClosed();
        ByteBuffer byteBuffer = null;
        short dataShort = 0;
        if (parameterIndex < 1 || parameterIndex > this.paramCount) {
            throw Error.createSQLException("[E50007]Parameter index out of range.", ReplaceEnum.excStr.getReplaceStr() + 50007, 50007);
        }
        Parameter[] pl = this.paramList.getParameters();
        int num = 0;
        if (!pl[num + parameterIndex - 1].isRegist) {
            throw Error.createSQLException("[E50008]\u8fd4\u56de\u578b\u53c2\u6570[" + num + parameterIndex + "]\u5c1a\u672a\u6ce8\u518c", ReplaceEnum.excStr.getReplaceStr() + 50008, 50008);
        }
        byte[] outbytes = (byte[])this.paramList.getParamData(num + parameterIndex - 1);
        if (outbytes == null) {
            this.lastWasNull = true;
            return 0;
        }
        int outbytes_len = outbytes.length;
        if (this.isCalendar) {
            byte[] cal = new byte[]{outbytes[outbytes_len - 2], outbytes[outbytes_len - 1]};
            byteBuffer = ByteBuffer.wrap(cal);
            dataShort = byteBuffer.getShort();
            return dataShort;
        }
        switch (this.paramList.getParamNativeType(num + parameterIndex - 1)) {
            case 62: 
            case 63: {
                String value = ResultSet.bitToString(outbytes, 16);
                try {
                    return Short.parseShort(value);
                }
                catch (NumberFormatException e) {
                    throw Error.createSQLException("[E50045]The data can't be swicthed to short type", ReplaceEnum.excStr.getReplaceStr() + 50045, 50045);
                }
            }
            case 2: {
                if (outbytes.length == 1 && outbytes[0] == 84) {
                    return 1;
                }
                if (outbytes.length == 1 && outbytes[0] == 70) {
                    return 0;
                }
                throw Error.createSQLException("[E50045]The data can't be swicthed to short type", ReplaceEnum.excStr.getReplaceStr() + 50045, 50045);
            }
            case 3: {
                return this.getByte(parameterIndex);
            }
            case 4: {
                byteBuffer = ByteBuffer.wrap(outbytes);
                dataShort = byteBuffer.getShort();
                return dataShort;
            }
            case 5: {
                Integer intVal = new Integer(this.getInt(parameterIndex));
                return intVal.shortValue();
            }
            case 6: {
                Long longVal = new Long(this.getLong(parameterIndex));
                return longVal.shortValue();
            }
            case 8: {
                Float floatVal = new Float(this.getFloat(parameterIndex));
                return floatVal.shortValue();
            }
            case 9: {
                Double doubleVal = new Double(this.getDouble(parameterIndex));
                return doubleVal.shortValue();
            }
            case 7: {
                BigDecimal decimalVal = this.getBigDecimal(parameterIndex);
                return decimalVal.shortValue();
            }
            case 30: {
                Byte byteVal = new Byte(outbytes[0]);
                return byteVal.shortValue();
            }
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 32: 
            case 33: 
            case 34: {
                throw Error.createSQLException("[E50044]CallableStatement: Required types conversion are not allowed", ReplaceEnum.excStr.getReplaceStr() + 50044, 50044);
            }
        }
        return 0;
    }

    @Override
    public int getInt(int parameterIndex) throws SQLException {
        this.checkClosed();
        int dataInt = 0;
        if (parameterIndex < 1 || parameterIndex > this.paramCount) {
            throw Error.createSQLException("[E50007]Parameter index out of range.", ReplaceEnum.excStr.getReplaceStr() + 50007, 50007);
        }
        Parameter[] pl = this.paramList.getParameters();
        int num = 0;
        if (!pl[num + parameterIndex - 1].isRegist) {
            throw this.getRegistException(parameterIndex + num);
        }
        byte[] outData = (byte[])this.paramList.getParamData(num + parameterIndex - 1);
        if (outData == null) {
            this.lastWasNull = true;
            return 0;
        }
        int outData_len = outData.length;
        if (this.isCalendar) {
            byte[] cal = new byte[]{outData[outData_len - 6], outData[outData_len - 5], outData[outData_len - 4], outData[outData_len - 3]};
            ByteBuffer byteBuffer = ByteBuffer.wrap(outData);
            dataInt = byteBuffer.getInt();
            return dataInt;
        }
        switch (pl[num + parameterIndex - 1].rh_typeid) {
            case 62: 
            case 63: {
                String value = ResultSet.bitToString(outData, 32);
                try {
                    return Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    throw Error.createSQLException("[E50046]Resultset: The data can't be switched to int type", ReplaceEnum.excStr.getReplaceStr() + 50046, 50046);
                }
            }
            case 2: {
                if (pl[num + parameterIndex - 1].datLen == 1L && outData[0] == 84) {
                    return 1;
                }
                if (pl[num + parameterIndex - 1].datLen == 1L && outData[0] == 70) {
                    return 0;
                }
                throw Error.createSQLException("[E50046]The data can't be switched to int type", ReplaceEnum.excStr.getReplaceStr() + 50046, 50046);
            }
            case 3: {
                return this.getByte(parameterIndex);
            }
            case 4: {
                return this.getShort(parameterIndex);
            }
            case 5: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                if (outData == null) {
                    this.lastWasNull = true;
                    return 0;
                }
                ByteBuffer byteBuffer = ByteBuffer.wrap(outData);
                dataInt = byteBuffer.getInt();
                return dataInt;
            }
            case 6: {
                Long longVal = new Long(this.getLong(parameterIndex));
                return longVal.intValue();
            }
            case 8: {
                Float floatVal = new Float(this.getFloat(parameterIndex));
                return floatVal.intValue();
            }
            case 9: {
                Double doubleVal = new Double(this.getDouble(parameterIndex));
                return doubleVal.intValue();
            }
            case 7: {
                BigDecimal decimalVal = this.getBigDecimal(parameterIndex);
                return decimalVal.intValue();
            }
            case 30: {
                int s;
                try {
                    s = Integer.parseInt(this.getString(parameterIndex));
                }
                catch (NumberFormatException e) {
                    Byte byteVal = new Byte(outData[0]);
                    s = byteVal.intValue();
                }
                return s;
            }
            case 13: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 32: 
            case 33: 
            case 34: {
                throw Error.createSQLException("[E50044]CallableStatement: Required types conversion are not allowed", ReplaceEnum.excStr.getReplaceStr() + 50044, 50044);
            }
        }
        return 0;
    }

    @Override
    public long getLong(int parameterIndex) throws SQLException {
        this.checkClosed();
        long dataLong = 0L;
        if (parameterIndex < 1 || parameterIndex > this.paramCount) {
            throw Error.createSQLException("[E50007]Parameter index out of range.", ReplaceEnum.excStr.getReplaceStr() + 50007, 50007);
        }
        Parameter[] pl = this.paramList.getParameters();
        int num = 0;
        if (!pl[num + parameterIndex - 1].isRegist) {
            throw Error.createSQLException("[E50008]\u8fd4\u56de\u578b\u53c2\u6570[" + num + parameterIndex + "]\u5c1a\u672a\u6ce8\u518c", ReplaceEnum.excStr.getReplaceStr() + 50008, 50008);
        }
        byte[] outData = (byte[])this.paramList.getParamData(num + parameterIndex - 1);
        if (outData == null) {
            this.lastWasNull = true;
            return 0L;
        }
        if (this.isCalendar) {
            byte[] cal = new byte[]{outData[0], outData[1], outData[2], outData[3], outData[4], outData[5], outData[6], outData[7]};
            ByteBuffer byteBuffer = ByteBuffer.wrap(outData);
            dataLong = byteBuffer.getLong();
            return dataLong;
        }
        switch (this.paramList.getParamNativeType(num + parameterIndex - 1)) {
            case 62: 
            case 63: {
                String value = ResultSet.bitToString(outData, 64);
                try {
                    return Long.parseLong(value);
                }
                catch (NumberFormatException e) {
                    throw Error.createSQLException("[E50046]The data can't be switched to int type", ReplaceEnum.excStr.getReplaceStr() + 50046, 50046);
                }
            }
            case 2: {
                if (outData.length == 1 && outData[0] == 84) {
                    return 1L;
                }
                if (outData.length == 1 && outData[0] == 70) {
                    return 0L;
                }
                throw Error.createSQLException("[E50043]CallableStatement: The data can't be switched to boolean type", ReplaceEnum.excStr.getReplaceStr() + 50043, 50043);
            }
            case 3: {
                return this.getByte(parameterIndex);
            }
            case 4: {
                return this.getShort(parameterIndex);
            }
            case 5: {
                return this.getInt(parameterIndex);
            }
            case 6: {
                if (outData == null) {
                    this.lastWasNull = true;
                    return 0L;
                }
                ByteBuffer byteBuffer = ByteBuffer.wrap(outData);
                dataLong = byteBuffer.getLong();
                return dataLong;
            }
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                ByteBuffer byteBuffer;
                if (outData.length == 4) {
                    byte[] tempLong = new byte[]{0, 0, 0, 0, outData[0], outData[1], outData[2], outData[3]};
                    byteBuffer = ByteBuffer.wrap(tempLong);
                } else {
                    byteBuffer = ByteBuffer.wrap(outData);
                }
                long timeLong = byteBuffer.getLong();
                return timeLong;
            }
            case 8: {
                Float floatVal = new Float(this.getFloat(parameterIndex));
                return floatVal.longValue();
            }
            case 9: {
                Double doubleVal = new Double(this.getDouble(parameterIndex));
                return doubleVal.longValue();
            }
            case 7: {
                BigDecimal decimalVal = this.getBigDecimal(parameterIndex);
                return decimalVal.longValue();
            }
            case 30: {
                Byte byteVal = new Byte(outData[0]);
                return byteVal.longValue();
            }
            case 32: 
            case 33: 
            case 34: {
                throw Error.createSQLException("[E50044]Callable: Required type conversion not allowed", ReplaceEnum.excStr.getReplaceStr() + 50044, 50044);
            }
        }
        return 0L;
    }

    @Override
    public float getFloat(int parameterIndex) throws SQLException {
        this.checkClosed();
        if (parameterIndex < 1 || parameterIndex > this.paramCount) {
            throw Error.createSQLException("[E50007]Parameter index out of range.", ReplaceEnum.excStr.getReplaceStr() + 50007, 50007);
        }
        Parameter[] pl = this.paramList.getParameters();
        int num = 0;
        if (!pl[num + parameterIndex - 1].isRegist) {
            throw Error.createSQLException("[E50008]\u8fd4\u56de\u578b\u53c2\u6570[" + num + parameterIndex + "]\u5c1a\u672a\u6ce8\u518c", ReplaceEnum.excStr.getReplaceStr() + 50008, 50008);
        }
        byte[] outbytes = (byte[])this.paramList.getParamData(num + parameterIndex - 1);
        if (outbytes == null) {
            this.lastWasNull = true;
            return 0.0f;
        }
        switch (this.paramList.getParamNativeType(num + parameterIndex - 1)) {
            case 2: {
                if (outbytes.length == 1 && outbytes[0] == 84) {
                    return 1.0f;
                }
                if (outbytes.length == 1 && outbytes[0] == 70) {
                    return 0.0f;
                }
                throw Error.createSQLException("[E50047]The data can't be swicthed to float type", ReplaceEnum.excStr.getReplaceStr() + 50047, 50047);
            }
            case 3: {
                return this.getByte(parameterIndex);
            }
            case 4: {
                return this.getShort(parameterIndex);
            }
            case 5: {
                return this.getInt(parameterIndex);
            }
            case 6: {
                return this.getLong(parameterIndex);
            }
            case 8: {
                ByteBuffer byteBuffer = ByteBuffer.wrap(outbytes);
                float dataFloat = byteBuffer.getFloat();
                return dataFloat;
            }
            case 9: {
                Double doubleVal = new Double(this.getDouble(parameterIndex));
                return doubleVal.floatValue();
            }
            case 7: {
                BigDecimal decimalVal = this.getBigDecimal(parameterIndex);
                return decimalVal.floatValue();
            }
            case 30: {
                String str = this.getString(parameterIndex);
                return Float.parseFloat(str);
            }
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 32: 
            case 33: 
            case 34: {
                throw Error.createSQLException("[E50044]CallableStatement: Required type conversion not allowed", ReplaceEnum.excStr.getReplaceStr() + 50044, 50044);
            }
        }
        return 0.0f;
    }

    @Override
    public double getDouble(int parameterIndex) throws SQLException {
        this.checkClosed();
        if (parameterIndex < 1 || parameterIndex > this.paramCount) {
            throw Error.createSQLException("[E50007]Parameter index out of range.", ReplaceEnum.excStr.getReplaceStr() + 50007, 50007);
        }
        Parameter[] pl = this.paramList.getParameters();
        int num = 0;
        if (!pl[num + parameterIndex - 1].isRegist) {
            throw Error.createSQLException("[E50008]\u8fd4\u56de\u578b\u53c2\u6570[" + num + parameterIndex + "]\u5c1a\u672a\u6ce8\u518c", ReplaceEnum.excStr.getReplaceStr() + 50008, 50008);
        }
        byte[] outbytes = (byte[])this.paramList.getParamData(num + parameterIndex - 1);
        if (outbytes == null) {
            this.lastWasNull = true;
            return 0.0;
        }
        switch (this.paramList.getParamNativeType(num + parameterIndex - 1)) {
            case 2: {
                if (outbytes.length == 1 && outbytes[0] == 84) {
                    return 1.0;
                }
                if (outbytes.length == 1 && outbytes[0] == 70) {
                    return 0.0;
                }
                throw Error.createSQLException("[E50048]The data can't be switched to double type", ReplaceEnum.excStr.getReplaceStr() + 50048, 50048);
            }
            case 3: {
                return this.getByte(parameterIndex);
            }
            case 4: {
                return this.getShort(parameterIndex);
            }
            case 5: {
                return this.getInt(parameterIndex);
            }
            case 6: {
                return this.getLong(parameterIndex);
            }
            case 8: {
                return this.getFloat(parameterIndex);
            }
            case 9: {
                ByteBuffer byteBuffer = ByteBuffer.wrap(outbytes);
                double dataDouble = byteBuffer.getDouble();
                return dataDouble;
            }
            case 7: {
                BigDecimal decimalVal = this.getBigDecimal(parameterIndex);
                return decimalVal.doubleValue();
            }
            case 30: {
                String str = this.getString(parameterIndex);
                return Double.parseDouble(str);
            }
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 32: 
            case 33: 
            case 34: {
                throw Error.createSQLException("[E50044]CallableStatement: Required type conversion not allowed", ReplaceEnum.excStr.getReplaceStr() + 50044, 50044);
            }
        }
        return 0.0;
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        this.checkClosed();
        if (parameterIndex < 1 || parameterIndex > this.paramCount) {
            throw Error.createSQLException("[E50007]Parameter index out of range.", ReplaceEnum.excStr.getReplaceStr() + 50007, 50007);
        }
        Parameter[] pl = this.paramList.getParameters();
        int num = 0;
        if (!pl[num + parameterIndex - 1].isRegist) {
            throw Error.createSQLException("[E50008]\u8fd4\u56de\u578b\u53c2\u6570[" + num + parameterIndex + "]\u5c1a\u672a\u6ce8\u518c", ReplaceEnum.excStr.getReplaceStr() + 50008, 50008);
        }
        byte[] outbytes = (byte[])this.paramList.getParamData(num + parameterIndex - 1);
        if (outbytes == null) {
            this.lastWasNull = true;
            return null;
        }
        BigDecimal decimal = new BigDecimal(this.getString(parameterIndex));
        return decimal;
    }

    @Override
    public byte[] getBytes(int parameterIndex) throws SQLException {
        this.checkClosed();
        if (parameterIndex < 1 || parameterIndex > this.paramCount) {
            throw Error.createSQLException("[E50007]Parameter index out of range.", ReplaceEnum.excStr.getReplaceStr() + 50007, 50007);
        }
        Parameter[] pl = this.paramList.getParameters();
        int num = 0;
        if (!pl[num + parameterIndex - 1].isRegist) {
            throw Error.createSQLException("[E50008]\u8fd4\u56de\u578b\u53c2\u6570[" + num + parameterIndex + "]\u5c1a\u672a\u6ce8\u518c", ReplaceEnum.excStr.getReplaceStr() + 50008, 50008);
        }
        byte[] outdata = (byte[])this.paramList.getParamData(num + parameterIndex - 1);
        if (outdata == null) {
            this.lastWasNull = true;
            return null;
        }
        if (this.paramList.getParamNativeType(num + parameterIndex - 1) == 62 || this.paramList.getParamNativeType(num + parameterIndex - 1) == 63) {
            byte[] values = new byte[outdata.length - 4];
            System.arraycopy(outdata, 4, values, 0, outdata.length - 4);
            return values;
        }
        return outdata;
    }

    @Override
    public Date getDate(int parameterIndex) throws SQLException {
        this.checkClosed();
        if (parameterIndex < 1 || parameterIndex > this.paramCount) {
            throw Error.createSQLException("[E50007]Parameter index out of range.", ReplaceEnum.excStr.getReplaceStr() + 50007, 50007);
        }
        Parameter[] pl = this.paramList.getParameters();
        int num = 0;
        if (!pl[num + parameterIndex - 1].isRegist) {
            throw Error.createSQLException("[E50008]\u8fd4\u56de\u578b\u53c2\u6570[" + num + parameterIndex + "]\u5c1a\u672a\u6ce8\u518c", ReplaceEnum.excStr.getReplaceStr() + 50008, 50008);
        }
        byte[] outdata = (byte[])pl[num + parameterIndex - 1].dat;
        if (outdata == null) {
            this.lastWasNull = true;
            return null;
        }
        if (pl[num + parameterIndex - 1].rh_typeid == 11 || pl[num + parameterIndex - 1].rh_typeid == 10 || pl[num + parameterIndex - 1].rh_typeid == 13) {
            int m;
            int rn_num;
            int y;
            int nn;
            int mm;
            int d;
            int ms;
            int s;
            long tt1;
            if (pl[num + parameterIndex - 1].rh_typeid == 10) {
                tt1 = this.getInt(parameterIndex);
                s = 0;
                ms = 0;
                d = (int)tt1;
            } else {
                long tt;
                tt1 = pl[num + parameterIndex - 1].rh_typeid == 11 ? (long)this.getInt(parameterIndex) : this.getLong(parameterIndex);
                ms = (int)(tt1 % 1000L);
                if (tt1 >= 0L) {
                    tt = tt1 / 1000L;
                    s = (int)(tt % 86400L);
                    d = (int)(tt / 86400L);
                } else {
                    tt = tt1 / 1000L;
                    if (ms != 0) {
                        ms += 1000;
                        --tt;
                    }
                    s = (int)(tt % 86400L);
                    d = (int)(tt / 86400L);
                    if (s != 0) {
                        s += 86400;
                        --d;
                    }
                }
            }
            if (tt1 >= 0L) {
                mm = d / 146097;
                nn = d % 146097;
                y = 1970 + 400 * mm;
                mm = nn / 36524;
                y += 100 * mm;
                mm = (nn %= 36524) / 1461;
                y += 4 * mm;
                if ((nn %= 1461) > 1096) {
                    y += 3;
                }
                if (nn > 730 && nn <= 1096) {
                    y += 2;
                }
                if (nn > 365 && nn <= 730) {
                    ++y;
                }
                if (nn == 0) {
                    --y;
                }
                rn_num = (y - 1) / 4 - (y - 1) / 100 + (y - 1) / 400;
                d = d - 365 * (y - 1970) - (rn_num -= 477);
            } else {
                mm = d / 146097;
                nn = d % 146097;
                y = 1969 + 400 * mm;
                mm = nn / 36524;
                y += 100 * mm;
                mm = (nn %= 36524) / 1461;
                y += 4 * mm;
                if ((nn %= 1461) < -1096) {
                    y -= 3;
                }
                if (nn < -731 && nn >= -1096) {
                    y -= 2;
                }
                if (nn < -365 && nn >= -731) {
                    --y;
                }
                if (nn == 0) {
                    ++y;
                }
                rn_num = (y + 1) / 4 - (y + 1) / 100 + (y + 1) / 400;
                d = d - 365 * (y + 1 - 1970) - (rn_num -= 477);
                d += ResultSet.isRn(y) ? 366 : 365;
            }
            if (d < 0) {
                d += ResultSet.isRn(--y) ? 366 : 365;
            }
            ++d;
            if (ResultSet.isRn(y)) {
                if (d > 366) {
                    d -= 366;
                    ++y;
                }
            } else if (d > 365) {
                d -= 365;
                ++y;
            }
            if (ResultSet.isRn(y)) {
                for (m = 0; m <= 11; ++m) {
                    if (d <= Connection.MTOD[1][m] || d > Connection.MTOD[1][m + 1]) continue;
                    d -= Connection.MTOD[1][m];
                    break;
                }
            } else {
                for (m = 0; m <= 11; ++m) {
                    if (d <= Connection.MTOD[0][m] || d > Connection.MTOD[0][m + 1]) continue;
                    d -= Connection.MTOD[0][m];
                    break;
                }
            }
            return new Date(y - 1900, m, d);
        }
        return null;
    }

    @Override
    public Time getTime(int parameterIndex) throws SQLException {
        this.checkClosed();
        if (parameterIndex < 1 || parameterIndex > this.paramCount) {
            throw this.getRangException(parameterIndex);
        }
        Parameter[] pl = this.paramList.getParameters();
        int num = 0;
        if (!pl[num + parameterIndex - 1].isRegist) {
            throw this.getRangException(parameterIndex + num);
        }
        byte[] outdata = (byte[])pl[num + parameterIndex - 1].dat;
        if (outdata == null) {
            this.lastWasNull = true;
            return null;
        }
        if (pl[num + parameterIndex - 1].rh_typeid == 13 || pl[num + parameterIndex - 1].rh_typeid == 11 || pl[num + parameterIndex - 1].rh_typeid == 10 || pl[num + parameterIndex - 1].rh_typeid == 12) {
            int s;
            int ms;
            if (pl[num + parameterIndex - 1].rh_typeid == 10) {
                long tt1 = this.getInt(parameterIndex);
                ms = 0;
                s = 0;
            } else {
                long tt1 = pl[num + parameterIndex - 1].rh_typeid == 11 || pl[num + parameterIndex - 1].rh_typeid == 12 ? (long)this.getInt(parameterIndex) : this.getLong(parameterIndex);
                ms = (int)(tt1 % 1000L);
                long tt = tt1 / 1000L;
                if (tt1 < 0L) {
                    if (ms != 0) {
                        ms += 1000;
                        --tt;
                    }
                    if ((s = (int)(tt % 86400L)) != 0) {
                        s += 86400;
                    }
                } else {
                    s = (int)(tt % 86400L);
                }
            }
            int h = s / 3600;
            int m = (s %= 3600) / 60;
            int se = s % 60;
            return new Time(new Timestamp(-1900, 0, 0, h, m, se, ms * 1000000).getTime());
        }
        return null;
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        this.checkClosed();
        if (parameterIndex < 1 || parameterIndex > this.paramCount) {
            throw this.getRangException(parameterIndex);
        }
        Parameter[] pl = this.paramList.getParameters();
        int num = 0;
        if (!pl[num + parameterIndex - 1].isRegist) {
            throw this.getRegistException(parameterIndex + num);
        }
        byte[] outdata = (byte[])pl[num + parameterIndex - 1].dat;
        if (outdata == null) {
            this.lastWasNull = true;
            return null;
        }
        if (pl[num + parameterIndex - 1].rh_typeid == 13 || pl[num + parameterIndex - 1].rh_typeid == 14) {
            int m;
            int rn_num;
            int y;
            int nn;
            int mm;
            int d;
            int s;
            int ms;
            long t = this.getLong(parameterIndex);
            if ((t /= 1000L) >= 0L) {
                ms = (int)(t % 1000L);
                s = (int)((t /= 1000L) % 86400L);
                d = (int)(t / 86400L);
                mm = d / 146097;
                nn = d % 146097;
                y = 1970 + 400 * mm;
                mm = nn / 36524;
                y += 100 * mm;
                mm = (nn %= 36524) / 1461;
                y += 4 * mm;
                if ((nn %= 1461) > 1096) {
                    y += 3;
                }
                if (nn > 730 && nn <= 1096) {
                    y += 2;
                }
                if (nn > 365 && nn <= 730) {
                    ++y;
                }
                if (nn == 0) {
                    --y;
                }
                rn_num = (y - 1) / 4 - (y - 1) / 100 + (y - 1) / 400;
                d = d - 365 * (y - 1970) - (rn_num -= 477);
            } else {
                ms = (int)(t % 1000L);
                t /= 1000L;
                if (ms != 0) {
                    ms += 1000;
                    --t;
                }
                s = (int)(t % 86400L);
                d = (int)(t / 86400L);
                if (s != 0) {
                    s += 86400;
                    --d;
                }
                mm = d / 146097;
                nn = d % 146097;
                y = 1969 + 400 * mm;
                mm = nn / 36524;
                y += 100 * mm;
                mm = (nn %= 36524) / 1461;
                y += 4 * mm;
                if ((nn %= 1461) < -1096) {
                    y -= 3;
                }
                if (nn < -731 && nn >= -1096) {
                    y -= 2;
                }
                if (nn < -365 && nn >= -731) {
                    --y;
                }
                if (nn == 0) {
                    ++y;
                }
                rn_num = (y + 1) / 4 - (y + 1) / 100 + (y + 1) / 400;
                d = d - 365 * (y + 1 - 1970) - (rn_num -= 477);
                d += ResultSet.isRn(y) ? 366 : 365;
            }
            if (d < 0) {
                d += ResultSet.isRn(--y) ? 366 : 365;
            }
            ++d;
            if (ResultSet.isRn(y)) {
                if (d > 366) {
                    d -= 366;
                    ++y;
                }
            } else if (d > 365) {
                d -= 365;
                ++y;
            }
            if (ResultSet.isRn(y)) {
                for (m = 0; m <= 11; ++m) {
                    if (d <= Connection.MTOD[1][m] || d > Connection.MTOD[1][m + 1]) continue;
                    d -= Connection.MTOD[1][m];
                    break;
                }
            } else {
                for (m = 0; m <= 11; ++m) {
                    if (d <= Connection.MTOD[0][m] || d > Connection.MTOD[0][m + 1]) continue;
                    d -= Connection.MTOD[0][m];
                    break;
                }
            }
            int h = s / 3600;
            int n = (s %= 3600) / 60;
            int se = s % 60;
            return new Timestamp(y - 1900, m, d, h, n, se, ms * 1000000);
        }
        return null;
    }

    @Override
    public Object getObject(int parameterIndex) throws SQLException {
        this.checkClosed();
        if (parameterIndex < 1 || parameterIndex > this.paramCount) {
            throw this.getRangException(parameterIndex);
        }
        Parameter[] pl = this.paramList.getParameters();
        int num = 0;
        if (!pl[num + parameterIndex - 1].isRegist) {
            throw this.getRegistException(parameterIndex + num);
        }
        if (!this.isOutP && pl[num + parameterIndex - 1].dat == null) {
            this.lastWasNull = true;
            return null;
        }
        Object outbytes = this.paramList.getParamData(num + parameterIndex - 1);
        if (outbytes == null) {
            return null;
        }
        switch (this.paramList.getParamNativeType(num + parameterIndex - 1)) {
            case 62: 
            case 63: {
                DBobject dBobject = new DBobject();
                dBobject.setType(TypesUtil.getRedhorseTypeName(this.paramList.getParamNativeType(num + parameterIndex - 1)));
                dBobject.setValue(ResultSet.bitToString((byte[])outbytes, -1));
                return dBobject;
            }
            case 3: {
                return new Byte(this.getByte(parameterIndex));
            }
            case 4: {
                return new Short(this.getShort(parameterIndex));
            }
            case 5: {
                return new Integer(this.getInt(parameterIndex));
            }
            case 6: {
                return new BigInteger(this.getString(parameterIndex));
            }
            case 8: {
                return new Float(this.getFloat(parameterIndex));
            }
            case 9: {
                return new Double(this.getDouble(parameterIndex));
            }
            case 7: {
                return this.getBigDecimal(parameterIndex);
            }
            case 2: {
                return new Boolean(this.getBoolean(parameterIndex));
            }
            case 30: 
            case 45: 
            case 47: {
                return this.getString(parameterIndex);
            }
            case 64: {
                return new SQLXml(this.getString(parameterIndex), this.connection);
            }
            case 10: {
                return this.getDate(parameterIndex);
            }
            case 11: {
                this.isCalendar = false;
                return this.getTime(parameterIndex);
            }
            case 12: {
                this.isCalendar = true;
                return this.getTime_TZ(parameterIndex);
            }
            case 13: {
                this.isCalendar = false;
                return this.getTimestamp(parameterIndex);
            }
            case 14: {
                this.isCalendar = true;
                return this.getTimeStamp_TZ(parameterIndex);
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return this.getInterval(parameterIndex);
            }
            case 33: {
                return this.getBinaryStream(parameterIndex);
            }
            case 34: {
                return this.getBlob(parameterIndex);
            }
            case 32: {
                return this.getClob(parameterIndex);
            }
            case 1008: {
                return (ResultSet)pl[num + parameterIndex - 1].dat;
            }
        }
        return null;
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        String decimal = this.getString(parameterIndex);
        return decimal == null ? null : new BigDecimal(decimal);
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        throw SQLCommon.unSupportException("CallableStatement.getRef", "int");
    }

    @Override
    public java.sql.Blob getBlob(int parameterIndex) throws SQLException {
        byte[] outdata;
        this.checkClosed();
        if (parameterIndex < 1 || parameterIndex > this.paramCount) {
            throw this.getRangException(parameterIndex);
        }
        Parameter[] pl = this.paramList.getParameters();
        int num = 0;
        boolean bigType = false;
        if (!pl[num + parameterIndex - 1].isRegist) {
            throw this.getRegistException(parameterIndex + num);
        }
        if (this.paramList.getParamNativeType(num + parameterIndex - 1) == 62 || this.paramList.getParamNativeType(num + parameterIndex - 1) == 63) {
            byte[] bytesBak = (byte[])pl[num + parameterIndex - 1].dat;
            outdata = new byte[bytesBak.length - 4];
            System.arraycopy(bytesBak, 4, outdata, 0, bytesBak.length - 4);
        } else {
            outdata = (byte[])pl[num + parameterIndex - 1].dat;
        }
        if (outdata == null) {
            this.lastWasNull = true;
            return null;
        }
        if (this.isObjectParam(parameterIndex) && this.connection.useLobDescribMode()) {
            boolean flag = this.isDirectLob(outdata[0]);
            return new Blob(outdata, flag, this);
        }
        return new Blob(outdata);
    }

    @Override
    public java.sql.Clob getClob(int parameterIndex) throws SQLException {
        byte[] outdata;
        this.checkClosed();
        if (parameterIndex < 1 || parameterIndex > this.paramCount) {
            throw this.getRangException(parameterIndex);
        }
        Parameter[] pl = this.paramList.getParameters();
        String clobData = null;
        int num = 0;
        if (!pl[num + parameterIndex - 1].isRegist) {
            throw this.getRegistException(parameterIndex + num);
        }
        if (this.paramList.getParamNativeType(num + parameterIndex - 1) == 62 || this.paramList.getParamNativeType(num + parameterIndex - 1) == 63) {
            byte[] bytesBak = (byte[])pl[num + parameterIndex - 1].dat;
            outdata = new byte[bytesBak.length - 4];
            System.arraycopy(bytesBak, 4, outdata, 0, bytesBak.length - 4);
        } else {
            outdata = (byte[])pl[num + parameterIndex - 1].dat;
        }
        if (outdata == null) {
            this.lastWasNull = true;
            return null;
        }
        if (this.isObjectParam(parameterIndex) && this.connection.useLobDescribMode()) {
            boolean flage = this.isDirectLob(outdata[0]);
            return new Clob(outdata, flage, this);
        }
        clobData = this.connection.io.getStringWithCharactor(outdata);
        return new Clob(clobData);
    }

    @Override
    public Array getArray(int i) throws SQLException {
        throw SQLCommon.unSupportException("CallableStatement.getArray", "int");
    }

    @Override
    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        Date date = this.getDate(parameterIndex);
        Date result = null;
        if (date != null) {
            cal.setTime(date);
            result = new Date(cal.getTimeInMillis());
        }
        return result;
    }

    @Override
    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        Time time = this.getTime(parameterIndex);
        Time result = null;
        if (time != null) {
            cal.setTime(new Date(time.getTime()));
            result = new Time(cal.getTimeInMillis());
        }
        return result;
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        Timestamp tsp = this.getTimestamp(parameterIndex);
        Timestamp result = null;
        if (tsp != null) {
            cal.setTimeInMillis(tsp.getTime());
            result = new Timestamp(cal.getTimeInMillis());
        }
        return result;
    }

    public String getInterval(int parameterIndex) throws SQLException {
        if (parameterIndex < 1 || parameterIndex > this.paramCount) {
            throw this.getRangException(parameterIndex);
        }
        Parameter[] pl = this.paramList.getParameters();
        int num = 0;
        if (!pl[num + parameterIndex - 1].isRegist) {
            throw this.getRegistException(parameterIndex + num);
        }
        byte[] outdata = (byte[])pl[num + parameterIndex - 1].dat;
        if (outdata == null) {
            this.lastWasNull = true;
            return null;
        }
        switch (this.paramList.getParamNativeType(num + parameterIndex - 1)) {
            case 10: 
            case 11: 
            case 13: {
                long msCount = this.getLong(parameterIndex);
                long second = msCount / 1000L;
                int mssecond1 = (int)(msCount % 1000L);
                long minute = second / 60L;
                int second1 = (int)(second % 60L);
                long hour = minute / 60L;
                int minute1 = (int)(minute % 60L);
                long day = hour / 24L;
                int hour1 = (int)(hour % 24L);
                long month = day / 30L;
                int day1 = (int)(day % 30L);
                long year = month / 12L;
                int month1 = (int)(month % 12L);
                return new String(year + "-" + month1 + "-" + day1 + " " + hour1 + ":" + minute1 + ":" + second1 + "." + mssecond1);
            }
            case 24: {
                long usD2S = this.getLong(parameterIndex);
                long all_se = usD2S / 1000000L;
                long real_sse = usD2S % 1000000L;
                long se = all_se / 60L;
                long real_se = all_se % 60L;
                long minu = se % 60L;
                long hur = se / 60L % 24L;
                long dayse = all_se / 86400L;
                return new String(dayse + " " + hur + ":" + minu + ":" + real_se + "." + real_sse);
            }
            case 25: {
                long usH2S = this.getLong(parameterIndex);
                long all_seH2S = usH2S / 1000000L;
                long real_see = usH2S % 1000000L;
                long allminuH2S = all_seH2S / 60L;
                int real_seH2S = (int)all_seH2S % 60;
                int minuH2S = (int)allminuH2S % 60;
                int hurH2S = (int)allminuH2S / 60;
                return new String(hurH2S + ":" + minuH2S + ":" + real_seH2S + "." + real_see);
            }
            case 26: {
                long usM2S = this.getLong(parameterIndex);
                long all_seM2S = usM2S / 1000000L;
                long millisM2S = usM2S % 1000000L;
                long real_seM2S = all_seM2S % 60L;
                int minuM2S = (int)all_seM2S / 60;
                return new String(minuM2S + ":" + real_seM2S + "." + millisM2S);
            }
            case 27: {
                long usS = this.getLong(parameterIndex);
                long real_seS = usS / 1000000L;
                long milliS = usS % 1000000L;
                return new String(real_seS + "." + milliS);
            }
            case 21: {
                int allMinute = this.getInt(parameterIndex);
                int allHour = allMinute / 60;
                int minuteD2M = allMinute % 60;
                int hourD2M = allHour % 24;
                int dayD2M = allHour / 24;
                return new String(dayD2M + " " + hourD2M + ":" + minuteD2M);
            }
            case 22: {
                int allMinuH2M = this.getInt(parameterIndex);
                int realHourH2M = allMinuH2M / 60;
                int realMinuH2M = allMinuH2M % 60;
                return new String(realHourH2M + ":" + realMinuH2M);
            }
            case 23: {
                return new String(this.getInt(parameterIndex) + "");
            }
            case 19: {
                int allHourD2H = this.getInt(parameterIndex);
                int realHour = allHourD2H % 24;
                int realDay = allHourD2H / 24;
                return new String(realDay + " " + realHour);
            }
            case 20: {
                return new String(this.getInt(parameterIndex) + "");
            }
            case 18: {
                return new String(this.getInt(parameterIndex) + "");
            }
            case 16: {
                int allDate = this.getInt(parameterIndex);
                int m = allDate % 12;
                int y = allDate / 12;
                return new String(y + "-" + m);
            }
            case 17: {
                return new String(this.getInt(parameterIndex) + "");
            }
            case 15: {
                return new String(this.getInt(parameterIndex) + "");
            }
        }
        return null;
    }

    private String getTime_TZ(int parameterIndex) throws SQLException {
        if (parameterIndex < 1 || parameterIndex > this.paramCount) {
            throw this.getRangException(parameterIndex);
        }
        Parameter[] pl = this.paramList.getParameters();
        int num = 0;
        if (!pl[num + parameterIndex - 1].isRegist) {
            throw this.getRegistException(parameterIndex + num);
        }
        byte[] outdata = (byte[])pl[num + parameterIndex - 1].dat;
        if (outdata == null) {
            this.lastWasNull = true;
            return null;
        }
        String twtz = null;
        if (this.isCalendar) {
            short shor = this.getShort(parameterIndex);
            String timeZon = null;
            String times = null;
            int minute = 0;
            int hours = 0;
            Time tt = this.getTime(parameterIndex);
            if (shor > 0) {
                minute = shor % 60;
                hours = shor / 60;
                timeZon = "+" + String.format("%02d:%02d", hours, minute);
                times = new Time(tt.getHours() + hours, tt.getMinutes() + minute, tt.getSeconds()).toString();
            } else {
                shor = (short)(shor - 2 * shor);
                minute = shor % 60;
                hours = shor / 60;
                timeZon = "-" + String.format("%02d:%02d", hours, minute);
                times = new Time(tt.getHours() - hours, tt.getMinutes() - minute, tt.getSeconds()).toString();
            }
            twtz = times + timeZon;
        }
        return twtz;
    }

    private String getTimeStamp_TZ(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this.paramCount) {
            throw this.getRangException(columnIndex);
        }
        Parameter[] pl = this.paramList.getParameters();
        int num = 0;
        if (!pl[num + columnIndex - 1].isRegist) {
            throw this.getRegistException(columnIndex + num);
        }
        byte[] outdata = (byte[])pl[num + columnIndex - 1].dat;
        if (outdata == null) {
            this.lastWasNull = true;
            return null;
        }
        String twtz = null;
        if (this.isCalendar) {
            short shor = this.getShort(columnIndex);
            String timeZon = null;
            String times = null;
            int minute = 0;
            int hours = 0;
            Timestamp tt = this.getTimestamp(columnIndex);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            if (shor > 0) {
                minute = shor % 60;
                hours = shor / 60;
                timeZon = "+" + String.format("%02d:%02d", hours, minute);
                times = sdf.format(new Timestamp(tt.getTime() + (long)(hours * 3600 * 1000) + (long)(minute * 60 * 1000)));
            } else {
                shor = (short)(shor - 2 * shor);
                minute = shor % 60;
                hours = shor / 60;
                timeZon = "-" + String.format("%02d:%02d", hours, minute);
                times = sdf.format(new Timestamp(tt.getTime() - (long)(hours * 3600 * 1000) - (long)(minute * 60 * 1000)));
            }
            twtz = times + timeZon;
        }
        return twtz;
    }

    @Override
    public void registerOutParameter(int paramIndex, int sqlType, String typeName) throws SQLException {
        Parameter[] pl = this.paramList.getParameters();
        pl[paramIndex - 1].isRegist = true;
        this.paramList.setParamInfo(paramIndex, typeName, 2, sqlType, 2);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        this.checkClosed();
        int count = 0;
        if (this.isPrepared && !this.isCallProc) {
            count = this.findIndexByParaNm(parameterName);
        } else {
            count = this.findParamIndexByParamName(parameterName);
            this.setIndexMaping(parameterName, count);
            if (this.colMap.size() == 0) {
                this.paramList.setParamName(count - 1, parameterName);
            }
        }
        this.registerOutParameter(count, sqlType);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        this.registerOutParameter(parameterName, sqlType);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        this.registerOutParameter(parameterName, sqlType);
    }

    @Override
    public URL getURL(int parameterIndex) throws SQLException {
        URL xgUrl = null;
        String urlStr = this.getString(parameterIndex);
        if (urlStr == null) {
            return null;
        }
        try {
            xgUrl = new URL(urlStr);
        }
        catch (MalformedURLException e) {
            throw Error.createSQLException("[50019]URL \u7edf\u4e00\u8d44\u6e90\u5b9a\u4f4d\u5b57\u7b26\u7a7f\u6307\u5b9a\u672a\u77e5\u534f\u8bae . ", ReplaceEnum.excStr.getReplaceStr() + 50019, 50019);
        }
        return xgUrl;
    }

    @Override
    public void setURL(String parameterName, URL val) throws SQLException {
        int paramIndex = this.getIndexByParamName(parameterName);
        this.setURL(paramIndex, val);
    }

    @Override
    public void setNull(String parameterName, int sqlType) throws SQLException {
        int paramIndex = this.getIndexByParamName(parameterName);
        this.setNull(paramIndex, sqlType);
    }

    @Override
    public void setBoolean(String parameterName, boolean x) throws SQLException {
        int paramIndex = this.getIndexByParamName(parameterName);
        this.setBoolean(paramIndex, x);
    }

    @Override
    public void setByte(String parameterName, byte x) throws SQLException {
        int paramIndex = this.getIndexByParamName(parameterName);
        this.setByte(paramIndex, x);
    }

    @Override
    public void setShort(String parameterName, short x) throws SQLException {
        int paramIndex = this.getIndexByParamName(parameterName);
        this.setShort(paramIndex, x);
    }

    @Override
    public void setInt(String parameterName, int x) throws SQLException {
        int paramIndex = this.getIndexByParamName(parameterName);
        this.setInt(paramIndex, x);
    }

    @Override
    public void setLong(String parameterName, long x) throws SQLException {
        int paramIndex = this.getIndexByParamName(parameterName);
        this.setLong(paramIndex, x);
    }

    @Override
    public void setFloat(String parameterName, float x) throws SQLException {
        int paramIndex = this.getIndexByParamName(parameterName);
        this.setFloat(paramIndex, x);
    }

    @Override
    public void setDouble(String parameterName, double x) throws SQLException {
        int paramIndex = this.getIndexByParamName(parameterName);
        this.setDouble(paramIndex, x);
    }

    @Override
    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        int paramIndex = this.getIndexByParamName(parameterName);
        this.setBigDecimal(paramIndex, x);
    }

    @Override
    public void setString(String parameterName, String x) throws SQLException {
        int paramIndex = this.getIndexByParamName(parameterName);
        this.setString(paramIndex, x);
    }

    @Override
    public void setBytes(String parameterName, byte[] x) throws SQLException {
        int paramIndex = this.getIndexByParamName(parameterName);
        this.setBytes(paramIndex, x);
    }

    @Override
    public void setDate(String parameterName, Date x) throws SQLException {
        int paramIndex = this.getIndexByParamName(parameterName);
        this.setDate(paramIndex, x);
    }

    @Override
    public void setTime(String parameterName, Time x) throws SQLException {
        int paramIndex = this.getIndexByParamName(parameterName);
        this.setTime(paramIndex, x);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        int paramIndex = this.getIndexByParamName(parameterName);
        this.setTimestamp(paramIndex, x);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        int paramIndex = this.getIndexByParamName(parameterName);
        this.setAsciiStream(paramIndex, x);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        this.checkClosed();
        int paramIndex = this.getIndexByParamName(parameterName);
        this.setBinaryStream(paramIndex, x, length);
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        this.checkClosed();
        int paramIndex = 0;
        if (this.isPrepared && !this.isCallProc) {
            paramIndex = this.findIndexByParaNm(parameterName);
            this.setObject(paramIndex, x, targetSqlType, scale);
        } else {
            paramIndex = this.handleProcParamByName(parameterName);
            int listIndex = paramIndex - 1;
            short paramTypes = 1;
            if (x == null) {
                this.setNull(paramIndex, 1);
            } else {
                byte[] paramAsByte = null;
                try {
                    paramAsByte = x.toString().getBytes(this.connection.getCharSet());
                }
                catch (UnsupportedEncodingException e) {
                    throw SQLCommon.EncodingException(e);
                }
                if (this.colMap.size() == 0) {
                    this.paramList.setParamName(listIndex, parameterName);
                }
                this.paramList.setObject(listIndex, (short)30, paramTypes, paramAsByte.length, paramAsByte);
            }
        }
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        this.checkClosed();
        int paramIndex = 0;
        if (this.isPrepared && !this.isCallProc) {
            paramIndex = this.findIndexByParaNm(parameterName);
            this.setObject(paramIndex, x, targetSqlType);
        } else {
            paramIndex = this.handleProcParamByName(parameterName);
            int listIndex = paramIndex - 1;
            short paramTypes = 1;
            if (x == null) {
                this.setNull(paramIndex, 1);
            } else {
                byte[] paramAsByte = null;
                try {
                    paramAsByte = x.toString().getBytes(this.connection.getCharSet());
                }
                catch (UnsupportedEncodingException e) {
                    throw SQLCommon.EncodingException(e);
                }
                if (this.colMap.size() == 0) {
                    this.paramList.setParamName(listIndex, parameterName);
                }
                this.paramList.setObject(listIndex, (short)30, paramTypes, paramAsByte.length, paramAsByte);
            }
        }
    }

    @Override
    public void setObject(String parameterName, Object x) throws SQLException {
        this.checkClosed();
        int paramIndex = 0;
        if (this.isPrepared && !this.isCallProc) {
            paramIndex = this.findIndexByParaNm(parameterName);
            this.setObject(paramIndex, x);
        } else {
            paramIndex = this.findParamIndexByParamName(parameterName);
            this.setIndexMaping(parameterName, paramIndex);
            int listIndex = paramIndex - 1;
            short paramTypes = 1;
            if (x == null) {
                this.setNull(paramIndex, 1);
            } else {
                byte[] paramAsByte = null;
                try {
                    paramAsByte = x.toString().getBytes(this.connection.getCharSet());
                }
                catch (UnsupportedEncodingException e) {
                    throw SQLCommon.EncodingException(e);
                }
                if (this.colMap.size() == 0) {
                    this.paramList.setParamName(listIndex, parameterName);
                }
                this.paramList.setObject(listIndex, (short)30, paramTypes, paramAsByte.length, paramAsByte);
            }
        }
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        int paramIndex = this.getIndexByParamName(parameterName);
        this.setCharacterStream(paramIndex, reader, length);
    }

    @Override
    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        int paramIndex = this.getIndexByParamName(parameterName);
        this.setDate(paramIndex, x, cal);
    }

    @Override
    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        int paramIndex = this.getIndexByParamName(parameterName);
        this.setTime(paramIndex, x, cal);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        int paramIndex = this.getIndexByParamName(parameterName);
        this.setTimestamp(paramIndex, x, cal);
    }

    @Override
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        int paramIndex = this.getIndexByParamName(parameterName);
        this.setNull(paramIndex, sqlType, typeName);
    }

    @Override
    public String getString(String parameterName) throws SQLException {
        int paramIndex = this.findIndexByParaNm(parameterName);
        return this.getString(paramIndex);
    }

    @Override
    public boolean getBoolean(String parameterName) throws SQLException {
        int paramIndex = this.findIndexByParaNm(parameterName);
        return this.getBoolean(paramIndex);
    }

    @Override
    public byte getByte(String parameterName) throws SQLException {
        int paramIndex = this.findIndexByParaNm(parameterName);
        return this.getByte(paramIndex);
    }

    @Override
    public short getShort(String parameterName) throws SQLException {
        int paramIndex = this.findIndexByParaNm(parameterName);
        return this.getShort(paramIndex);
    }

    @Override
    public int getInt(String parameterName) throws SQLException {
        int paramIndex = this.findIndexByParaNm(parameterName);
        return this.getInt(paramIndex);
    }

    @Override
    public long getLong(String parameterName) throws SQLException {
        int paramIndex = this.findIndexByParaNm(parameterName);
        return this.getLong(paramIndex);
    }

    @Override
    public float getFloat(String parameterName) throws SQLException {
        int paramIndex = this.findIndexByParaNm(parameterName);
        return this.getFloat(paramIndex);
    }

    @Override
    public double getDouble(String parameterName) throws SQLException {
        int paramIndex = this.findIndexByParaNm(parameterName);
        return this.getDouble(paramIndex);
    }

    @Override
    public byte[] getBytes(String parameterName) throws SQLException {
        int paramIndex = this.findIndexByParaNm(parameterName);
        return this.getBytes(paramIndex);
    }

    @Override
    public Date getDate(String parameterName) throws SQLException {
        int paramIndex = this.findIndexByParaNm(parameterName);
        return this.getDate(paramIndex);
    }

    @Override
    public Time getTime(String parameterName) throws SQLException {
        int paramIndex = this.findIndexByParaNm(parameterName);
        return this.getTime(paramIndex);
    }

    @Override
    public Timestamp getTimestamp(String parameterName) throws SQLException {
        int paramIndex = this.findIndexByParaNm(parameterName);
        return this.getTimestamp(paramIndex);
    }

    @Override
    public Object getObject(String parameterName) throws SQLException {
        int paramIndex = this.findIndexByParaNm(parameterName);
        return this.getObject(paramIndex);
    }

    @Override
    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        int paramIndex = this.findIndexByParaNm(parameterName);
        return this.getBigDecimal(paramIndex);
    }

    public Object getObject(int paramIndex, Map map) throws SQLException {
        return this.getObject(paramIndex);
    }

    @Override
    public Ref getRef(String parameterName) throws SQLException {
        int paramIndex = this.findIndexByParaNm(parameterName);
        return this.getRef(paramIndex);
    }

    @Override
    public java.sql.Blob getBlob(String parameterName) throws SQLException {
        int paramIndex = this.findIndexByParaNm(parameterName);
        return this.getBlob(paramIndex);
    }

    @Override
    public java.sql.Clob getClob(String parameterName) throws SQLException {
        int paramIndex = this.findIndexByParaNm(parameterName);
        return this.getClob(paramIndex);
    }

    @Override
    public java.sql.Array getArray(String parameterName) throws SQLException {
        int paramIndex = this.findIndexByParaNm(parameterName);
        return this.getArray(paramIndex);
    }

    @Override
    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        int paramIndex = this.findIndexByParaNm(parameterName);
        return this.getDate(paramIndex, cal);
    }

    @Override
    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        int paramIndex = this.findIndexByParaNm(parameterName);
        return this.getTime(paramIndex, cal);
    }

    @Override
    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        int paramIndex = this.findIndexByParaNm(parameterName);
        return this.getTimestamp(paramIndex, cal);
    }

    @Override
    public URL getURL(String parameterName) throws SQLException {
        int paramIndex = this.findIndexByParaNm(parameterName);
        return this.getURL(paramIndex);
    }

    @Override
    public Reader getCharacterStream(int parameterIndex) throws SQLException {
        java.sql.Clob rClob = this.getClob(parameterIndex);
        if (rClob == null) {
            return null;
        }
        return rClob.getCharacterStream();
    }

    @Override
    public Reader getCharacterStream(String parameterName) throws SQLException {
        int paramIndex = this.findIndexByParaNm(parameterName);
        return this.getCharacterStream(paramIndex);
    }

    @Override
    public Reader getNCharacterStream(int parameterIndex) throws SQLException {
        return this.getCharacterStream(parameterIndex);
    }

    @Override
    public Reader getNCharacterStream(String parameterName) throws SQLException {
        int paramIndex = this.findIndexByParaNm(parameterName);
        return this.getNCharacterStream(paramIndex);
    }

    @Override
    public NClob getNClob(int parameterIndex) throws SQLException {
        String lobStr = this.getString(parameterIndex);
        if (lobStr == null) {
            return null;
        }
        return new NClob(lobStr);
    }

    @Override
    public NClob getNClob(String parameterName) throws SQLException {
        int paramIndex = this.findIndexByParaNm(parameterName);
        return this.getNClob(paramIndex);
    }

    @Override
    public String getNString(int parameterIndex) throws SQLException {
        return this.getString(parameterIndex);
    }

    @Override
    public String getNString(String parameterName) throws SQLException {
        int paramIndex = this.findIndexByParaNm(parameterName);
        return this.getNString(paramIndex);
    }

    @Override
    public java.sql.RowId getRowId(int parameterIndex) throws SQLException {
        String lobStr = this.getString(parameterIndex);
        if (lobStr == null) {
            return null;
        }
        return new RowId(lobStr);
    }

    @Override
    public java.sql.RowId getRowId(String parameterName) throws SQLException {
        int paramIndex = this.findIndexByParaNm(parameterName);
        return this.getRowId(paramIndex);
    }

    @Override
    public SQLXML getSQLXML(int parameterIndex) throws SQLException {
        String xmlStr = this.getString(parameterIndex);
        if (xmlStr == null) {
            return null;
        }
        return new SQLXml(xmlStr, this.connection);
    }

    @Override
    public SQLXML getSQLXML(String parameterName) throws SQLException {
        int paramIndex = this.findIndexByParaNm(parameterName);
        return this.getSQLXML(paramIndex);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, long length) throws SQLException {
        int paramIndex = this.getIndexByParamName(parameterName);
        this.setAsciiStream(paramIndex, x, length);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x) throws SQLException {
        int paramIndex = this.getIndexByParamName(parameterName);
        this.setAsciiStream(paramIndex, x);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, long length) throws SQLException {
        int paramIndex = this.getIndexByParamName(parameterName);
        this.setBinaryStream(paramIndex, x, length);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x) throws SQLException {
        int paramIndex = this.getIndexByParamName(parameterName);
        this.setBinaryStream(paramIndex, x);
    }

    @Override
    public void setBlob(String parameterName, java.sql.Blob x) throws SQLException {
        int paramIndex = this.getIndexByParamName(parameterName);
        this.setBlob(paramIndex, x);
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        int paramIndex = this.getIndexByParamName(parameterName);
        this.setBlob(paramIndex, inputStream, length);
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        int paramIndex = this.getIndexByParamName(parameterName);
        this.setBlob(paramIndex, inputStream);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, long length) throws SQLException {
        int paramIndex = this.getIndexByParamName(parameterName);
        this.setCharacterStream(paramIndex, reader, length);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
        int paramIndex = this.getIndexByParamName(parameterName);
        this.setCharacterStream(paramIndex, reader);
    }

    @Override
    public void setClob(String parameterName, java.sql.Clob x) throws SQLException {
        int paramIndex = this.getIndexByParamName(parameterName);
        this.setClob(paramIndex, x);
    }

    @Override
    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        int paramIndex = this.getIndexByParamName(parameterName);
        this.setClob(paramIndex, reader, length);
    }

    @Override
    public void setClob(String parameterName, Reader reader) throws SQLException {
        int paramIndex = this.getIndexByParamName(parameterName);
        this.setClob(paramIndex, reader);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader reader, long length) throws SQLException {
        int paramIndex = this.getIndexByParamName(parameterName);
        this.setNCharacterStream(paramIndex, reader, length);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader reader) throws SQLException {
        int paramIndex = this.getIndexByParamName(parameterName);
        this.setNCharacterStream(paramIndex, reader);
    }

    @Override
    public void setNClob(String parameterName, java.sql.NClob value) throws SQLException {
        int paramIndex = this.getIndexByParamName(parameterName);
        this.setNClob(paramIndex, value);
    }

    @Override
    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        int paramIndex = this.getIndexByParamName(parameterName);
        this.setNClob(paramIndex, reader, length);
    }

    @Override
    public void setNClob(String parameterName, Reader reader) throws SQLException {
        int paramIndex = this.getIndexByParamName(parameterName);
        this.setNClob(paramIndex, reader);
    }

    @Override
    public <T> T getObject(int parameterIndex, Class<T> type) throws SQLException {
        return null;
    }

    @Override
    public <T> T getObject(String parameterName, Class<T> type) throws SQLException {
        return null;
    }

    @Override
    public void setNString(String parameterName, String value) throws SQLException {
        int paramIndex = this.getIndexByParamName(parameterName);
        this.setNString(paramIndex, value);
    }

    @Override
    public void setRowId(String parameterName, java.sql.RowId x) throws SQLException {
        int paramIndex = this.getIndexByParamName(parameterName);
        this.setRowId(paramIndex, x);
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        int paramIndex = this.getIndexByParamName(parameterName);
        this.setSQLXML(paramIndex, xmlObject);
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    private void buildIndexMapping(String param) throws SQLException {
        int num = 1;
        String myParam = param;
        String paramName = "";
        String[] params = null;
        if (myParam.indexOf(",") != -1) {
            params = myParam.split(",");
        }
        if (params != null) {
            num = params.length;
        }
        this.columnNameToIndex = new HashMap(num);
        for (int i = 1; i <= num; ++i) {
            Integer index = new Integer(i);
            if (params[i - 1] != null) {
                paramName = params[i - 1].trim().substring(0, params[i - 1].trim().indexOf(" "));
            }
            if (paramName == null) continue;
            this.columnNameToIndex.put(paramName, index);
            this.columnNameToIndex.put(paramName.toUpperCase(), index);
            this.columnNameToIndex.put(paramName.toLowerCase(), index);
        }
    }

    private int findIndexByParaNm(String paramName) throws SQLException {
        if (paramName == null) {
            throw Error.createSQLException("[E50079]The parameter_name is not correct. ", ReplaceEnum.excStr.getReplaceStr() + 50079, 50079);
        }
        this.checkClosed();
        Integer index = (Integer)this.paramNameToIndex.get(paramName.toLowerCase());
        index = index != null ? Integer.valueOf(String.valueOf(index)) : Integer.valueOf(String.valueOf(-1));
        if (index == -1) {
            throw Error.createSQLException("[E50079]The parameter_name is not correct. ", ReplaceEnum.excStr.getReplaceStr() + 50079, 50079);
        }
        return index;
    }

    private InputStream getBinaryStream(int parameterIndex) throws SQLException {
        if (parameterIndex < 1 || parameterIndex > this.paramCount) {
            throw this.getRangException(parameterIndex);
        }
        Parameter[] pl = this.paramList.getParameters();
        int num = 0;
        if (!pl[num + parameterIndex - 1].isRegist) {
            throw this.getRegistException(parameterIndex + num);
        }
        byte[] outdata = (byte[])pl[num + parameterIndex - 1].dat;
        if (outdata == null) {
            this.lastWasNull = true;
            return null;
        }
        byte[] dataAsBytes = (byte[])pl[num + parameterIndex - 1].dat;
        return new ByteArrayInputStream(dataAsBytes);
    }

    boolean isObjectParam(int i) {
        int param_redhorseType = this.paramList.getParamNativeType(i - 1);
        return param_redhorseType == 33 || param_redhorseType == 34 || param_redhorseType == 32;
    }

    private SQLException getRangException(int index) {
        SQLException rangException = Error.createSQLException("[E50007]Parameter index " + index + " out of range.", ReplaceEnum.excStr.getReplaceStr() + 50007, 50007);
        return rangException;
    }

    private SQLException getRegistException(int index) {
        SQLException registExcption = Error.createSQLException("[E50008]\u8fd4\u56de\u578b\u53c2\u6570[" + index + "]\u5c1a\u672a\u6ce8\u518c", ReplaceEnum.excStr.getReplaceStr() + 50008, 50008);
        return registExcption;
    }

    @Override
    public Object getObject(String parameterName, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(parameterName);
    }

    private int handleProcParamByName(String paramName) throws SQLException {
        int paramIndex = 0;
        String paramNameLowerCase = paramName.toLowerCase();
        paramIndex = this.findParamIndexByParamName(paramNameLowerCase);
        this.setIndexMaping(paramName, paramIndex);
        return paramIndex;
    }

    private int findParamIndexByParamName(String paramName) throws SQLException {
        if (paramName == null) {
            throw Error.createSQLException("[E50079]The parameter_name is not correct. ", ReplaceEnum.excStr.getReplaceStr() + 50079, 50079);
        }
        Integer paramIndex = null;
        String paramNameLowerCase = paramName.toLowerCase();
        if (this.colMap.size() == 0) {
            if ((paramIndex = Integer.valueOf(++this.paramNameIndex)) > 1) {
                this.paramAllStrs.append(",");
            } else {
                this.paramAllStrs.append("(");
            }
            this.paramAllStrs.append(":").append(paramName);
            this.paramList.setParamName(paramIndex - 1, paramName);
        } else {
            paramIndex = (Integer)this.colMap.get(paramNameLowerCase);
            if (paramIndex == null) {
                throw Error.createSQLException("[E50079]The parameter_name is not correct. ", ReplaceEnum.excStr.getReplaceStr() + 50079, 50079);
            }
        }
        return paramIndex;
    }

    private int getIndexByParamName(String parameterName) throws SQLException {
        int paramIndex = 0;
        this.checkClosed();
        paramIndex = this.isPrepared && !this.isCallProc ? this.findIndexByParaNm(parameterName) : this.handleProcParamByName(parameterName);
        return paramIndex;
    }
}

