/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.constraint.ConstraintException;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.TableStateManager;
import org.apache.hadoop.hbase.master.procedure.AbstractStateMachineTableProcedure;
import org.apache.hadoop.hbase.master.procedure.CloseTableRegionsProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureUtil;
import org.apache.hadoop.hbase.master.procedure.ProcedurePrepareLatch;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.util.ConcurrentMapUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.wal.WALSplitUtil;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class DisableTableProcedure
extends AbstractStateMachineTableProcedure<MasterProcedureProtos.DisableTableState> {
    private static final Logger LOG = LoggerFactory.getLogger(DisableTableProcedure.class);
    private TableName tableName;
    private boolean skipTableStateCheck;

    public DisableTableProcedure() {
    }

    public DisableTableProcedure(MasterProcedureEnv env, TableName tableName, boolean skipTableStateCheck) throws HBaseIOException {
        this(env, tableName, skipTableStateCheck, null);
    }

    public DisableTableProcedure(MasterProcedureEnv env, TableName tableName, boolean skipTableStateCheck, ProcedurePrepareLatch syncLatch) throws HBaseIOException {
        super(env, syncLatch);
        this.tableName = tableName;
        this.preflightChecks(env, true);
        this.skipTableStateCheck = skipTableStateCheck;
    }

    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.DisableTableState state) throws InterruptedException {
        LOG.trace("{} execute state={}", (Object)this, (Object)state);
        try {
            switch (state) {
                case DISABLE_TABLE_PREPARE: {
                    if (this.prepareDisable(env)) {
                        this.setNextState(MasterProcedureProtos.DisableTableState.DISABLE_TABLE_PRE_OPERATION);
                        break;
                    }
                    assert (this.isFailed()) : "disable should have an exception here";
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                case DISABLE_TABLE_PRE_OPERATION: {
                    this.preDisable(env, state);
                    this.setNextState(MasterProcedureProtos.DisableTableState.DISABLE_TABLE_SET_DISABLING_TABLE_STATE);
                    break;
                }
                case DISABLE_TABLE_SET_DISABLING_TABLE_STATE: {
                    DisableTableProcedure.setTableStateToDisabling(env, this.tableName);
                    this.setNextState(MasterProcedureProtos.DisableTableState.DISABLE_TABLE_MARK_REGIONS_OFFLINE);
                    break;
                }
                case DISABLE_TABLE_MARK_REGIONS_OFFLINE: {
                    this.addChildProcedure((Procedure[])new CloseTableRegionsProcedure[]{new CloseTableRegionsProcedure(this.tableName)});
                    this.setNextState(MasterProcedureProtos.DisableTableState.DISABLE_TABLE_ADD_REPLICATION_BARRIER);
                    break;
                }
                case DISABLE_TABLE_ADD_REPLICATION_BARRIER: {
                    if (env.getMasterServices().getTableDescriptors().get(this.tableName).hasGlobalReplicationScope()) {
                        MasterFileSystem fs = env.getMasterFileSystem();
                        try (BufferedMutator mutator = env.getMasterServices().getConnection().getBufferedMutator(TableName.META_TABLE_NAME);){
                            for (RegionInfo region : env.getAssignmentManager().getRegionStates().getRegionsOfTable(this.tableName)) {
                                long maxSequenceId = WALSplitUtil.getMaxRegionSequenceId(env.getMasterConfiguration(), region, (ConcurrentMapUtils.IOExceptionSupplier<FileSystem>)((ConcurrentMapUtils.IOExceptionSupplier)fs::getFileSystem), (ConcurrentMapUtils.IOExceptionSupplier<FileSystem>)((ConcurrentMapUtils.IOExceptionSupplier)fs::getWALFileSystem));
                                long openSeqNum = maxSequenceId > 0L ? maxSequenceId + 1L : -1L;
                                mutator.mutate((Mutation)MetaTableAccessor.makePutForReplicationBarrier((RegionInfo)region, (long)openSeqNum, (long)EnvironmentEdgeManager.currentTime()));
                            }
                        }
                    }
                    this.setNextState(MasterProcedureProtos.DisableTableState.DISABLE_TABLE_SET_DISABLED_TABLE_STATE);
                    break;
                }
                case DISABLE_TABLE_SET_DISABLED_TABLE_STATE: {
                    DisableTableProcedure.setTableStateToDisabled(env, this.tableName);
                    this.setNextState(MasterProcedureProtos.DisableTableState.DISABLE_TABLE_POST_OPERATION);
                    break;
                }
                case DISABLE_TABLE_POST_OPERATION: {
                    this.postDisable(env, state);
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                default: {
                    throw new UnsupportedOperationException("Unhandled state=" + state);
                }
            }
        }
        catch (IOException e) {
            if (this.isRollbackSupported(state)) {
                this.setFailure("master-disable-table", e);
            }
            LOG.warn("Retryable error in {}", (Object)this, (Object)e);
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.DisableTableState state) throws IOException {
        switch (state) {
            case DISABLE_TABLE_PRE_OPERATION: {
                return;
            }
            case DISABLE_TABLE_PREPARE: {
                this.releaseSyncLatch();
                return;
            }
        }
        throw new UnsupportedOperationException("Unhandled state=" + state);
    }

    protected boolean isRollbackSupported(MasterProcedureProtos.DisableTableState state) {
        switch (state) {
            case DISABLE_TABLE_PREPARE: 
            case DISABLE_TABLE_PRE_OPERATION: {
                return true;
            }
        }
        return false;
    }

    protected MasterProcedureProtos.DisableTableState getState(int stateId) {
        return MasterProcedureProtos.DisableTableState.forNumber((int)stateId);
    }

    protected int getStateId(MasterProcedureProtos.DisableTableState state) {
        return state.getNumber();
    }

    protected MasterProcedureProtos.DisableTableState getInitialState() {
        return MasterProcedureProtos.DisableTableState.DISABLE_TABLE_PREPARE;
    }

    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        MasterProcedureProtos.DisableTableStateData.Builder disableTableMsg = MasterProcedureProtos.DisableTableStateData.newBuilder().setUserInfo(MasterProcedureUtil.toProtoUserInfo(this.getUser())).setTableName(ProtobufUtil.toProtoTableName((TableName)this.tableName)).setSkipTableStateCheck(this.skipTableStateCheck);
        serializer.serialize((Message)disableTableMsg.build());
    }

    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        MasterProcedureProtos.DisableTableStateData disableTableMsg = (MasterProcedureProtos.DisableTableStateData)serializer.deserialize(MasterProcedureProtos.DisableTableStateData.class);
        this.setUser(MasterProcedureUtil.toUserInfo(disableTableMsg.getUserInfo()));
        this.tableName = ProtobufUtil.toTableName((HBaseProtos.TableName)disableTableMsg.getTableName());
        this.skipTableStateCheck = disableTableMsg.getSkipTableStateCheck();
    }

    @Override
    public TableName getTableName() {
        return this.tableName;
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.DISABLE;
    }

    private boolean prepareDisable(MasterProcedureEnv env) throws IOException {
        TableStateManager tsm;
        TableState ts;
        boolean canTableBeDisabled = true;
        if (this.tableName.equals((Object)TableName.META_TABLE_NAME)) {
            this.setFailure("master-disable-table", (Throwable)((Object)new ConstraintException("Cannot disable " + this.tableName)));
            canTableBeDisabled = false;
        } else if (!env.getMasterServices().getTableDescriptors().exists(this.tableName)) {
            this.setFailure("master-disable-table", new TableNotFoundException(this.tableName));
            canTableBeDisabled = false;
        } else if (!this.skipTableStateCheck && !(ts = (tsm = env.getMasterServices().getTableStateManager()).getTableState(this.tableName)).isEnabled()) {
            LOG.info("Not ENABLED, state={}, skipping disable; {}", (Object)ts.getState(), (Object)this);
            this.setFailure("master-disable-table", (Throwable)new TableNotEnabledException(ts.toString()));
            canTableBeDisabled = false;
        }
        this.releaseSyncLatch();
        return canTableBeDisabled;
    }

    protected void preDisable(MasterProcedureEnv env, MasterProcedureProtos.DisableTableState state) throws IOException, InterruptedException {
        this.runCoprocessorAction(env, state);
    }

    private static void setTableStateToDisabling(MasterProcedureEnv env, TableName tableName) throws IOException {
        env.getMasterServices().getTableStateManager().setTableState(tableName, TableState.State.DISABLING);
        LOG.info("Set {} to state={}", (Object)tableName, (Object)TableState.State.DISABLING);
    }

    protected static void setTableStateToDisabled(MasterProcedureEnv env, TableName tableName) throws IOException {
        env.getMasterServices().getTableStateManager().setTableState(tableName, TableState.State.DISABLED);
        LOG.info("Set {} to state={}", (Object)tableName, (Object)TableState.State.DISABLED);
    }

    protected void postDisable(MasterProcedureEnv env, MasterProcedureProtos.DisableTableState state) throws IOException, InterruptedException {
        this.runCoprocessorAction(env, state);
    }

    private void runCoprocessorAction(MasterProcedureEnv env, MasterProcedureProtos.DisableTableState state) throws IOException, InterruptedException {
        MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            switch (state) {
                case DISABLE_TABLE_PRE_OPERATION: {
                    cpHost.preDisableTableAction(this.tableName, this.getUser());
                    break;
                }
                case DISABLE_TABLE_POST_OPERATION: {
                    cpHost.postCompletedDisableTableAction(this.tableName, this.getUser());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(this + " unhandled state=" + state);
                }
            }
        }
    }
}

