/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.lang.reflect.Member;
import java.util.Map;
import java.util.Set;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.binding.AssignedName;
import org.jruby.javasupport.proxy.JavaProxyClass;
import org.jruby.javasupport.util.ObjectProxyCache;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.collections.ClassValue;

public abstract class JavaSupport {
    public abstract Class loadJavaClass(String var1) throws ClassNotFoundException;

    public abstract Class loadJavaClassVerbose(String var1);

    public abstract Class loadJavaClassQuiet(String var1);

    public abstract JavaClass getJavaClassFromCache(Class var1);

    public abstract RubyModule getProxyClassFromCache(Class var1);

    public abstract void handleNativeException(Throwable var1, Member var2);

    public abstract ObjectProxyCache<IRubyObject, RubyClass> getObjectProxyCache();

    public abstract Map<String, JavaClass> getNameClassMap();

    @Deprecated
    public abstract Object getJavaObjectVariable(Object var1, int var2);

    @Deprecated
    public abstract void setJavaObjectVariable(Object var1, int var2, Object var3);

    public abstract RubyModule getJavaModule();

    public abstract RubyModule getJavaUtilitiesModule();

    public abstract RubyModule getJavaArrayUtilitiesModule();

    public abstract RubyClass getJavaObjectClass();

    public abstract JavaClass getObjectJavaClass();

    public abstract void setObjectJavaClass(JavaClass var1);

    public abstract RubyClass getJavaArrayClass();

    public abstract RubyClass getJavaClassClass();

    public abstract RubyClass getJavaPackageClass();

    public abstract RubyModule getJavaInterfaceTemplate();

    @Deprecated
    public abstract RubyModule getPackageModuleTemplate();

    public abstract RubyClass getJavaProxyClass();

    public abstract RubyClass getArrayJavaProxyCreatorClass();

    public abstract RubyClass getConcreteProxyClass();

    public abstract RubyClass getMapJavaProxyClass();

    public abstract RubyClass getArrayProxyClass();

    public abstract RubyClass getJavaFieldClass();

    public abstract RubyClass getJavaMethodClass();

    public abstract RubyClass getJavaConstructorClass();

    public abstract RubyClass getJavaProxyConstructorClass();

    public abstract ClassValue<Map<String, AssignedName>> getStaticAssignedNames();

    public abstract ClassValue<Map<String, AssignedName>> getInstanceAssignedNames();

    @Deprecated
    public abstract Map<Set<?>, JavaProxyClass> getJavaProxyClassCache();

    protected abstract JavaProxyClass fetchJavaProxyClass(ProxyClassKey var1);

    protected abstract JavaProxyClass saveJavaProxyClass(ProxyClassKey var1, JavaProxyClass var2);

    public abstract void beginProxy(Class var1, RubyModule var2);

    public abstract void endProxy(Class var1);

    public abstract RubyModule getUnfinishedProxy(Class var1);

    public static final class ProxyClassKey {
        final Class superClass;
        final Class[] interfaces;
        final Set<String> names;
        private int hash;

        private ProxyClassKey(Class superClass, Class[] interfaces2, Set<String> names2) {
            this.superClass = superClass;
            this.interfaces = interfaces2;
            this.names = names2;
        }

        public static ProxyClassKey getInstance(Class superClass, Class[] interfaces2, Set<String> names2) {
            return new ProxyClassKey(superClass, interfaces2, names2);
        }

        public boolean equals(Object obj) {
            if (obj instanceof ProxyClassKey) {
                ProxyClassKey that = (ProxyClassKey)obj;
                if (this.superClass != that.superClass) {
                    return false;
                }
                if (this.names.size() != that.names.size()) {
                    return false;
                }
                if (!this.names.equals(that.names)) {
                    return false;
                }
                int len = this.interfaces.length;
                if (len != that.interfaces.length) {
                    return false;
                }
                for (int i2 = 0; i2 < len; ++i2) {
                    Class iface = this.interfaces[i2];
                    boolean ifaceFound = false;
                    for (int j = 0; j < len; ++j) {
                        if (iface != that.interfaces[j]) continue;
                        ifaceFound = true;
                        break;
                    }
                    if (ifaceFound) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            int hash2 = this.hash;
            if (hash2 != 0) {
                return hash2;
            }
            for (int i2 = 0; i2 < this.interfaces.length; ++i2) {
                hash2 += this.interfaces[i2].hashCode();
            }
            this.hash = hash2 * this.superClass.hashCode() ^ this.names.hashCode();
            return this.hash;
        }
    }
}

