/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.EnumSet;
import org.jruby.ir.IRFlags;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.TwoOperandInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class AliasInstr
extends TwoOperandInstr
implements FixedArityInstr {
    public AliasInstr(Operand newName, Operand oldName) {
        super(Operation.ALIAS, newName, oldName);
    }

    @Override
    public boolean computeScopeFlags(IRScope scope, EnumSet<IRFlags> flags2) {
        flags2.add(IRFlags.REQUIRES_DYNSCOPE);
        return true;
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.getNewName());
        e.encode(this.getOldName());
    }

    public static AliasInstr decode(IRReaderDecoder d) {
        return new AliasInstr(d.decodeOperand(), d.decodeOperand());
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new AliasInstr(this.getNewName().cloneForInlining(ii), this.getOldName().cloneForInlining(ii));
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        IRubyObject newName = (IRubyObject)this.getNewName().retrieve(context, self2, currScope, currDynScope, temp);
        IRubyObject oldName = (IRubyObject)this.getOldName().retrieve(context, self2, currScope, currDynScope, temp);
        IRRuntimeHelpers.defineAlias(context, self2, currDynScope, newName, oldName);
        return null;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.AliasInstr(this);
    }

    public Operand getNewName() {
        return this.getOperand1();
    }

    public Operand getOldName() {
        return this.getOperand2();
    }
}

