/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.QueueState;
import org.apache.hadoop.yarn.api.records.QueueStatistics;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.security.AccessRequest;
import org.apache.hadoop.yarn.security.PrivilegedEntity;
import org.apache.hadoop.yarn.security.YarnAuthorizationProvider;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.ConfigurableResource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.Schedulable;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.SchedulingPolicy;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class FSQueue
implements Queue,
Schedulable {
    private static final Logger LOG = LoggerFactory.getLogger((String)FSQueue.class.getName());
    private Resource fairShare = Resources.createResource((int)0, (int)0);
    private Resource steadyFairShare = Resources.createResource((int)0, (int)0);
    private Resource reservedResource = Resources.createResource((int)0, (int)0);
    private final Resource resourceUsage = Resource.newInstance((int)0, (int)0);
    private final String name;
    protected final FairScheduler scheduler;
    private final YarnAuthorizationProvider authorizer;
    private final PrivilegedEntity queueEntity;
    private final FSQueueMetrics metrics;
    protected final FSParentQueue parent;
    protected final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    protected SchedulingPolicy policy = SchedulingPolicy.DEFAULT_POLICY;
    protected float weights;
    protected Resource minShare;
    private ConfigurableResource maxShare;
    protected int maxRunningApps;
    private ConfigurableResource maxChildQueueResource;
    protected float maxAMShare;
    private long fairSharePreemptionTimeout = Long.MAX_VALUE;
    private long minSharePreemptionTimeout = Long.MAX_VALUE;
    private float fairSharePreemptionThreshold = 0.5f;
    private boolean preemptable = true;
    private boolean isDynamic = true;
    protected Resource maxContainerAllocation;

    public FSQueue(String name, FairScheduler scheduler, FSParentQueue parent) {
        this.name = name;
        this.scheduler = scheduler;
        this.authorizer = YarnAuthorizationProvider.getInstance((Configuration)scheduler.getConf());
        this.queueEntity = new PrivilegedEntity(PrivilegedEntity.EntityType.QUEUE, name);
        this.metrics = FSQueueMetrics.forQueue(this.getName(), parent, true, scheduler.getConf());
        this.parent = parent;
        this.setPolicy(scheduler.getAllocationConfiguration().getSchedulingPolicy(name));
        this.reinit(false);
    }

    public final void reinit(boolean recursive) {
        AllocationConfiguration allocConf = this.scheduler.getAllocationConfiguration();
        allocConf.initFSQueue(this);
        this.updatePreemptionVariables();
        if (recursive) {
            for (FSQueue child : this.getChildQueues()) {
                child.reinit(recursive);
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getQueueName() {
        return this.name;
    }

    public SchedulingPolicy getPolicy() {
        return this.policy;
    }

    public FSParentQueue getParent() {
        return this.parent;
    }

    public void setPolicy(SchedulingPolicy policy) {
        policy.initialize(this.scheduler.getContext());
        this.policy = policy;
    }

    public void setWeights(float weights) {
        this.weights = weights;
    }

    @Override
    public float getWeight() {
        return this.weights;
    }

    public void setMinShare(Resource minShare) {
        this.minShare = minShare;
    }

    @Override
    public Resource getMinShare() {
        return this.minShare;
    }

    public void setMaxShare(ConfigurableResource maxShare) {
        this.maxShare = maxShare;
    }

    public void setMaxContainerAllocation(Resource maxContainerAllocation) {
        this.maxContainerAllocation = maxContainerAllocation;
    }

    public abstract Resource getMaximumContainerAllocation();

    @Override
    public Resource getMaxShare() {
        Resource result;
        Resource maxResource = this.maxShare.getResource(this.scheduler.getClusterResource());
        if (!Resources.equals((Resource)maxResource, (Resource)(result = Resources.componentwiseMax((Resource)maxResource, (Resource)this.minShare)))) {
            LOG.warn(String.format("Queue %s has max resources %s less than min resources %s", this.getName(), maxResource, this.minShare));
        }
        return result;
    }

    public ConfigurableResource getRawMaxShare() {
        return this.maxShare;
    }

    public Resource getReservedResource() {
        this.reservedResource.setMemorySize(this.metrics.getReservedMB());
        this.reservedResource.setVirtualCores(this.metrics.getReservedVirtualCores());
        return this.reservedResource;
    }

    public void setMaxChildQueueResource(ConfigurableResource maxChildShare) {
        this.maxChildQueueResource = maxChildShare;
    }

    public ConfigurableResource getMaxChildQueueResource() {
        return this.maxChildQueueResource;
    }

    public void setMaxRunningApps(int maxRunningApps) {
        this.maxRunningApps = maxRunningApps;
    }

    public int getMaxRunningApps() {
        return this.maxRunningApps;
    }

    @VisibleForTesting
    public float getMaxAMShare() {
        return this.maxAMShare;
    }

    public void setMaxAMShare(float maxAMShare) {
        this.maxAMShare = maxAMShare;
    }

    @Override
    public long getStartTime() {
        return 0L;
    }

    @Override
    public Priority getPriority() {
        Priority p = (Priority)this.recordFactory.newRecordInstance(Priority.class);
        p.setPriority(1);
        return p;
    }

    @Override
    public QueueInfo getQueueInfo(boolean includeChildQueues, boolean recursive) {
        QueueInfo queueInfo = (QueueInfo)this.recordFactory.newRecordInstance(QueueInfo.class);
        queueInfo.setSchedulerType("FairScheduler");
        queueInfo.setQueueName(this.getQueueName());
        if (this.scheduler.getClusterResource().getMemorySize() == 0L) {
            queueInfo.setCapacity(0.0f);
        } else {
            queueInfo.setCapacity((float)this.getFairShare().getMemorySize() / (float)this.scheduler.getClusterResource().getMemorySize());
        }
        if (this.getFairShare().getMemorySize() == 0L) {
            queueInfo.setCurrentCapacity(0.0f);
        } else {
            queueInfo.setCurrentCapacity((float)this.getResourceUsage().getMemorySize() / (float)this.getFairShare().getMemorySize());
        }
        queueInfo.setWeight(this.getWeight());
        Resource minShareResource = this.getMinShare();
        queueInfo.setMinResourceVCore(minShareResource.getVirtualCores());
        queueInfo.setMinResourceMemory(minShareResource.getMemorySize());
        Resource maxShareResource = Resources.componentwiseMin((Resource)this.getMaxShare(), (Resource)this.scheduler.getClusterResource());
        queueInfo.setMaxResourceVCore(maxShareResource.getVirtualCores());
        queueInfo.setMaxResourceMemory(maxShareResource.getMemorySize());
        Resource newReservedResource = this.getReservedResource();
        queueInfo.setReservedResourceVCore(newReservedResource.getVirtualCores());
        queueInfo.setReservedResourceMemory(newReservedResource.getMemorySize());
        Resource newSteadyFairShare = this.getSteadyFairShare();
        queueInfo.setSteadyFairShareVCore(newSteadyFairShare.getVirtualCores());
        queueInfo.setSteadyFairShareMemory(newSteadyFairShare.getMemorySize());
        queueInfo.setMaxRunningApp(this.getMaxRunningApps());
        queueInfo.setPreemptionDisabled(this.isPreemptable());
        ArrayList<QueueInfo> childQueueInfos = new ArrayList<QueueInfo>();
        if (includeChildQueues) {
            List<FSQueue> childQueues = this.getChildQueues();
            for (FSQueue child : childQueues) {
                childQueueInfos.add(child.getQueueInfo(recursive, recursive));
            }
        }
        queueInfo.setChildQueues(childQueueInfos);
        queueInfo.setQueueState(QueueState.RUNNING);
        queueInfo.setQueueStatistics(this.getQueueStatistics());
        return queueInfo;
    }

    public QueueStatistics getQueueStatistics() {
        QueueStatistics stats = (QueueStatistics)this.recordFactory.newRecordInstance(QueueStatistics.class);
        stats.setNumAppsSubmitted((long)this.getMetrics().getAppsSubmitted());
        stats.setNumAppsRunning((long)this.getMetrics().getAppsRunning());
        stats.setNumAppsPending((long)this.getMetrics().getAppsPending());
        stats.setNumAppsCompleted((long)this.getMetrics().getAppsCompleted());
        stats.setNumAppsKilled((long)this.getMetrics().getAppsKilled());
        stats.setNumAppsFailed((long)this.getMetrics().getAppsFailed());
        stats.setNumActiveUsers((long)this.getMetrics().getActiveUsers());
        stats.setAvailableMemoryMB(this.getMetrics().getAvailableMB());
        stats.setAllocatedMemoryMB(this.getMetrics().getAllocatedMB());
        stats.setPendingMemoryMB(this.getMetrics().getPendingMB());
        stats.setReservedMemoryMB(this.getMetrics().getReservedMB());
        stats.setAvailableVCores((long)this.getMetrics().getAvailableVirtualCores());
        stats.setAllocatedVCores((long)this.getMetrics().getAllocatedVirtualCores());
        stats.setPendingVCores((long)this.getMetrics().getPendingVirtualCores());
        stats.setReservedVCores((long)this.getMetrics().getReservedVirtualCores());
        stats.setAllocatedContainers((long)this.getMetrics().getAllocatedContainers());
        stats.setPendingContainers((long)this.getMetrics().getPendingContainers());
        stats.setReservedContainers((long)this.getMetrics().getReservedContainers());
        return stats;
    }

    @Override
    public FSQueueMetrics getMetrics() {
        return this.metrics;
    }

    @Override
    public Resource getFairShare() {
        return this.fairShare;
    }

    @Override
    public void setFairShare(Resource fairShare) {
        this.fairShare = fairShare;
        this.metrics.setFairShare(fairShare);
        LOG.debug("The updated fairShare for {} is {}", (Object)this.getName(), (Object)fairShare);
    }

    public Resource getSteadyFairShare() {
        return this.steadyFairShare;
    }

    void setSteadyFairShare(Resource steadyFairShare) {
        this.steadyFairShare = steadyFairShare;
        this.metrics.setSteadyFairShare(steadyFairShare);
    }

    @Override
    public boolean hasAccess(QueueACL acl, UserGroupInformation user) {
        return this.authorizer.checkPermission(new AccessRequest(this.queueEntity, user, SchedulerUtils.toAccessType(acl), null, null, Server.getRemoteAddress(), null));
    }

    long getFairSharePreemptionTimeout() {
        return this.fairSharePreemptionTimeout;
    }

    void setFairSharePreemptionTimeout(long fairSharePreemptionTimeout) {
        this.fairSharePreemptionTimeout = fairSharePreemptionTimeout;
    }

    long getMinSharePreemptionTimeout() {
        return this.minSharePreemptionTimeout;
    }

    void setMinSharePreemptionTimeout(long minSharePreemptionTimeout) {
        this.minSharePreemptionTimeout = minSharePreemptionTimeout;
    }

    float getFairSharePreemptionThreshold() {
        return this.fairSharePreemptionThreshold;
    }

    void setFairSharePreemptionThreshold(float fairSharePreemptionThreshold) {
        this.fairSharePreemptionThreshold = fairSharePreemptionThreshold;
    }

    @Override
    public boolean isPreemptable() {
        return this.preemptable;
    }

    abstract void updateInternal();

    public void update(Resource fairShare) {
        this.setFairShare(fairShare);
        this.updateInternal();
    }

    private void updatePreemptionVariables() {
        this.minSharePreemptionTimeout = this.scheduler.getAllocationConfiguration().getMinSharePreemptionTimeout(this.getName());
        if (this.minSharePreemptionTimeout == -1L && this.parent != null) {
            this.minSharePreemptionTimeout = this.parent.getMinSharePreemptionTimeout();
        }
        this.fairSharePreemptionTimeout = this.scheduler.getAllocationConfiguration().getFairSharePreemptionTimeout(this.getName());
        if (this.fairSharePreemptionTimeout == -1L && this.parent != null) {
            this.fairSharePreemptionTimeout = this.parent.getFairSharePreemptionTimeout();
        }
        this.fairSharePreemptionThreshold = this.scheduler.getAllocationConfiguration().getFairSharePreemptionThreshold(this.getName());
        if (this.fairSharePreemptionThreshold < 0.0f && this.parent != null) {
            this.fairSharePreemptionThreshold = this.parent.getFairSharePreemptionThreshold();
        }
        this.preemptable = this.parent != null && !this.parent.isPreemptable() ? false : this.scheduler.getAllocationConfiguration().isPreemptable(this.getName());
    }

    public abstract List<FSQueue> getChildQueues();

    public abstract void collectSchedulerApplications(Collection<ApplicationAttemptId> var1);

    public abstract int getNumRunnableApps();

    boolean assignContainerPreCheck(FSSchedulerNode node) {
        if (node.getReservedContainer() != null) {
            LOG.debug("Assigning container failed on node '{}' because it has reserved containers.", (Object)node.getNodeName());
            return false;
        }
        if (!Resources.fitsIn((Resource)this.getResourceUsage(), (Resource)this.getMaxShare())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Assigning container failed on node '" + node.getNodeName() + " because queue resource usage is larger than MaxShare: " + this.dumpState());
            }
            return false;
        }
        return true;
    }

    public boolean isActive() {
        return this.getNumRunnableApps() > 0;
    }

    public String toString() {
        return String.format("[%s, demand=%s, running=%s, share=%s, w=%s]", this.getName(), this.getDemand(), this.getResourceUsage(), this.fairShare, Float.valueOf(this.getWeight()));
    }

    @Override
    public Set<String> getAccessibleNodeLabels() {
        return null;
    }

    @Override
    public String getDefaultNodeLabelExpression() {
        return null;
    }

    @Override
    public void incPendingResource(String nodeLabel, Resource resourceToInc) {
    }

    @Override
    public void decPendingResource(String nodeLabel, Resource resourceToDec) {
    }

    @Override
    public void incReservedResource(String nodeLabel, Resource resourceToInc) {
    }

    @Override
    public void decReservedResource(String nodeLabel, Resource resourceToDec) {
    }

    @Override
    public Resource getResourceUsage() {
        return this.resourceUsage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incUsedResource(Resource res) {
        Resource resource = this.resourceUsage;
        synchronized (resource) {
            Resources.addTo((Resource)this.resourceUsage, (Resource)res);
            if (this.parent != null) {
                this.parent.incUsedResource(res);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decUsedResource(Resource res) {
        Resource resource = this.resourceUsage;
        synchronized (resource) {
            Resources.subtractFrom((Resource)this.resourceUsage, (Resource)res);
            if (this.parent != null) {
                this.parent.decUsedResource(res);
            }
        }
    }

    @Override
    public Priority getDefaultApplicationPriority() {
        return null;
    }

    boolean fitsInMaxShare(Resource additionalResource) {
        Resource usagePlusAddition = Resources.add((Resource)this.getResourceUsage(), (Resource)additionalResource);
        if (!Resources.fitsIn((Resource)usagePlusAddition, (Resource)this.getMaxShare())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Resource usage plus resource request: " + usagePlusAddition + " exceeds maximum resource allowed:" + this.getMaxShare() + " in queue " + this.getName());
            }
            return false;
        }
        FSParentQueue parentQueue = this.getParent();
        if (parentQueue != null) {
            return parentQueue.fitsInMaxShare(additionalResource);
        }
        return true;
    }

    public boolean verifyAndSetPolicyFromConf(AllocationConfiguration queueConf) {
        SchedulingPolicy queuePolicy = queueConf.getSchedulingPolicy(this.getName());
        for (FSQueue child : this.getChildQueues()) {
            if (!queuePolicy.isChildPolicyAllowed(queueConf.getSchedulingPolicy(child.getName()))) {
                return false;
            }
            boolean success = child.verifyAndSetPolicyFromConf(queueConf);
            if (success) continue;
            return false;
        }
        this.setPolicy(queuePolicy);
        return true;
    }

    public String dumpState() {
        StringBuilder sb = new StringBuilder();
        this.dumpStateInternal(sb);
        return sb.toString();
    }

    protected abstract void dumpStateInternal(StringBuilder var1);

    public boolean isDynamic() {
        return this.isDynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.isDynamic = dynamic;
    }

    public abstract boolean isEmpty();
}

