/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.AccumulatingReducer;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.IOMapperBase;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Partitioner;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JHLogAnalyzer {
    private static final Logger LOG = LoggerFactory.getLogger(JHLogAnalyzer.class);
    private static final String JHLA_ROOT_DIR = System.getProperty("test.build.data", "stats/JHLA");
    private static final Path INPUT_DIR = new Path(JHLA_ROOT_DIR, "jhla_input");
    private static final String BASE_INPUT_FILE_NAME = "jhla_in_";
    private static final Path OUTPUT_DIR = new Path(JHLA_ROOT_DIR, "jhla_output");
    private static final Path RESULT_FILE = new Path(JHLA_ROOT_DIR, "jhla_result.txt");
    private static final Path DEFAULT_HISTORY_DIR = new Path("history");
    private static final int DEFAULT_TIME_INTERVAL_MSEC = 3600000;

    private static void createControlFile(FileSystem fs, Path jhLogDir) throws IOException {
        LOG.info("creating control file: JH log dir = " + jhLogDir);
        FileCreateDaemon.createControlFile(fs, jhLogDir);
        LOG.info("created control file: JH log dir = " + jhLogDir);
    }

    private static String getFileName(int fIdx) {
        return BASE_INPUT_FILE_NAME + Integer.toString(fIdx);
    }

    private static String[] getKeyValue(String t) throws IOException {
        String[] keyVal = t.split("=\"*|\"");
        return keyVal;
    }

    private static void runJHLA(Class<? extends Mapper<Text, LongWritable, Text, Text>> mapperClass, Path outputDir, Configuration fsConfig) throws IOException {
        JobConf job = new JobConf(fsConfig, JHLogAnalyzer.class);
        job.setPartitionerClass(JHLAPartitioner.class);
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{INPUT_DIR});
        job.setInputFormat(SequenceFileInputFormat.class);
        job.setMapperClass(mapperClass);
        job.setReducerClass(AccumulatingReducer.class);
        FileOutputFormat.setOutputPath((JobConf)job, (Path)outputDir);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Text.class);
        job.setNumReduceTasks(9);
        JobClient.runJob((JobConf)job);
    }

    public static void main(String[] args) {
        Path resFileName = RESULT_FILE;
        Configuration conf = new Configuration();
        try {
            conf.setInt("test.io.file.buffer.size", 0);
            Path historyDir = DEFAULT_HISTORY_DIR;
            String testFile = null;
            boolean cleanup = false;
            boolean initControlFiles = true;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equalsIgnoreCase("-historyDir")) {
                    historyDir = new Path(args[++i]);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-resFile")) {
                    resFileName = new Path(args[++i]);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-usersIncluded")) {
                    conf.set("jhla.users.included", args[++i]);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-usersExcluded")) {
                    conf.set("jhla.users.excluded", args[++i]);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-gzip")) {
                    conf.set("jhla.compression.class", GzipCodec.class.getCanonicalName());
                    continue;
                }
                if (args[i].equalsIgnoreCase("-jobDelimiter")) {
                    conf.set("jhla.job.delimiter.pattern", args[++i]);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-jobDelimiterLength")) {
                    conf.setInt("jhla.job.delimiter.length", Integer.parseInt(args[++i]));
                    continue;
                }
                if (args[i].equalsIgnoreCase("-noInit")) {
                    initControlFiles = false;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-test")) {
                    testFile = args[++i];
                    continue;
                }
                if (args[i].equalsIgnoreCase("-clean")) {
                    cleanup = true;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-jobQueue")) {
                    conf.set("mapred.job.queue.name", args[++i]);
                    continue;
                }
                if (args[i].startsWith("-Xmx")) {
                    conf.set("mapred.child.java.opts", args[i]);
                    continue;
                }
                JHLogAnalyzer.printUsage();
            }
            if (cleanup) {
                JHLogAnalyzer.cleanup(conf);
                return;
            }
            if (testFile != null) {
                LOG.info("Start JHLA test ============ ");
                LocalFileSystem lfs = FileSystem.getLocal((Configuration)conf);
                conf.set("fs.defaultFS", "file:///");
                JHLAMapper map = new JHLAMapper(conf);
                map.parseLogFile((FileSystem)lfs, new Path(testFile), 0L, new LoggingCollector(), Reporter.NULL);
                return;
            }
            FileSystem fs = FileSystem.get((Configuration)conf);
            if (initControlFiles) {
                JHLogAnalyzer.createControlFile(fs, historyDir);
            }
            long tStart = System.currentTimeMillis();
            JHLogAnalyzer.runJHLA(JHLAMapper.class, OUTPUT_DIR, conf);
            long execTime = System.currentTimeMillis() - tStart;
            JHLogAnalyzer.analyzeResult(fs, 0, execTime, resFileName);
        }
        catch (IOException e) {
            System.err.print(StringUtils.stringifyException((Throwable)e));
            System.exit(-1);
        }
    }

    private static void printUsage() {
        String className = JHLogAnalyzer.class.getSimpleName();
        System.err.println("Usage: " + className + "\n\t[-historyDir inputDir] | [-resFile resultFile] |\n\t[-usersIncluded | -usersExcluded userList] |\n\t[-gzip] | [-jobDelimiter pattern] |\n\t[-help | -clean | -test testFile]");
        System.exit(-1);
    }

    private static Collection<String> getUserList(String users) {
        if (users == null) {
            return null;
        }
        StringTokenizer tokens = new StringTokenizer(users, ",;");
        ArrayList<String> userList = new ArrayList<String>(tokens.countTokens());
        while (tokens.hasMoreTokens()) {
            userList.add(tokens.nextToken());
        }
        return userList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void analyzeResult(FileSystem fs, int testType, long execTime, Path resFileName) throws IOException {
        LOG.info("Analyzing results ...");
        DataOutputStream out = null;
        BufferedWriter writer = null;
        try {
            out = new DataOutputStream((OutputStream)fs.create(resFileName));
            writer = new BufferedWriter(new OutputStreamWriter(out));
            writer.write("SERIES\tPERIOD\tTYPE\tSLOT_HOUR\n");
            FileStatus[] reduceFiles = fs.listStatus(OUTPUT_DIR);
            assert (reduceFiles.length == 9);
            for (int i = 0; i < 9; ++i) {
                FSDataInputStream in = null;
                BufferedReader lines = null;
                try {
                    String line;
                    in = fs.open(reduceFiles[i].getPath());
                    lines = new BufferedReader(new InputStreamReader((InputStream)in));
                    while ((line = lines.readLine()) != null) {
                        StringTokenizer tokens = new StringTokenizer(line, "\t*");
                        String attr = tokens.nextToken();
                        String dateTime = tokens.nextToken();
                        String taskType = tokens.nextToken();
                        double val = (double)Long.parseLong(tokens.nextToken()) / 3600000.0;
                        writer.write(attr.substring(2));
                        writer.write("\t");
                        writer.write(dateTime);
                        writer.write("\t");
                        writer.write(taskType);
                        writer.write("\t");
                        writer.write(String.valueOf((float)val));
                        writer.newLine();
                    }
                    continue;
                }
                finally {
                    if (lines != null) {
                        lines.close();
                    }
                    if (in != null) {
                        in.close();
                    }
                }
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            if (out != null) {
                out.close();
            }
        }
        LOG.info("Analyzing results ... done.");
    }

    private static void cleanup(Configuration conf) throws IOException {
        LOG.info("Cleaning up test files");
        FileSystem fs = FileSystem.get((Configuration)conf);
        fs.delete(new Path(JHLA_ROOT_DIR), true);
    }

    static {
        Configuration.addDefaultResource((String)"hdfs-default.xml");
        Configuration.addDefaultResource((String)"hdfs-site.xml");
    }

    private static class LoggingCollector
    implements OutputCollector<Text, Text> {
        private LoggingCollector() {
        }

        public void collect(Text key, Text value) throws IOException {
            LOG.info(key + " == " + value);
        }
    }

    public static class JHLAPartitioner
    implements Partitioner<Text, Text> {
        static final int NUM_REDUCERS = 9;

        public void configure(JobConf conf) {
        }

        public int getPartition(Text key, Text value, int numPartitions) {
            IntervalKey intKey = new IntervalKey(key.toString());
            if (intKey.statName.equals(StatSeries.STAT_ALL_SLOT_TIME.toString())) {
                if (intKey.taskType.equals("MAP")) {
                    return 0;
                }
                if (intKey.taskType.equals("REDUCE")) {
                    return 1;
                }
            } else if (intKey.statName.equals(StatSeries.STAT_SUBMIT_PENDING_SLOT_TIME.toString())) {
                if (intKey.taskType.equals("MAP")) {
                    return 2;
                }
                if (intKey.taskType.equals("REDUCE")) {
                    return 3;
                }
            } else if (intKey.statName.equals(StatSeries.STAT_LAUNCHED_PENDING_SLOT_TIME.toString())) {
                if (intKey.taskType.equals("MAP")) {
                    return 4;
                }
                if (intKey.taskType.equals("REDUCE")) {
                    return 5;
                }
            } else if (intKey.statName.equals(StatSeries.STAT_FAILED_SLOT_TIME.toString())) {
                if (intKey.taskType.equals("MAP")) {
                    return 6;
                }
                if (intKey.taskType.equals("REDUCE")) {
                    return 7;
                }
            }
            return 8;
        }
    }

    private static class JHLAMapper
    extends IOMapperBase<Object> {
        String jobDelimiterPattern;
        int maxJobDelimiterLineLength;
        Collection<String> usersIncluded;
        Collection<String> usersExcluded;
        Class<? extends CompressionCodec> compressionClass;
        private StringBuffer resBuffer = new StringBuffer();

        JHLAMapper() throws IOException {
        }

        JHLAMapper(Configuration conf) throws IOException {
            this.configure(new JobConf(conf));
        }

        @Override
        public void configure(JobConf conf) {
            super.configure(conf);
            this.usersIncluded = JHLogAnalyzer.getUserList(conf.get("jhla.users.included", null));
            this.usersExcluded = JHLogAnalyzer.getUserList(conf.get("jhla.users.excluded", null));
            String zipClassName = conf.get("jhla.compression.class", null);
            try {
                this.compressionClass = zipClassName == null ? null : Class.forName(zipClassName).asSubclass(CompressionCodec.class);
            }
            catch (Exception e) {
                throw new RuntimeException("Compression codec not found: ", e);
            }
            this.jobDelimiterPattern = conf.get("jhla.job.delimiter.pattern", null);
            this.maxJobDelimiterLineLength = conf.getInt("jhla.job.delimiter.length", 512);
        }

        @Override
        public void map(Text key, LongWritable value, OutputCollector<Text, Text> output, Reporter reporter) throws IOException {
            String name = key.toString();
            long longValue = value.get();
            reporter.setStatus("starting " + name + " ::host = " + this.hostName);
            long tStart = System.currentTimeMillis();
            this.parseLogFile(this.fs, new Path(name), longValue, output, reporter);
            long tEnd = System.currentTimeMillis();
            long execTime = tEnd - tStart;
            reporter.setStatus("finished " + name + " ::host = " + this.hostName + " in " + execTime / 1000L + " sec.");
        }

        @Override
        public Object doIO(Reporter reporter, String path, long offset) throws IOException {
            return null;
        }

        @Override
        void collectStats(OutputCollector<Text, Text> output, String name, long execTime, Object jobObjects) throws IOException {
        }

        private boolean isEndOfJobLog(String line) {
            if (this.jobDelimiterPattern == null) {
                return false;
            }
            return line.matches(this.jobDelimiterPattern);
        }

        public void parseLogFile(FileSystem fs, Path filePath, long offset, OutputCollector<Text, Text> output, Reporter reporter) throws IOException {
            try (InputStream in = null;){
                FSDataInputStream stm = fs.open(filePath);
                stm.seek(offset);
                in = stm;
                LOG.info("Opened " + filePath);
                reporter.setStatus("Opened " + filePath);
                if (this.compressionClass != null) {
                    CompressionCodec codec = (CompressionCodec)ReflectionUtils.newInstance(this.compressionClass, (Configuration)new Configuration());
                    in = codec.createInputStream((InputStream)stm);
                    LOG.info("Codec created " + filePath);
                    reporter.setStatus("Codec created " + filePath);
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                LOG.info("Reader created " + filePath);
                long processed = 0L;
                if (this.jobDelimiterPattern != null) {
                    String line = reader.readLine();
                    while (line != null) {
                        if (stm.getPos() - processed > 100000L) {
                            processed = stm.getPos();
                            reporter.setStatus("Processing " + filePath + " at " + processed);
                        }
                        if (this.isEndOfJobLog(line)) break;
                        line = reader.readLine();
                    }
                }
                JobHistoryLog jh = new JobHistoryLog();
                int jobLineCount = 0;
                String line = this.readLine(reader);
                while (line != null) {
                    ++jobLineCount;
                    if (stm.getPos() - processed > 20000L) {
                        processed = stm.getPos();
                        long numTasks = jh.tasks == null ? 0 : jh.tasks.size();
                        String txt = "Processing " + filePath + " at " + processed + " # tasks = " + numTasks;
                        reporter.setStatus(txt);
                        LOG.info(txt);
                    }
                    if (this.isEndOfJobLog(line)) {
                        if (jh.JOBID != null) {
                            LOG.info("Finished parsing job: " + jh.JOBID + " line count = " + jobLineCount);
                            this.collectJobStats(jh, output, reporter);
                            LOG.info("Collected stats for job: " + jh.JOBID);
                        }
                        jh = new JobHistoryLog();
                        jobLineCount = 0;
                    } else {
                        jh.parseLine(line);
                    }
                    line = this.readLine(reader);
                }
                if (jh.JOBID == null) {
                    LOG.error("JOBID = NULL in " + filePath + " at " + processed);
                    return;
                }
                this.collectJobStats(jh, output, reporter);
            }
        }

        private String readLine(BufferedReader reader) throws IOException {
            this.resBuffer.setLength(0);
            reader.mark(this.maxJobDelimiterLineLength);
            String line = reader.readLine();
            while (line != null) {
                if (this.isEndOfJobLog(line)) {
                    if (this.resBuffer.length() == 0) {
                        this.resBuffer.append(line);
                        break;
                    }
                    reader.reset();
                    break;
                }
                if (this.resBuffer.length() == 0) {
                    this.resBuffer.append(line);
                } else if (this.resBuffer.length() < 32000) {
                    this.resBuffer.append(line);
                }
                if (line.endsWith(" .") || line.endsWith("\" ")) break;
                reader.mark(this.maxJobDelimiterLineLength);
                line = reader.readLine();
            }
            String result = this.resBuffer.length() == 0 ? null : this.resBuffer.toString();
            this.resBuffer.setLength(0);
            return result;
        }

        private void collectPerIntervalStats(OutputCollector<Text, Text> output, long start, long finish, String taskType, StatSeries ... stats) throws IOException {
            long curInterval = start / 3600000L * 3600000L;
            long curTime = start;
            long accumTime = 0L;
            while (curTime < finish) {
                long nextInterval = curInterval + 3600000L;
                long intervalTime = (finish < nextInterval ? finish : nextInterval) - curTime;
                IntervalKey key = new IntervalKey("", curInterval, taskType);
                Text val = new Text(String.valueOf(intervalTime));
                for (StatSeries statName : stats) {
                    key.setStatName(statName.toString());
                    output.collect((Object)key.getTextKey(), (Object)val);
                }
                curTime = curInterval = nextInterval;
                accumTime += intervalTime;
            }
            assert (accumTime == finish - start || finish < start);
        }

        private void collectJobStats(JobHistoryLog jh, OutputCollector<Text, Text> output, Reporter reporter) throws IOException {
            if (jh == null) {
                return;
            }
            if (jh.tasks == null) {
                return;
            }
            if (jh.SUBMIT_TIME <= 0L) {
                throw new IOException("Job " + jh.JOBID + " SUBMIT_TIME = " + jh.SUBMIT_TIME);
            }
            if (this.usersIncluded != null && !this.usersIncluded.contains(jh.USER)) {
                return;
            }
            if (this.usersExcluded != null && this.usersExcluded.contains(jh.USER)) {
                return;
            }
            int numAttempts = 0;
            long totalTime = 0L;
            boolean jobSuccess = jh.isSuccessful();
            long jobWaitTime = jh.LAUNCH_TIME - jh.SUBMIT_TIME;
            for (TaskHistoryLog th : jh.tasks.values()) {
                if (th.attempts == null) continue;
                long attemptSubmitTime = jh.LAUNCH_TIME;
                boolean taskSuccess = jobSuccess && th.isSuccessful();
                for (TaskAttemptHistoryLog tah : th.attempts.values()) {
                    boolean success;
                    boolean bl = success = taskSuccess && tah.isSuccessful();
                    if (tah.START_TIME == 0L) {
                        LOG.error("Start time 0 for task attempt " + tah.TASK_ATTEMPT_ID);
                        continue;
                    }
                    if (tah.FINISH_TIME < tah.START_TIME) {
                        LOG.error("Finish time " + tah.FINISH_TIME + " is less than Start time " + tah.START_TIME + " for task attempt " + tah.TASK_ATTEMPT_ID);
                        tah.FINISH_TIME = tah.START_TIME;
                    }
                    if (!("MAP".equals(th.TASK_TYPE) || "REDUCE".equals(th.TASK_TYPE) || "CLEANUP".equals(th.TASK_TYPE) || "SETUP".equals(th.TASK_TYPE))) {
                        LOG.error("Unexpected TASK_TYPE = " + th.TASK_TYPE + " for attempt " + tah.TASK_ATTEMPT_ID);
                    }
                    this.collectPerIntervalStats(output, attemptSubmitTime, tah.START_TIME, th.TASK_TYPE, StatSeries.STAT_LAUNCHED_PENDING_SLOT_TIME);
                    this.collectPerIntervalStats(output, attemptSubmitTime - jobWaitTime, tah.START_TIME, th.TASK_TYPE, StatSeries.STAT_SUBMIT_PENDING_SLOT_TIME);
                    if (success) {
                        this.collectPerIntervalStats(output, tah.START_TIME, tah.FINISH_TIME, th.TASK_TYPE, StatSeries.STAT_ALL_SLOT_TIME);
                    } else {
                        this.collectPerIntervalStats(output, tah.START_TIME, tah.FINISH_TIME, th.TASK_TYPE, StatSeries.STAT_ALL_SLOT_TIME, StatSeries.STAT_FAILED_SLOT_TIME);
                    }
                    totalTime += tah.FINISH_TIME - tah.START_TIME;
                    if (++numAttempts % 500 == 0) {
                        reporter.setStatus("Processing " + jh.JOBID + " at " + numAttempts);
                    }
                    attemptSubmitTime = tah.FINISH_TIME;
                }
            }
            LOG.info("Total    Maps = " + jh.TOTAL_MAPS + "  Reduces = " + jh.TOTAL_REDUCES);
            LOG.info("Finished Maps = " + jh.FINISHED_MAPS + "  Reduces = " + jh.FINISHED_REDUCES);
            LOG.info("numAttempts = " + numAttempts);
            LOG.info("totalTime   = " + totalTime);
            LOG.info("averageAttemptTime = " + (numAttempts == 0 ? 0L : totalTime / (long)numAttempts));
            LOG.info("jobTotalTime = " + (jh.FINISH_TIME <= jh.SUBMIT_TIME ? 0L : jh.FINISH_TIME - jh.SUBMIT_TIME));
        }
    }

    private static class IntervalKey {
        static final String KEY_FIELD_DELIMITER = "*";
        String statName;
        String dateTime;
        String taskType;

        IntervalKey(String stat, long timeMSec, String taskType) {
            this.statName = stat;
            SimpleDateFormat dateF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            this.dateTime = dateF.format(new Date(timeMSec));
            this.taskType = taskType;
        }

        IntervalKey(String key) {
            StringTokenizer keyTokens = new StringTokenizer(key, KEY_FIELD_DELIMITER);
            if (!keyTokens.hasMoreTokens()) {
                return;
            }
            this.statName = keyTokens.nextToken();
            if (!keyTokens.hasMoreTokens()) {
                return;
            }
            this.dateTime = keyTokens.nextToken();
            if (!keyTokens.hasMoreTokens()) {
                return;
            }
            this.taskType = keyTokens.nextToken();
        }

        void setStatName(String stat) {
            this.statName = stat;
        }

        String getStringKey() {
            return this.statName + KEY_FIELD_DELIMITER + this.dateTime + KEY_FIELD_DELIMITER + this.taskType;
        }

        Text getTextKey() {
            return new Text(this.getStringKey());
        }

        public String toString() {
            return this.getStringKey();
        }
    }

    private static class TaskAttemptHistoryLog {
        String TASK_ATTEMPT_ID;
        String TASK_STATUS;
        long START_TIME;
        long FINISH_TIME;
        long HDFS_BYTES_READ;
        long HDFS_BYTES_WRITTEN;
        long FILE_BYTES_READ;
        long FILE_BYTES_WRITTEN;

        private TaskAttemptHistoryLog() {
        }

        boolean isSuccessful() {
            return this.TASK_STATUS != null && this.TASK_STATUS.equals("SUCCESS");
        }

        String parse(StringTokenizer tokens) throws IOException {
            String taskID = null;
            while (tokens.hasMoreTokens()) {
                String t = tokens.nextToken();
                String[] keyVal = JHLogAnalyzer.getKeyValue(t);
                if (keyVal.length < 2) continue;
                if (keyVal[0].equals("TASKID")) {
                    if (taskID == null) {
                        taskID = new String(keyVal[1]);
                        continue;
                    }
                    if (taskID.equals(keyVal[1])) continue;
                    LOG.error("Incorrect TASKID: " + keyVal[1] + " expect " + taskID);
                    continue;
                }
                if (keyVal[0].equals("TASK_ATTEMPT_ID")) {
                    if (this.TASK_ATTEMPT_ID == null) {
                        this.TASK_ATTEMPT_ID = new String(keyVal[1]);
                        continue;
                    }
                    if (this.TASK_ATTEMPT_ID.equals(keyVal[1])) continue;
                    LOG.error("Incorrect TASKID: " + keyVal[1] + " expect " + taskID);
                    continue;
                }
                if (keyVal[0].equals("TASK_STATUS")) {
                    this.TASK_STATUS = new String(keyVal[1]);
                    continue;
                }
                if (keyVal[0].equals("START_TIME")) {
                    this.START_TIME = Long.parseLong(keyVal[1]);
                    continue;
                }
                if (!keyVal[0].equals("FINISH_TIME")) continue;
                this.FINISH_TIME = Long.parseLong(keyVal[1]);
            }
            return taskID;
        }

        void updateWith(TaskAttemptHistoryLog from) throws IOException {
            if (this.TASK_ATTEMPT_ID == null) {
                this.TASK_ATTEMPT_ID = from.TASK_ATTEMPT_ID;
            } else if (!this.TASK_ATTEMPT_ID.equals(from.TASK_ATTEMPT_ID)) {
                throw new IOException("Incorrect TASK_ATTEMPT_ID: " + from.TASK_ATTEMPT_ID + " expect " + this.TASK_ATTEMPT_ID);
            }
            if (from.TASK_STATUS != null) {
                this.TASK_STATUS = from.TASK_STATUS;
            }
            if (from.START_TIME > 0L) {
                this.START_TIME = from.START_TIME;
            }
            if (from.FINISH_TIME > 0L) {
                this.FINISH_TIME = from.FINISH_TIME;
            }
            if (from.HDFS_BYTES_READ > 0L) {
                this.HDFS_BYTES_READ = from.HDFS_BYTES_READ;
            }
            if (from.HDFS_BYTES_WRITTEN > 0L) {
                this.HDFS_BYTES_WRITTEN = from.HDFS_BYTES_WRITTEN;
            }
            if (from.FILE_BYTES_READ > 0L) {
                this.FILE_BYTES_READ = from.FILE_BYTES_READ;
            }
            if (from.FILE_BYTES_WRITTEN > 0L) {
                this.FILE_BYTES_WRITTEN = from.FILE_BYTES_WRITTEN;
            }
        }
    }

    private static class TaskHistoryLog {
        String TASKID;
        String TASK_TYPE;
        String TASK_STATUS;
        long START_TIME;
        long FINISH_TIME;
        Map<String, TaskAttemptHistoryLog> attempts;

        TaskHistoryLog() {
        }

        TaskHistoryLog(String taskID) {
            this.TASKID = taskID;
        }

        boolean isSuccessful() {
            return this.TASK_STATUS != null && this.TASK_STATUS.equals("SUCCESS");
        }

        TaskHistoryLog parse(StringTokenizer tokens) throws IOException {
            while (tokens.hasMoreTokens()) {
                String t = tokens.nextToken();
                String[] keyVal = JHLogAnalyzer.getKeyValue(t);
                if (keyVal.length < 2) continue;
                if (keyVal[0].equals("TASKID")) {
                    if (this.TASKID == null) {
                        this.TASKID = new String(keyVal[1]);
                        continue;
                    }
                    if (this.TASKID.equals(keyVal[1])) continue;
                    LOG.error("Incorrect TASKID: " + keyVal[1].substring(0, Math.min(keyVal[1].length(), 100)) + " expect " + this.TASKID);
                    continue;
                }
                if (keyVal[0].equals("TASK_TYPE")) {
                    this.TASK_TYPE = new String(keyVal[1]);
                    continue;
                }
                if (keyVal[0].equals("TASK_STATUS")) {
                    this.TASK_STATUS = new String(keyVal[1]);
                    continue;
                }
                if (keyVal[0].equals("START_TIME")) {
                    this.START_TIME = Long.parseLong(keyVal[1]);
                    continue;
                }
                if (!keyVal[0].equals("FINISH_TIME")) continue;
                this.FINISH_TIME = Long.parseLong(keyVal[1]);
            }
            return this;
        }

        void updateWith(TaskHistoryLog from) throws IOException {
            if (this.TASKID == null) {
                this.TASKID = from.TASKID;
            } else if (!this.TASKID.equals(from.TASKID)) {
                throw new IOException("Incorrect TASKID: " + from.TASKID + " expect " + this.TASKID);
            }
            if (this.TASK_TYPE == null) {
                this.TASK_TYPE = from.TASK_TYPE;
            } else if (!this.TASK_TYPE.equals(from.TASK_TYPE)) {
                LOG.error("Incorrect TASK_TYPE: " + from.TASK_TYPE + " expect " + this.TASK_TYPE + " for task " + this.TASKID);
                return;
            }
            if (from.TASK_STATUS != null) {
                this.TASK_STATUS = from.TASK_STATUS;
            }
            if (from.START_TIME > 0L) {
                this.START_TIME = from.START_TIME;
            }
            if (from.FINISH_TIME > 0L) {
                this.FINISH_TIME = from.FINISH_TIME;
            }
        }

        void updateWith(TaskAttemptHistoryLog attempt) throws IOException {
            TaskAttemptHistoryLog existing;
            if (attempt.TASK_ATTEMPT_ID == null) {
                LOG.error("Unexpected TASK_ATTEMPT_ID = null for task " + this.TASKID);
                return;
            }
            if (this.attempts == null) {
                this.attempts = new HashMap<String, TaskAttemptHistoryLog>();
            }
            if ((existing = this.attempts.get(attempt.TASK_ATTEMPT_ID)) == null) {
                this.attempts.put(attempt.TASK_ATTEMPT_ID, attempt);
            } else {
                existing.updateWith(attempt);
            }
            if (attempt.START_TIME > 0L && (this.START_TIME == 0L || this.START_TIME > attempt.START_TIME)) {
                this.START_TIME = attempt.START_TIME;
            }
        }
    }

    private static class JobHistoryLog {
        String JOBID;
        String JOB_STATUS;
        long SUBMIT_TIME;
        long LAUNCH_TIME;
        long FINISH_TIME;
        long TOTAL_MAPS;
        long TOTAL_REDUCES;
        long FINISHED_MAPS;
        long FINISHED_REDUCES;
        String USER;
        Map<String, TaskHistoryLog> tasks;

        private JobHistoryLog() {
        }

        boolean isSuccessful() {
            return this.JOB_STATUS != null && this.JOB_STATUS.equals("SUCCESS");
        }

        void parseLine(String line) throws IOException {
            StringTokenizer tokens = new StringTokenizer(line);
            if (!tokens.hasMoreTokens()) {
                return;
            }
            String what = tokens.nextToken();
            if (what.equals("Job")) {
                this.updateJob(tokens);
            } else if (what.equals("Task")) {
                this.updateTask(tokens);
            } else if (what.indexOf("Attempt") >= 0) {
                this.updateTaskAttempt(tokens);
            }
        }

        private void updateJob(StringTokenizer tokens) throws IOException {
            while (tokens.hasMoreTokens()) {
                String t = tokens.nextToken();
                String[] keyVal = JHLogAnalyzer.getKeyValue(t);
                if (keyVal.length < 2) continue;
                if (keyVal[0].equals("JOBID")) {
                    if (this.JOBID == null) {
                        this.JOBID = new String(keyVal[1]);
                        continue;
                    }
                    if (this.JOBID.equals(keyVal[1])) continue;
                    LOG.error("Incorrect JOBID: " + keyVal[1].substring(0, Math.min(keyVal[1].length(), 100)) + " expect " + this.JOBID);
                    return;
                }
                if (keyVal[0].equals("JOB_STATUS")) {
                    this.JOB_STATUS = new String(keyVal[1]);
                    continue;
                }
                if (keyVal[0].equals("SUBMIT_TIME")) {
                    this.SUBMIT_TIME = Long.parseLong(keyVal[1]);
                    continue;
                }
                if (keyVal[0].equals("LAUNCH_TIME")) {
                    this.LAUNCH_TIME = Long.parseLong(keyVal[1]);
                    continue;
                }
                if (keyVal[0].equals("FINISH_TIME")) {
                    this.FINISH_TIME = Long.parseLong(keyVal[1]);
                    continue;
                }
                if (keyVal[0].equals("TOTAL_MAPS")) {
                    this.TOTAL_MAPS = Long.parseLong(keyVal[1]);
                    continue;
                }
                if (keyVal[0].equals("TOTAL_REDUCES")) {
                    this.TOTAL_REDUCES = Long.parseLong(keyVal[1]);
                    continue;
                }
                if (keyVal[0].equals("FINISHED_MAPS")) {
                    this.FINISHED_MAPS = Long.parseLong(keyVal[1]);
                    continue;
                }
                if (keyVal[0].equals("FINISHED_REDUCES")) {
                    this.FINISHED_REDUCES = Long.parseLong(keyVal[1]);
                    continue;
                }
                if (!keyVal[0].equals("USER")) continue;
                this.USER = new String(keyVal[1]);
            }
        }

        private void updateTask(StringTokenizer tokens) throws IOException {
            TaskHistoryLog existing;
            TaskHistoryLog task = new TaskHistoryLog().parse(tokens);
            if (task.TASKID == null) {
                LOG.error("TASKID = NULL for job " + this.JOBID);
                return;
            }
            if (this.tasks == null) {
                this.tasks = new HashMap<String, TaskHistoryLog>((int)(this.TOTAL_MAPS + this.TOTAL_REDUCES));
            }
            if ((existing = this.tasks.get(task.TASKID)) == null) {
                this.tasks.put(task.TASKID, task);
            } else {
                existing.updateWith(task);
            }
        }

        private void updateTaskAttempt(StringTokenizer tokens) throws IOException {
            TaskHistoryLog existing;
            TaskAttemptHistoryLog attempt = new TaskAttemptHistoryLog();
            String taskID = attempt.parse(tokens);
            if (taskID == null) {
                return;
            }
            if (this.tasks == null) {
                this.tasks = new HashMap<String, TaskHistoryLog>((int)(this.TOTAL_MAPS + this.TOTAL_REDUCES));
            }
            if ((existing = this.tasks.get(taskID)) == null) {
                existing = new TaskHistoryLog(taskID);
                this.tasks.put(taskID, existing);
            }
            existing.updateWith(attempt);
        }
    }

    private static class FileCreateDaemon
    extends Thread {
        private static final int NUM_CREATE_THREADS = 10;
        private static volatile int numFinishedThreads;
        private static volatile int numRunningThreads;
        private static FileStatus[] jhLogFiles;
        FileSystem fs;
        int start;
        int end;

        FileCreateDaemon(FileSystem fs, int start, int end) {
            this.fs = fs;
            this.start = start;
            this.end = end;
        }

        @Override
        public void run() {
            try {
                for (int i = this.start; i < this.end; ++i) {
                    String name = JHLogAnalyzer.getFileName(i);
                    Path controlFile = new Path(INPUT_DIR, "in_file_" + name);
                    SequenceFile.Writer writer = null;
                    try {
                        writer = SequenceFile.createWriter((FileSystem)this.fs, (Configuration)this.fs.getConf(), (Path)controlFile, Text.class, LongWritable.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.NONE);
                        String logFile = jhLogFiles[i].getPath().toString();
                        writer.append((Writable)new Text(logFile), (Writable)new LongWritable(0L));
                        continue;
                    }
                    catch (Exception e) {
                        throw new IOException(e);
                    }
                    finally {
                        if (writer != null) {
                            writer.close();
                        }
                        writer = null;
                    }
                }
            }
            catch (IOException ex) {
                LOG.error("FileCreateDaemon failed.", (Throwable)ex);
            }
            ++numFinishedThreads;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void createControlFile(FileSystem fs, Path jhLogDir) throws IOException {
            fs.delete(INPUT_DIR, true);
            jhLogFiles = fs.listStatus(jhLogDir);
            numFinishedThreads = 0;
            try {
                int tIdx;
                int start = 0;
                int step = jhLogFiles.length / 10 + (jhLogFiles.length % 10 > 0 ? 1 : 0);
                FileCreateDaemon[] daemons = new FileCreateDaemon[10];
                numRunningThreads = 0;
                for (tIdx = 0; tIdx < 10 && start < jhLogFiles.length; ++tIdx) {
                    int end = Math.min(start + step, jhLogFiles.length);
                    daemons[tIdx] = new FileCreateDaemon(fs, start, end);
                    start += step;
                    ++numRunningThreads;
                }
                for (tIdx = 0; tIdx < numRunningThreads; ++tIdx) {
                    daemons[tIdx].start();
                }
            }
            finally {
                int prevValue = 0;
                while (numFinishedThreads < numRunningThreads) {
                    if (prevValue < numFinishedThreads) {
                        LOG.info("Finished " + numFinishedThreads + " threads out of " + numRunningThreads);
                        prevValue = numFinishedThreads;
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    static enum StatSeries {
        STAT_ALL_SLOT_TIME("l:allSlotTime"),
        STAT_FAILED_SLOT_TIME("l:failedSlotTime"),
        STAT_SUBMIT_PENDING_SLOT_TIME("l:submitPendingSlotTime"),
        STAT_LAUNCHED_PENDING_SLOT_TIME("l:launchedPendingSlotTime");

        private String statName = null;

        private StatSeries(String name) {
            this.statName = name;
        }

        public String toString() {
            return this.statName;
        }
    }
}

