/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.ipc;

import java.net.InetSocketAddress;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"MapReduce", "YARN"})
public abstract class YarnRPC {
    private static final Logger LOG = LoggerFactory.getLogger(YarnRPC.class);

    public abstract Object getProxy(Class var1, InetSocketAddress var2, Configuration var3);

    public abstract void stopProxy(Object var1, Configuration var2);

    public abstract Server getServer(Class var1, Object var2, InetSocketAddress var3, Configuration var4, SecretManager<? extends TokenIdentifier> var5, int var6, String var7);

    public Server getServer(Class protocol, Object instance, InetSocketAddress addr, Configuration conf, SecretManager<? extends TokenIdentifier> secretManager, int numHandlers) {
        return this.getServer(protocol, instance, addr, conf, secretManager, numHandlers, null);
    }

    public static YarnRPC create(Configuration conf) {
        LOG.debug("Creating YarnRPC for {}", (Object)conf.get("yarn.ipc.rpc.class"));
        String clazzName = conf.get("yarn.ipc.rpc.class");
        if (clazzName == null) {
            clazzName = "org.apache.hadoop.yarn.ipc.HadoopYarnProtoRPC";
        }
        try {
            return (YarnRPC)Class.forName(clazzName).newInstance();
        }
        catch (Exception e) {
            throw new YarnRuntimeException((Throwable)e);
        }
    }
}

