/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.assignment.RegionStateNode;
import org.apache.hadoop.hbase.master.assignment.ServerState;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ServerStateNode
implements Comparable<ServerStateNode> {
    private final Set<RegionStateNode> regions;
    private final ServerName serverName;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private volatile ServerState state = ServerState.ONLINE;

    public ServerStateNode(ServerName serverName) {
        this.serverName = serverName;
        this.regions = ConcurrentHashMap.newKeySet();
    }

    public ServerName getServerName() {
        return this.serverName;
    }

    public ServerState getState() {
        return this.state;
    }

    public boolean isInState(ServerState ... expected) {
        boolean expectedState = false;
        if (expected != null) {
            for (int i = 0; i < expected.length; ++i) {
                expectedState |= this.state == expected[i];
            }
        }
        return expectedState;
    }

    void setState(ServerState state) {
        this.state = state;
    }

    public int getRegionCount() {
        return this.regions.size();
    }

    public List<RegionInfo> getRegionInfoList() {
        return this.regions.stream().map(RegionStateNode::getRegionInfo).collect(Collectors.toList());
    }

    public List<RegionInfo> getSystemRegionInfoList() {
        return this.regions.stream().filter(RegionStateNode::isSystemTable).map(RegionStateNode::getRegionInfo).collect(Collectors.toList());
    }

    public void addRegion(RegionStateNode regionNode) {
        this.regions.add(regionNode);
    }

    public void removeRegion(RegionStateNode regionNode) {
        this.regions.remove(regionNode);
    }

    public Lock readLock() {
        return this.lock.readLock();
    }

    public Lock writeLock() {
        return this.lock.writeLock();
    }

    @Override
    public int compareTo(ServerStateNode other) {
        return this.getServerName().compareTo(other.getServerName());
    }

    public int hashCode() {
        return this.getServerName().hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ServerStateNode)) {
            return false;
        }
        return this.compareTo((ServerStateNode)other) == 0;
    }

    public String toString() {
        return this.getServerName() + "/" + (Object)((Object)this.getState()) + "/regionCount=" + this.regions.size() + "/lock=" + this.lock;
    }
}

