/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.mob.MobFileCompactionChore;
import org.apache.hadoop.hbase.mob.TestMobCompactionWithDefaults;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
@Category(value={LargeTests.class})
public class TestMobCompactionRegularRegionBatchMode
extends TestMobCompactionWithDefaults {
    private static final Logger LOG = LoggerFactory.getLogger(TestMobCompactionRegularRegionBatchMode.class);
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMobCompactionRegularRegionBatchMode.class);
    private static final int batchSize = 7;
    private MobFileCompactionChore compactionChore;

    public TestMobCompactionRegularRegionBatchMode(Boolean useFileBasedSFT) {
        super(useFileBasedSFT);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.compactionChore = new MobFileCompactionChore(conf, 7);
    }

    @Override
    protected void additonalConfigSetup() {
        conf.setInt("hbase.mob.major.compaction.region.batch.size", 7);
    }

    @Override
    protected void mobCompactImpl(TableDescriptor tableDescriptor, ColumnFamilyDescriptor familyDescriptor) throws IOException, InterruptedException {
        LOG.debug("compacting {} in batch mode.", (Object)tableDescriptor.getTableName());
        this.compactionChore.performMajorCompactionInBatches(this.admin, tableDescriptor, familyDescriptor);
    }

    @Override
    protected String description() {
        return "regular batch mode";
    }
}

