/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.event;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.directory.api.ldap.model.filter.FilterVisitor;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.schema.normalizers.ConcreteNameComponentNormalizer;
import org.apache.directory.api.ldap.model.schema.normalizers.NameComponentNormalizer;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.event.DirectoryListener;
import org.apache.directory.server.core.api.event.EventService;
import org.apache.directory.server.core.api.event.NotificationCriteria;
import org.apache.directory.server.core.api.event.RegistrationEntry;
import org.apache.directory.server.core.api.normalization.FilterNormalizingVisitor;

class DefaultEventService
implements EventService {
    private List<RegistrationEntry> registrations = new CopyOnWriteArrayList<RegistrationEntry>();
    private DirectoryService directoryService;
    private FilterNormalizingVisitor filterNormalizer;

    public DefaultEventService(DirectoryService directoryService) {
        this.directoryService = directoryService;
        SchemaManager schemaManager = directoryService.getSchemaManager();
        ConcreteNameComponentNormalizer ncn = new ConcreteNameComponentNormalizer(schemaManager);
        this.filterNormalizer = new FilterNormalizingVisitor((NameComponentNormalizer)ncn, schemaManager);
    }

    public void addListener(DirectoryListener listener, NotificationCriteria criteria) throws Exception {
        criteria.getBase().apply(this.directoryService.getSchemaManager());
        ExprNode result = (ExprNode)criteria.getFilter().accept((FilterVisitor)this.filterNormalizer);
        criteria.setFilter(result);
        this.registrations.add(new RegistrationEntry(listener, criteria));
    }

    public void removeListener(DirectoryListener listener) {
        for (RegistrationEntry entry : this.registrations) {
            if (entry.getListener() != listener) continue;
            this.registrations.remove(entry);
        }
    }

    public List<RegistrationEntry> getRegistrationEntries() {
        return Collections.unmodifiableList(this.registrations);
    }
}

