/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.client.impl;

import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.BlockReader;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.client.impl.BlockReaderRemote2;
import org.apache.hadoop.hdfs.client.impl.BlockReaderTestUtil;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.proto.DataTransferProtos;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.log4j.Level;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;

public class TestClientBlockVerification {
    static BlockReaderTestUtil util = null;
    static final Path TEST_FILE = new Path("/test.file");
    static final int FILE_SIZE_K = 256;
    static LocatedBlock testBlock = null;

    @BeforeClass
    public static void setupCluster() throws Exception {
        boolean REPLICATION_FACTOR = true;
        util = new BlockReaderTestUtil(1);
        util.writeFile(TEST_FILE, 256);
        List<LocatedBlock> blkList = util.getFileBlocks(TEST_FILE, 256);
        testBlock = blkList.get(0);
    }

    @Test
    public void testBlockVerification() throws Exception {
        BlockReaderRemote2 reader = (BlockReaderRemote2)Mockito.spy((Object)util.getBlockReader(testBlock, 0, 262144));
        util.readAndCheckEOS((BlockReader)reader, 262144, true);
        ((BlockReaderRemote2)Mockito.verify((Object)reader)).sendReadResult(DataTransferProtos.Status.CHECKSUM_OK);
        reader.close();
    }

    @Test
    public void testIncompleteRead() throws Exception {
        BlockReaderRemote2 reader = (BlockReaderRemote2)Mockito.spy((Object)util.getBlockReader(testBlock, 0, 262144));
        util.readAndCheckEOS((BlockReader)reader, 131072, false);
        ((BlockReaderRemote2)Mockito.verify((Object)reader, (VerificationMode)Mockito.never())).sendReadResult(DataTransferProtos.Status.CHECKSUM_OK);
        reader.close();
    }

    @Test
    public void testCompletePartialRead() throws Exception {
        BlockReaderRemote2 reader = (BlockReaderRemote2)Mockito.spy((Object)util.getBlockReader(testBlock, 0, 131072));
        util.readAndCheckEOS((BlockReader)reader, 131072, true);
        ((BlockReaderRemote2)Mockito.verify((Object)reader)).sendReadResult(DataTransferProtos.Status.CHECKSUM_OK);
        reader.close();
    }

    @Test
    public void testUnalignedReads() throws Exception {
        int[] startOffsets = new int[]{0, 3, 129};
        int[] lengths = new int[]{30, 300, 512, 513, 1025};
        for (int startOffset : startOffsets) {
            for (int length : lengths) {
                DFSClient.LOG.info("Testing startOffset = " + startOffset + " and " + " len=" + length);
                BlockReaderRemote2 reader = (BlockReaderRemote2)Mockito.spy((Object)util.getBlockReader(testBlock, startOffset, length));
                util.readAndCheckEOS((BlockReader)reader, length, true);
                ((BlockReaderRemote2)Mockito.verify((Object)reader)).sendReadResult(DataTransferProtos.Status.CHECKSUM_OK);
                reader.close();
            }
        }
    }

    @AfterClass
    public static void teardownCluster() throws Exception {
        util.shutdown();
    }

    static {
        GenericTestUtils.setLogLevel((Logger)BlockReaderRemote2.LOG, (Level)Level.ALL);
    }
}

