/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.regionserver.ChunkCreator;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.testclassification.CoprocessorTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={CoprocessorTests.class, SmallTests.class})
public class TestRegionObserverStacking {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionObserverStacking.class);
    private static HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    static final Path DIR = TEST_UTIL.getDataTestDir();

    HRegion initHRegion(byte[] tableName, String callingMethod, Configuration conf, byte[] ... families) throws IOException {
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((byte[])tableName));
        for (byte[] family : families) {
            htd.addFamily(new HColumnDescriptor(family));
        }
        ChunkCreator.initialize((int)0x200000, (boolean)false, (long)0L, (float)0.0f, (float)0.0f, null, (float)0.1f);
        HRegionInfo info = new HRegionInfo(htd.getTableName(), null, null, false);
        Path path = new Path(DIR + callingMethod);
        HRegion r = HBaseTestingUtility.createRegionAndWAL((RegionInfo)info, path, conf, (TableDescriptor)htd);
        RegionCoprocessorHost host = new RegionCoprocessorHost(r, (RegionServerServices)Mockito.mock(RegionServerServices.class), conf);
        r.setCoprocessorHost(host);
        return r;
    }

    @Test
    public void testRegionObserverStacking() throws Exception {
        byte[] ROW = Bytes.toBytes((String)"testRow");
        byte[] TABLE = Bytes.toBytes((String)this.getClass().getSimpleName());
        byte[] A = Bytes.toBytes((String)"A");
        byte[][] FAMILIES = new byte[][]{A};
        Configuration conf = TEST_UTIL.getConfiguration();
        HRegion region = this.initHRegion(TABLE, this.getClass().getName(), conf, FAMILIES);
        RegionCoprocessorHost h = region.getCoprocessorHost();
        h.load(ObserverA.class, 0, conf);
        h.load(ObserverB.class, 0x3FFFFFFF, conf);
        h.load(ObserverC.class, Integer.MAX_VALUE, conf);
        Put put = new Put(ROW);
        put.addColumn(A, A, A);
        region.put(put);
        Coprocessor c = h.findCoprocessor(ObserverA.class.getName());
        long idA = ((ObserverA)c).id;
        c = h.findCoprocessor(ObserverB.class.getName());
        long idB = ((ObserverB)c).id;
        c = h.findCoprocessor(ObserverC.class.getName());
        long idC = ((ObserverC)c).id;
        Assert.assertTrue((idA < idB ? 1 : 0) != 0);
        Assert.assertTrue((idB < idC ? 1 : 0) != 0);
        HBaseTestingUtility.closeRegionAndWAL(region);
    }

    public static class ObserverC
    implements RegionCoprocessor,
    RegionObserver {
        long id;

        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public void postPut(ObserverContext<RegionCoprocessorEnvironment> c, Put put, WALEdit edit, Durability durability) throws IOException {
            this.id = EnvironmentEdgeManager.currentTime();
            Threads.sleepWithoutInterrupt((long)10L);
        }
    }

    public static class ObserverB
    implements RegionCoprocessor,
    RegionObserver {
        long id;

        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public void postPut(ObserverContext<RegionCoprocessorEnvironment> c, Put put, WALEdit edit, Durability durability) throws IOException {
            this.id = EnvironmentEdgeManager.currentTime();
            Threads.sleepWithoutInterrupt((long)10L);
        }
    }

    public static class ObserverA
    implements RegionCoprocessor,
    RegionObserver {
        long id;

        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public void postPut(ObserverContext<RegionCoprocessorEnvironment> c, Put put, WALEdit edit, Durability durability) throws IOException {
            this.id = EnvironmentEdgeManager.currentTime();
            Threads.sleepWithoutInterrupt((long)10L);
        }
    }
}

