/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.storefiletracker;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.regionserver.NoSuchColumnFamilyException;
import org.apache.hadoop.hbase.regionserver.StoreUtils;
import org.apache.hadoop.hbase.regionserver.storefiletracker.ModifyStoreFileTrackerProcedure;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.protobuf.ByteString;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ModifyColumnFamilyStoreFileTrackerProcedure
extends ModifyStoreFileTrackerProcedure {
    private byte[] family;

    public ModifyColumnFamilyStoreFileTrackerProcedure() {
    }

    public ModifyColumnFamilyStoreFileTrackerProcedure(MasterProcedureEnv env, TableName tableName, byte[] family, String dstSFT) throws HBaseIOException {
        super(env, tableName, dstSFT);
        this.family = family;
    }

    @Override
    protected void preCheck(TableDescriptor current) throws IOException {
        if (!current.hasColumnFamily(this.family)) {
            throw new NoSuchColumnFamilyException(Bytes.toStringBinary(this.family) + " does not exist for table " + current.getTableName());
        }
    }

    @Override
    protected Configuration createConf(Configuration conf, TableDescriptor current) {
        ColumnFamilyDescriptor cfd = current.getColumnFamily(this.family);
        return StoreUtils.createStoreConfiguration(conf, current, cfd);
    }

    @Override
    protected TableDescriptor createRestoreTableDescriptor(TableDescriptor current, String restoreSFT) {
        ColumnFamilyDescriptor cfd = ColumnFamilyDescriptorBuilder.newBuilder(current.getColumnFamily(this.family)).setConfiguration("hbase.store.file-tracker.impl", restoreSFT).build();
        return TableDescriptorBuilder.newBuilder(current).modifyColumnFamily(cfd).build();
    }

    @Override
    protected TableDescriptor createMigrationTableDescriptor(Configuration conf, TableDescriptor current) {
        ColumnFamilyDescriptorBuilder builder = ColumnFamilyDescriptorBuilder.newBuilder(current.getColumnFamily(this.family));
        this.migrate(conf, builder::setConfiguration);
        return TableDescriptorBuilder.newBuilder(current).modifyColumnFamily(builder.build()).build();
    }

    @Override
    protected TableDescriptor createFinishTableDescriptor(TableDescriptor current) {
        ColumnFamilyDescriptorBuilder builder = ColumnFamilyDescriptorBuilder.newBuilder(current.getColumnFamily(this.family));
        this.finish(builder::setConfiguration, builder::removeConfiguration);
        return TableDescriptorBuilder.newBuilder(current).modifyColumnFamily(builder.build()).build();
    }

    @Override
    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        serializer.serialize(MasterProcedureProtos.ModifyColumnFamilyStoreFileTrackerStateData.newBuilder().setFamily(ByteString.copyFrom(this.family)).build());
    }

    @Override
    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        MasterProcedureProtos.ModifyColumnFamilyStoreFileTrackerStateData data = serializer.deserialize(MasterProcedureProtos.ModifyColumnFamilyStoreFileTrackerStateData.class);
        this.family = data.getFamily().toByteArray();
    }
}

