/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.hbase.HDFSBlocksDistribution;
import org.apache.hadoop.hbase.io.FileLink;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.shaded.com.google.errorprone.annotations.RestrictedApi;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hdfs.client.HdfsDataInputStream;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class InputStreamBlockDistribution {
    private static final Logger LOG = LoggerFactory.getLogger(InputStreamBlockDistribution.class);
    private static final String HBASE_LOCALITY_INPUTSTREAM_DERIVE_ENABLED = "hbase.locality.inputstream.derive.enabled";
    private static final boolean DEFAULT_HBASE_LOCALITY_INPUTSTREAM_DERIVE_ENABLED = false;
    private static final String HBASE_LOCALITY_INPUTSTREAM_DERIVE_CACHE_PERIOD = "hbase.locality.inputstream.derive.cache.period";
    private static final int DEFAULT_HBASE_LOCALITY_INPUTSTREAM_DERIVE_CACHE_PERIOD = 60000;
    private final FSDataInputStream stream;
    private final StoreFileInfo fileInfo;
    private final int cachePeriodMs;
    private HDFSBlocksDistribution hdfsBlocksDistribution;
    private long lastCachedAt;
    private boolean streamUnsupported;

    public InputStreamBlockDistribution(FSDataInputStream stream, StoreFileInfo fileInfo) {
        this.stream = stream;
        this.fileInfo = fileInfo;
        this.cachePeriodMs = fileInfo.getConf().getInt(HBASE_LOCALITY_INPUTSTREAM_DERIVE_CACHE_PERIOD, 60000);
        this.lastCachedAt = EnvironmentEdgeManager.currentTime();
        this.streamUnsupported = false;
        this.hdfsBlocksDistribution = fileInfo.getHDFSBlockDistribution();
    }

    public static boolean isEnabled(Configuration conf) {
        return conf.getBoolean(HBASE_LOCALITY_INPUTSTREAM_DERIVE_ENABLED, false);
    }

    public synchronized HDFSBlocksDistribution getHDFSBlockDistribution() {
        if (EnvironmentEdgeManager.currentTime() - this.lastCachedAt > (long)this.cachePeriodMs) {
            try {
                LOG.debug("Refreshing HDFSBlockDistribution for {}", (Object)this.fileInfo);
                this.computeBlockDistribution();
            }
            catch (IOException e) {
                LOG.warn("Failed to recompute block distribution for {}. Falling back on cached value.", (Object)this.fileInfo, (Object)e);
            }
        }
        return this.hdfsBlocksDistribution;
    }

    private void computeBlockDistribution() throws IOException {
        this.lastCachedAt = EnvironmentEdgeManager.currentTime();
        FSDataInputStream stream = this.fileInfo.isLink() ? FileLink.getUnderlyingFileLinkInputStream(this.stream) : this.stream;
        if (!(stream instanceof HdfsDataInputStream)) {
            if (!this.streamUnsupported) {
                LOG.warn("{} for storeFileInfo={}, isLink={}, is not an HdfsDataInputStream so cannot be used to derive locality. Falling back on cached value.", new Object[]{stream, this.fileInfo, this.fileInfo.isLink()});
                this.streamUnsupported = true;
            }
            return;
        }
        this.streamUnsupported = false;
        this.hdfsBlocksDistribution = FSUtils.computeHDFSBlocksDistribution((HdfsDataInputStream)stream);
    }

    @RestrictedApi(explanation="Should only be called in tests", link="", allowedOnPath=".*/src/test/.*")
    synchronized void setLastCachedAt(long timestamp) {
        this.lastCachedAt = timestamp;
    }

    @RestrictedApi(explanation="Should only be called in tests", link="", allowedOnPath=".*/src/test/.*")
    long getCachePeriodMs() {
        return this.cachePeriodMs;
    }

    @RestrictedApi(explanation="Should only be called in tests", link="", allowedOnPath=".*/src/test/.*")
    boolean isStreamUnsupported() {
        return this.streamUnsupported;
    }
}

