/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot;

import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.origin.Origin;
import org.springframework.boot.origin.OriginLookup;
import org.springframework.boot.system.ApplicationPid;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;

class ApplicationInfoPropertySource
extends MapPropertySource
implements OriginLookup<String> {
    static final String NAME = "applicationInfo";

    ApplicationInfoPropertySource(Class<?> mainClass) {
        super(NAME, ApplicationInfoPropertySource.getProperties(ApplicationInfoPropertySource.readVersion(mainClass)));
    }

    ApplicationInfoPropertySource(String applicationVersion) {
        super(NAME, ApplicationInfoPropertySource.getProperties(applicationVersion));
    }

    @Override
    public Origin getOrigin(String key) {
        return null;
    }

    @Override
    public boolean isImmutable() {
        return true;
    }

    private static Map<String, Object> getProperties(String applicationVersion) {
        ApplicationPid applicationPid;
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (StringUtils.hasText(applicationVersion)) {
            result.put("spring.application.version", applicationVersion);
        }
        if ((applicationPid = new ApplicationPid()).isAvailable()) {
            result.put("spring.application.pid", applicationPid.toLong());
        }
        return result;
    }

    private static String readVersion(Class<?> applicationClass) {
        Package sourcePackage = applicationClass != null ? applicationClass.getPackage() : null;
        return sourcePackage != null ? sourcePackage.getImplementationVersion() : null;
    }

    static void moveToEnd(ConfigurableEnvironment environment2) {
        MutablePropertySources propertySources = environment2.getPropertySources();
        PropertySource<?> propertySource = propertySources.remove(NAME);
        if (propertySource != null) {
            propertySources.addLast(propertySource);
        }
    }
}

