/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.ast;

import io.micronaut.core.annotation.AnnotatedElement;
import io.micronaut.core.annotation.AnnotationMetadataDelegate;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.AnnotationValueBuilder;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.naming.Described;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.inject.ast.ElementModifier;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;

public interface Element
extends AnnotationMetadataDelegate,
AnnotatedElement,
Described {
    public static final Element[] EMPTY_ELEMENT_ARRAY = new Element[0];

    @Override
    @NonNull
    public String getName();

    default public boolean isPackagePrivate() {
        return false;
    }

    public boolean isProtected();

    public boolean isPublic();

    @NonNull
    public Object getNativeType();

    default public Set<ElementModifier> getModifiers() {
        return Collections.emptySet();
    }

    @NonNull
    default public <T extends Annotation> Element annotate(@NonNull String annotationType, @NonNull Consumer<AnnotationValueBuilder<T>> consumer) {
        throw new UnsupportedOperationException("Element of type [" + this.getClass() + "] does not support adding annotations at compilation time");
    }

    default public Element removeAnnotation(@NonNull String annotationType) {
        throw new UnsupportedOperationException("Element of type [" + this.getClass() + "] does not support removing annotations at compilation time");
    }

    default public <T extends Annotation> Element removeAnnotation(@NonNull Class<T> annotationType) {
        return this.removeAnnotation(Objects.requireNonNull(annotationType).getName());
    }

    default public <T extends Annotation> Element removeAnnotationIf(@NonNull Predicate<AnnotationValue<T>> predicate) {
        throw new UnsupportedOperationException("Element of type [" + this.getClass() + "] does not support removing annotations at compilation time");
    }

    default public Element removeStereotype(@NonNull String annotationType) {
        throw new UnsupportedOperationException("Element of type [" + this.getClass() + "] does not support removing annotations at compilation time");
    }

    default public <T extends Annotation> Element removeStereotype(@NonNull Class<T> annotationType) {
        return this.removeStereotype(Objects.requireNonNull(annotationType).getName());
    }

    @NonNull
    default public Element annotate(@NonNull String annotationType) {
        return this.annotate(annotationType, (AnnotationValueBuilder<T> annotationValueBuilder) -> {});
    }

    @NonNull
    default public <T extends Annotation> Element annotate(@NonNull Class<T> annotationType, @NonNull Consumer<AnnotationValueBuilder<T>> consumer) {
        ArgumentUtils.requireNonNull("annotationType", annotationType);
        ArgumentUtils.requireNonNull("consumer", consumer);
        return this.annotate(annotationType.getName(), consumer);
    }

    @NonNull
    default public <T extends Annotation> Element annotate(@NonNull Class<T> annotationType) {
        ArgumentUtils.requireNonNull("annotationType", annotationType);
        return this.annotate(annotationType.getName(), (AnnotationValueBuilder<T> annotationValueBuilder) -> {});
    }

    @NonNull
    default public <T extends Annotation> Element annotate(@NonNull AnnotationValue<T> annotationValue) {
        throw new UnsupportedOperationException("Element of type [" + this.getClass() + "] does not support adding annotations at compilation time");
    }

    @NonNull
    default public String getSimpleName() {
        return this.getName();
    }

    default public boolean isAbstract() {
        return false;
    }

    default public boolean isStatic() {
        return false;
    }

    default public Optional<String> getDocumentation() {
        return Optional.empty();
    }

    default public boolean isPrivate() {
        return !this.isPublic();
    }

    default public boolean isFinal() {
        return false;
    }

    @Override
    @NonNull
    default public String getDescription() {
        return this.getDescription(true);
    }

    @Override
    @NonNull
    default public String getDescription(boolean simple) {
        if (simple) {
            return this.getSimpleName();
        }
        return this.getName();
    }
}

