/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.client.util;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.bind.util.ISO8601Utils;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import io.gsonfire.GsonFireBuilder;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.sql.Date;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import lombok.Generated;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.apache.fineract.client.models.ExternalId;
import org.apache.fineract.client.util.adapter.ExternalIdAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class JSON {
    private final Gson gson;
    private final DateTypeAdapter dateTypeAdapter = new DateTypeAdapter();
    private final SqlDateTypeAdapter sqlDateTypeAdapter = new SqlDateTypeAdapter();
    private final OffsetDateTimeTypeAdapter offsetDateTimeTypeAdapter = new OffsetDateTimeTypeAdapter();
    private final LocalDateTypeAdapter localDateTypeAdapter = new LocalDateTypeAdapter();
    private final ExternalIdAdapter externalIdAdapter = new ExternalIdAdapter();

    public JSON() {
        this.gson = new GsonFireBuilder().createGsonBuilder().registerTypeAdapter(java.util.Date.class, (Object)this.dateTypeAdapter).registerTypeAdapter(Date.class, (Object)this.sqlDateTypeAdapter).registerTypeAdapter(OffsetDateTime.class, (Object)this.offsetDateTimeTypeAdapter).registerTypeAdapter(LocalDate.class, (Object)this.localDateTypeAdapter).registerTypeAdapter(ExternalId.class, (Object)this.externalIdAdapter).create();
    }

    @Generated
    public Gson getGson() {
        return this.gson;
    }

    public static class DateTypeAdapter
    extends TypeAdapter<java.util.Date> {
        private final DateFormat dateFormat = null;

        public void write(JsonWriter out, java.util.Date date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                String value = this.dateFormat != null ? this.dateFormat.format(date) : ISO8601Utils.format((java.util.Date)date, (boolean)true);
                out.value(value);
            }
        }

        public java.util.Date read(JsonReader in) throws IOException {
            try {
                if (Objects.requireNonNull(in.peek()) == JsonToken.NULL) {
                    in.nextNull();
                    return null;
                }
                String date = in.nextString();
                return this.parseDate(date);
            }
            catch (IllegalArgumentException e) {
                throw new JsonParseException((Throwable)e);
            }
        }

        private java.util.Date parseDate(String date) {
            try {
                if (null != this.dateFormat) {
                    return this.dateFormat.parse(date);
                }
                return ISO8601Utils.parse((String)date, (ParsePosition)new ParsePosition(0));
            }
            catch (ParseException e) {
                throw new JsonParseException((Throwable)e);
            }
        }
    }

    public static class SqlDateTypeAdapter
    extends TypeAdapter<Date> {
        private final DateFormat dateFormat = null;

        public void write(JsonWriter out, Date date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                String value = this.dateFormat != null ? this.dateFormat.format(date) : date.toString();
                out.value(value);
            }
        }

        public Date read(JsonReader in) throws IOException {
            JsonToken token = in.peek();
            if (token == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            String date = in.nextString();
            try {
                if (this.dateFormat != null) {
                    return new Date(this.dateFormat.parse(date).getTime());
                }
                return new Date(ISO8601Utils.parse((String)date, (ParsePosition)new ParsePosition(0)).getTime());
            }
            catch (ParseException e) {
                throw new JsonParseException((Throwable)e);
            }
        }
    }

    public static class OffsetDateTimeTypeAdapter
    extends TypeAdapter<OffsetDateTime> {
        private final DateTimeFormatter formatter = DateTimeFormatter.ISO_OFFSET_DATE_TIME;

        public void write(JsonWriter out, OffsetDateTime date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                out.value(this.formatter.format(date));
            }
        }

        public OffsetDateTime read(JsonReader in) throws IOException {
            JsonToken token = in.peek();
            if (token == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            String date = in.nextString();
            if (date.endsWith("+0000")) {
                date = date.substring(0, date.length() - 5) + "Z";
            }
            return OffsetDateTime.parse(date, this.formatter);
        }
    }

    public static class LocalDateTypeAdapter
    extends TypeAdapter<LocalDate> {
        private final DateTimeFormatter formatter = DateTimeFormatter.ISO_LOCAL_DATE;

        public void write(JsonWriter out, LocalDate date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                out.value(this.formatter.format(date));
            }
        }

        public LocalDate read(JsonReader in) throws IOException {
            JsonToken token = in.peek();
            if (token == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            if (token == JsonToken.STRING) {
                String dateString = in.nextString();
                if (dateString != null && !dateString.isEmpty()) {
                    return LocalDate.parse(dateString);
                }
                return null;
            }
            if (token == JsonToken.BEGIN_ARRAY) {
                in.beginArray();
                int year = in.nextInt();
                int month = in.nextInt();
                int day = in.nextInt();
                in.endArray();
                return LocalDate.of(year, month, day);
            }
            throw new JsonParseException("Fineract's API normally always sends LocalDate as e.g. [2009,1,1].. or does it not?! (FINERACT-1220)");
        }
    }

    public static final class GsonCustomConverterFactory
    extends Converter.Factory {
        private final Gson gson;
        private final GsonConverterFactory gsonConverterFactory;

        public static GsonCustomConverterFactory create(Gson gson) {
            return new GsonCustomConverterFactory(gson);
        }

        private GsonCustomConverterFactory(Gson gson) {
            if (gson == null) {
                throw new NullPointerException("gson == null");
            }
            this.gson = gson;
            this.gsonConverterFactory = GsonConverterFactory.create((Gson)gson);
        }

        public Converter<ResponseBody, ?> responseBodyConverter(Type type, Annotation[] annotations, Retrofit retrofit) {
            if (type.equals(String.class)) {
                return new GsonResponseBodyConverterToString(this.gson, type);
            }
            return this.gsonConverterFactory.responseBodyConverter(type, annotations, retrofit);
        }

        public Converter<?, RequestBody> requestBodyConverter(Type type, Annotation[] parameterAnnotations, Annotation[] methodAnnotations, Retrofit retrofit) {
            return this.gsonConverterFactory.requestBodyConverter(type, parameterAnnotations, methodAnnotations, retrofit);
        }
    }

    public static class GsonResponseBodyConverterToString<T>
    implements Converter<ResponseBody, T> {
        private final Gson gson;
        private final Type type;

        GsonResponseBodyConverterToString(Gson gson, Type type) {
            this.gson = gson;
            this.type = type;
        }

        public T convert(ResponseBody value) throws IOException {
            String returned = value.string();
            try {
                return (T)this.gson.fromJson(returned, this.type);
            }
            catch (JsonParseException e) {
                return (T)returned;
            }
        }
    }
}

