/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.serialization;

import java.time.LocalDate;
import java.util.Optional;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanOfficerAssignmentHistory;
import org.apache.fineract.portfolio.loanaccount.exception.LoanOfficerAssignmentDateException;
import org.apache.fineract.portfolio.loanaccount.exception.LoanOfficerUnassignmentDateException;
import org.springframework.stereotype.Component;

@Component
public final class LoanOfficerValidator {
    public void validateUnassignDate(Loan loan, LocalDate unassignDate) {
        Optional latestHistoryRecordOptional = loan.findLatestIncompleteHistoryRecord();
        if (latestHistoryRecordOptional.isEmpty()) {
            return;
        }
        LocalDate startDate = ((LoanOfficerAssignmentHistory)latestHistoryRecordOptional.get()).getStartDate();
        if (DateUtils.isAfter((LocalDate)startDate, (LocalDate)unassignDate)) {
            String errorMessage = "The Loan officer Unassign date(" + String.valueOf(unassignDate) + ") cannot be before its assignment date (" + String.valueOf(startDate) + ").";
            throw new LoanOfficerUnassignmentDateException("cannot.be.before.assignment.date", errorMessage, new Object[]{loan.getId(), loan.getLoanOfficer().getId(), startDate, unassignDate});
        }
        if (DateUtils.isDateInTheFuture((LocalDate)unassignDate)) {
            String errorMessage = "The Loan Officer Unassign date (" + String.valueOf(unassignDate) + ") cannot be in the future.";
            throw new LoanOfficerUnassignmentDateException("cannot.be.a.future.date", errorMessage, new Object[]{unassignDate});
        }
    }

    public void validateReassignment(Loan loan, LocalDate assignmentDate, LoanOfficerAssignmentHistory lastAssignmentRecord) {
        if (loan.isSubmittedOnDateAfter(assignmentDate)) {
            String errorMessage = "The Loan Officer assignment date (" + assignmentDate.toString() + ") cannot be before loan submitted date (" + loan.getSubmittedOnDate().toString() + ").";
            throw new LoanOfficerAssignmentDateException("cannot.be.before.loan.submittal.date", errorMessage, new Object[]{assignmentDate, loan.getSubmittedOnDate()});
        }
        if (lastAssignmentRecord != null && lastAssignmentRecord.isEndDateAfter(assignmentDate)) {
            String errorMessage = "The Loan Officer assignment date (" + String.valueOf(assignmentDate) + ") cannot be before previous Loan Officer unassigned date (" + String.valueOf(lastAssignmentRecord.getEndDate()) + ").";
            throw new LoanOfficerAssignmentDateException("cannot.be.before.previous.unassignement.date", errorMessage, new Object[]{assignmentDate, lastAssignmentRecord.getEndDate()});
        }
        if (DateUtils.isDateInTheFuture((LocalDate)assignmentDate)) {
            String errorMessage = "The Loan Officer assignment date (" + String.valueOf(assignmentDate) + ") cannot be in the future.";
            throw new LoanOfficerAssignmentDateException("cannot.be.a.future.date", errorMessage, new Object[]{assignmentDate});
        }
    }

    public void validateAssignmentDateWithHistory(Loan loan, Optional<LoanOfficerAssignmentHistory> latestHistoryRecord, LocalDate assignmentDate) {
        if (latestHistoryRecord.isPresent() && latestHistoryRecord.get().isBeforeStartDate(assignmentDate)) {
            String errorMessage = "Loan with identifier " + String.valueOf(loan.getId()) + " was already assigned before date " + String.valueOf(assignmentDate);
            throw new LoanOfficerAssignmentDateException("is.before.last.assignment.date", errorMessage, new Object[]{loan.getId(), assignmentDate});
        }
    }
}

