/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.security.service;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.security.constants.TwoFactorConfigurationConstants;
import org.apache.fineract.infrastructure.security.data.OTPRequest;
import org.apache.fineract.infrastructure.security.domain.TwoFactorConfiguration;
import org.apache.fineract.infrastructure.security.domain.TwoFactorConfigurationRepository;
import org.apache.fineract.infrastructure.security.service.TwoFactorConfigurationService;
import org.apache.fineract.useradministration.domain.AppUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(value={"fineract.security.2fa.enabled"})
public class TwoFactorConfigurationServiceImpl
implements TwoFactorConfigurationService {
    private static final String DEFAULT_EMAIL_SUBJECT = "Fineract Two-Factor Authentication Token";
    private static final String DEFAULT_EMAIL_BODY = "Hello {username}.\nYour OTP login token is {token}.";
    private static final String DEFAULT_SMS_TEXT = "Your authentication token for Fineract is {token}.";
    private final TwoFactorConfigurationRepository configurationRepository;

    @Autowired
    public TwoFactorConfigurationServiceImpl(TwoFactorConfigurationRepository configurationRepository) {
        this.configurationRepository = configurationRepository;
    }

    @Cacheable(value={"tfConfig"}, key="T(org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil).getTenant().getTenantIdentifier()")
    public Map<String, Object> retrieveAll() {
        List configurationList = this.configurationRepository.findAll();
        HashMap<String, Object> configurationMap = new HashMap<String, Object>();
        for (TwoFactorConfiguration configuration : configurationList) {
            configurationMap.put(configuration.getName(), configuration.getObjectValue());
        }
        return configurationMap;
    }

    @CacheEvict(value={"tfConfig"}, allEntries=true)
    public Map<String, Object> update(JsonCommand command) {
        TwoFactorConfiguration configuration;
        HashMap<String, Object> actualChanges = new HashMap<String, Object>();
        for (String parameterName : TwoFactorConfigurationConstants.BOOLEAN_PARAMETERS) {
            configuration = this.configurationRepository.findByName(parameterName);
            if (configuration == null || !command.isChangeInBooleanParameterNamed(parameterName, BooleanUtils.toBooleanObject((String)configuration.getValue()))) continue;
            boolean newValue = command.booleanPrimitiveValueOfParameterNamed(parameterName);
            actualChanges.put(parameterName, newValue);
            configuration.setValue(String.valueOf(newValue));
            this.configurationRepository.save((Object)configuration);
        }
        for (String parameterName : TwoFactorConfigurationConstants.STRING_PARAMETERS) {
            configuration = this.configurationRepository.findByName(parameterName);
            if (configuration == null || !command.isChangeInStringParameterNamed(parameterName, configuration.getValue())) continue;
            String newValue = command.stringValueOfParameterNamed(parameterName).trim();
            actualChanges.put(parameterName, newValue);
            configuration.setValue(newValue);
            this.configurationRepository.save((Object)configuration);
        }
        for (String parameterName : TwoFactorConfigurationConstants.NUMBER_PARAMETERS) {
            configuration = this.configurationRepository.findByName(parameterName);
            if (configuration == null || !command.isChangeInIntegerSansLocaleParameterNamed(parameterName, NumberUtils.createInteger((String)configuration.getValue()))) continue;
            Long newValue = command.longValueOfParameterNamed(parameterName);
            actualChanges.put(parameterName, newValue);
            configuration.setValue(String.valueOf(newValue));
            this.configurationRepository.save((Object)configuration);
        }
        if (!actualChanges.isEmpty()) {
            this.configurationRepository.flush();
        }
        return actualChanges;
    }

    @Cacheable(value={"tfConfig"}, key="T(org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil).getTenant().getTenantIdentifier()+'|smsEnabled'")
    public boolean isSMSEnabled() {
        return this.getBooleanConfig("otp-delivery-sms-enable", false);
    }

    @Cacheable(value={"tfConfig"}, key="T(org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil).getTenant().getTenantIdentifier()+'|smsProvider'")
    public Integer getSMSProviderId() {
        Integer value = this.getIntegerConfig("otp-delivery-sms-provider", null);
        if (value == null || value < 1) {
            return null;
        }
        return value;
    }

    @Cacheable(value={"tfConfig"}, key="T(org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil).getTenant().getTenantIdentifier()+'|smsText'")
    public String getSmsText() {
        return this.getStringConfig("otp-delivery-sms-text", DEFAULT_SMS_TEXT);
    }

    @Cacheable(value={"tfConfig"}, key="T(org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil).getTenant().getTenantIdentifier()+'|emailEnabled'")
    public boolean isEmailEnabled() {
        return this.getBooleanConfig("otp-delivery-email-enable", false);
    }

    @Cacheable(value={"tfConfig"}, key="T(org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil).getTenant().getTenantIdentifier()+'|emailSubject'")
    public String getEmailSubject() {
        return this.getStringConfig("otp-delivery-email-subject", DEFAULT_EMAIL_SUBJECT);
    }

    @Cacheable(value={"tfConfig"}, key="T(org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil).getTenant().getTenantIdentifier()+'|emailBody'")
    public String getEmailBody() {
        return this.getStringConfig("otp-delivery-email-body", DEFAULT_EMAIL_BODY);
    }

    public String getFormattedEmailSubjectFor(AppUser user, OTPRequest request) {
        Map templateData = this.processTemplateDataFor(user, request);
        return this.compileTextTemplate(this.getEmailSubject(), "email", templateData);
    }

    public String getFormattedEmailBodyFor(AppUser user, OTPRequest request) {
        Map templateData = this.processTemplateDataFor(user, request);
        return this.compileTextTemplate(this.getEmailBody(), "email", templateData);
    }

    public String getFormattedSmsTextFor(AppUser user, OTPRequest request) {
        Map templateData = this.processTemplateDataFor(user, request);
        return this.compileTextTemplate(this.getSmsText(), "sms", templateData);
    }

    @Cacheable(value={"tfConfig"}, key="T(org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil).getTenant().getTenantIdentifier()+'|otpLength'")
    public Integer getOTPTokenLength() {
        Integer defaultValue = 1;
        return this.getIntegerConfig("otp-token-length", defaultValue);
    }

    @Cacheable(value={"tfConfig"}, key="T(org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil).getTenant().getTenantIdentifier()+'|otpTime'")
    public Integer getOTPTokenLiveTime() {
        Integer defaultValue = 300;
        Integer value = this.getIntegerConfig("otp-token-live-time", defaultValue);
        if (value < 1) {
            return defaultValue;
        }
        return value;
    }

    @Cacheable(value={"tfConfig"}, key="T(org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil).getTenant().getTenantIdentifier()+'|tokenTime'")
    public Integer getAccessTokenLiveTime() {
        Integer defaultValue = 86400;
        Integer value = this.getIntegerConfig("access-token-live-time", defaultValue);
        if (value < 1) {
            return defaultValue;
        }
        return value;
    }

    @Cacheable(value={"tfConfig"}, key="T(org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil).getTenant().getTenantIdentifier()+'|tokenExtendedTime'")
    public Integer getAccessTokenExtendedLiveTime() {
        Integer defaultValue = 604800;
        Integer value = this.getIntegerConfig("access-token-live-time-extended", defaultValue);
        if (value < 1) {
            return defaultValue;
        }
        return value;
    }

    private boolean getBooleanConfig(String name, boolean defaultValue) {
        TwoFactorConfiguration configuration = this.configurationRepository.findByName(name);
        Boolean value = BooleanUtils.toBooleanObject((String)configuration.getValue());
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    private String getStringConfig(String name, String defaultValue) {
        TwoFactorConfiguration configuration = this.configurationRepository.findByName(name);
        String value = configuration.getValue();
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    private Integer getIntegerConfig(String name, Integer defaultValue) {
        TwoFactorConfiguration configuration = this.configurationRepository.findByName(name);
        Integer value = NumberUtils.createInteger((String)configuration.getValue());
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    private Map<String, Object> processTemplateDataFor(AppUser user, OTPRequest request) {
        HashMap<String, Object> templateData = new HashMap<String, Object>();
        templateData.put("username", user.getUsername());
        templateData.put("email", user.getEmail());
        templateData.put("firstname", user.getFirstname());
        templateData.put("lastname", user.getLastname());
        if (user.getStaff() != null && user.getStaff().mobileNo() != null) {
            templateData.put("mobileno", user.getStaff().mobileNo());
        }
        templateData.put("token", request.getToken());
        templateData.put("tokenlivetime", request.getMetadata().getTokenLiveTimeInSec());
        DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("HH:mm:ss");
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy");
        LocalDateTime requestTime = request.getMetadata().getRequestTime().toLocalDateTime();
        LocalDateTime expireTime = requestTime.plusSeconds(request.getMetadata().getTokenLiveTimeInSec());
        templateData.put("requestdate", requestTime.toLocalDate().format(dateFormatter));
        templateData.put("requesttime", requestTime.toLocalTime().format(timeFormatter));
        templateData.put("expiredate", expireTime.toLocalDate().format(dateFormatter));
        templateData.put("expiretime", expireTime.toLocalTime().format(timeFormatter));
        return templateData;
    }

    private String compileTextTemplate(String template, String name, Map<String, Object> params) {
        DefaultMustacheFactory mf = new DefaultMustacheFactory();
        Mustache mustache = mf.compile((Reader)new StringReader(template), name);
        StringWriter stringWriter = new StringWriter();
        mustache.execute((Writer)stringWriter, params);
        return stringWriter.toString();
    }
}

