/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.configuration.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Collection;
import lombok.Generated;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.configuration.api.ExternalServiceConfigurationApiConstant;
import org.apache.fineract.infrastructure.configuration.api.ExternalServicesConfigurationApiResourceSwagger;
import org.apache.fineract.infrastructure.configuration.data.ExternalServicesPropertiesData;
import org.apache.fineract.infrastructure.configuration.service.ExternalServicesPropertiesReadPlatformService;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.ToApiJsonSerializer;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.springframework.stereotype.Component;

@Path(value="/v1/externalservice")
@Component
@Tag(name="External Services", description="External Services Configuration related to set of supported configurations for third party services like Amazon S3 and SMTP:\n\nS3 (Amazon S3):\ns3_access_key -\ns3_bucket_name -\ns3_secret_key -\n\n\nSMTP (Email Service):\nusername -\npassword -\nhost -\nport -\nuseTLS -")
public class ExternalServicesConfigurationApiResource {
    private final PlatformSecurityContext context;
    private final ExternalServicesPropertiesReadPlatformService externalServicePropertiesReadPlatformService;
    private final ToApiJsonSerializer<ExternalServicesPropertiesData> toApiJsonSerializer;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;

    @GET
    @Path(value="{servicename}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve External Services Configuration", description="Returns a external Service configurations based on the Service Name.\n\nService Names supported are S3 and SMTP.\n\nExample Requests:\n\nexternalservice/SMTP")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ExternalServicesPropertiesData.class))})})
    public String retrieveOne(@PathParam(value="servicename") @Parameter(description="servicename") String serviceName, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("externalServiceConfiguration");
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        Collection externalServiceNVPs = this.externalServicePropertiesReadPlatformService.retrieveOne(serviceName);
        return this.toApiJsonSerializer.serialize(settings, externalServiceNVPs, ExternalServiceConfigurationApiConstant.EXTERNAL_SERVICE_CONFIGURATION_DATA_PARAMETERS);
    }

    @PUT
    @Path(value="{servicename}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update External Service", description="Updates the external Service Configuration for a Service Name.\n\nExample: \n\nexternalservice/S3")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=ExternalServicesConfigurationApiResourceSwagger.PutExternalServiceRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    public String updateExternalServiceProperties(@PathParam(value="servicename") @Parameter(description="servicename") String serviceName, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().updateExternalServiceProperties(serviceName).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @Generated
    public ExternalServicesConfigurationApiResource(PlatformSecurityContext context, ExternalServicesPropertiesReadPlatformService externalServicePropertiesReadPlatformService, ToApiJsonSerializer<ExternalServicesPropertiesData> toApiJsonSerializer, ApiRequestParameterHelper apiRequestParameterHelper, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService) {
        this.context = context;
        this.externalServicePropertiesReadPlatformService = externalServicePropertiesReadPlatformService;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
    }
}

